/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.DoWhileNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.DoWhileConfigrationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class DoWhileNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private DoWhileNode node;
    private DoWhileConfigrationDialog configurationWindow;
    private Polygon polygon;
    private GeneralPath generalPath;

    public DoWhileNodeGUI(DoWhileNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configurationWindow == null) {
            this.configurationWindow = new DoWhileConfigrationDialog(this.node, xbayaGUI);
        }
        this.configurationWindow.show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected GeneralPath getComponentHeaderShape() {
        return DrawUtils.getRoundedShape(this.createHeader(this.getPosition()));
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    private Polygon createHeader(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y + this.headHeight / 2);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        head.addPoint(position.x + this.dimension.width / 2, position.y);
        return head;
    }

    @Override
    protected void setPortPositions() {
        Point offset;
        List inputPorts = this.node.getInputPorts();
        for (int i = 0; i < inputPorts.size(); ++i) {
            Port port = (Port)inputPorts.get(i);
            offset = new Point(5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        List outputPorts = this.node.getOutputPorts();
        for (int i = 0; i < outputPorts.size(); ++i) {
            Port port = (Port)outputPorts.get(i);
            Point offset2 = new Point(this.getBounds().width - 5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset2);
        }
        ControlPort controlInPort = this.node.getControlInPort();
        if (controlInPort != null) {
            offset = new Point(0, this.headHeight / 2);
            NodeController.getGUI((Port)controlInPort).setOffset(offset);
        }
        List controlOutPorts = this.node.getControlOutPorts();
        Port controlOutPort1 = (Port)controlOutPorts.get(0);
        Point offset3 = new Point(this.getBounds().width, this.headHeight / 2);
        NodeController.getGUI(controlOutPort1).setOffset(offset3);
        Port controlOutPort2 = (Port)controlOutPorts.get(1);
        offset3 = new Point(this.getBounds().width, this.getBounds().height - this.headHeight / 2);
        NodeController.getGUI(controlOutPort2).setOffset(offset3);
    }

    private void calculatePositions() {
        this.polygon.reset();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y + this.headHeight / 2);
        this.polygon.addPoint(position.x, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width / 2, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width / 2, position.y);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }
}

