/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.workflow.model.graph.system.DifferedInputNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.system.DifferedInputConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;

public class DifferedInputNodeGUI
extends ConfigurableNodeGUI {
    private static final String CONFIG_AREA_STRING = "Config";
    private static final Color HEAD_COLOR = new Color(153, 204, 255);
    private DifferedInputNode inputNode;
    private DifferedInputConfigurationDialog configurationWindow;
    private volatile boolean configCanBeDisplayed = true;

    public DifferedInputNodeGUI(DifferedInputNode node) {
        super((NodeImpl)node);
        this.inputNode = node;
        this.setConfigurationText(CONFIG_AREA_STRING);
        this.headColor = HEAD_COLOR;
    }

    @Override
    public void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.testAndSetConfigDisplay()) {
            if (this.inputNode.isConnected()) {
                if (this.configurationWindow == null) {
                    this.configurationWindow = new DifferedInputConfigurationDialog(this.inputNode, xbayaGUI);
                }
                this.configurationWindow.show();
            } else {
                xbayaGUI.getErrorWindow().info("You need to connect the input to an input of a service first to configure.");
            }
        }
    }

    protected synchronized boolean testAndSetConfigDisplay() {
        if (this.configCanBeDisplayed) {
            this.configCanBeDisplayed = false;
            return true;
        }
        return false;
    }

    public synchronized void closingDisplay() {
        this.configCanBeDisplayed = true;
    }

    public DifferedInputNode getInputNode() {
        return this.inputNode;
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }
}

