/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.util.List;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.DifferedInputNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.graph.system.DifferedInputNodeGUI;

public class DifferedInputHandler {
    public static void handleDifferredInputsofDependentNodes(Node node, final XBayaGUI xbayaGUI) {
        List inputPorts = node.getInputPorts();
        for (DataPort dataPort : inputPorts) {
            DifferedInputNode differedInputNode;
            Node fromNode = dataPort.getFromNode();
            if (!DifferedInputHandler.isDifferedInputNode(fromNode) || (differedInputNode = (DifferedInputNode)fromNode).isConfigured()) continue;
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    ((DifferedInputNodeGUI)NodeController.getGUI((Node)differedInputNode)).showConfigurationDialog(xbayaGUI);
                }
            };
            new Thread(task).start();
        }
    }

    public static boolean onlyWaitingOnIncompleteDifferedInputNode(Node node) {
        List inputPorts = node.getInputPorts();
        boolean atleadOneDifferedInputNodeIsIncomplete = false;
        for (DataPort dataPort : inputPorts) {
            Node fromNode = dataPort.getFromNode();
            if (NodeController.isFinished(fromNode)) continue;
            if (DifferedInputHandler.isDifferedInputNode(fromNode)) {
                if (((DifferedInputNode)node).isConfigured()) continue;
                atleadOneDifferedInputNodeIsIncomplete = true;
                continue;
            }
            return false;
        }
        return atleadOneDifferedInputNodeIsIncomplete;
    }

    public static boolean isDifferedInputNode(Node node) {
        return node instanceof DifferedInputNode;
    }
}

