/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;

public abstract class ConfigurableNodeGUI
extends NodeGUI {
    protected static final Color CONFIG_AREA_COLOR = new Color(220, 220, 220);
    protected static final String DEFAULT_CONFIG_AREA_TEXT = "Config";
    protected static final int CONFIG_AREA_GAP_X = 20;
    protected String configurationText = "Config";
    protected RoundRectangle2D configurationArea;

    public ConfigurableNodeGUI(NodeImpl node) {
        super((Node)node);
    }

    public void setConfigurationText(String text) {
        this.configurationText = text;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        if (this.isInConfig(event.getPoint())) {
            this.showConfigurationDialog(engine.getGUI());
        }
    }

    protected abstract void showConfigurationDialog(XBayaGUI var1);

    @Override
    protected boolean isInConfig(Point point) {
        return this.configurationArea.contains(point);
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        Point position = this.node.getPosition();
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight() + 4 + 1;
        int w = this.dimension.width - 40;
        int x = position.x + 20;
        int y = position.y + this.headHeight + (this.dimension.height - this.headHeight - h) / 2;
        this.configurationArea = new RoundRectangle2D.Float(x, y, w, h, 10.0f, 10.0f);
    }

    @Override
    protected final void paint(Graphics2D g) {
        super.paint(g);
        this.drawComponentConfiguration(g);
    }

    protected void drawComponentConfiguration(Graphics2D g) {
        String s = this.configurationText;
        g.setColor(CONFIG_AREA_COLOR);
        g.fill(this.configurationArea);
        g.setColor(TEXT_COLOR);
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(s, g);
        g.drawString(s, (int)(this.configurationArea.getX() + (this.configurationArea.getWidth() - bounds.getWidth()) / 2.0), (int)(this.configurationArea.getY() + (this.configurationArea.getHeight() + bounds.getHeight() / 2.0) / 2.0));
    }
}

