/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.system;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.BlockNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;

public class BlockNodeGUI
extends NodeGUI {
    private static final int HEIGHT = 100;
    private BlockNode node;

    public BlockNodeGUI(BlockNode node) {
        super((Node)node);
        this.node = node;
    }

    @Override
    protected void calculatePositions(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        this.headHeight = fm.getHeight() + 4;
        this.dimension.height = this.headHeight + 10 + 100;
        this.dimension.width = fm.stringWidth(this.node.getID() + 10);
        this.setPortPositions();
    }

    @Override
    protected void setPortPositions() {
        ControlPort controlInPort = this.node.getControlInPort();
        if (controlInPort != null) {
            NodeController.getGUI((Port)controlInPort).setOffset(new Point(0, 0));
        }
        List controlOutPorts = this.node.getControlOutPorts();
        Port controlOutPort1 = (Port)controlOutPorts.get(0);
        Point offset = new Point(this.getBounds().width, this.getBounds().height / 2);
        NodeController.getGUI(controlOutPort1).setOffset(offset);
        Port controlOutPort2 = (Port)controlOutPorts.get(1);
        offset = new Point(this.getBounds().width, this.getBounds().height);
        NodeController.getGUI(controlOutPort2).setOffset(offset);
    }
}

