/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.subworkflow;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.subworkflow.SubWorkflowNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubWorkflowNodeGUI
extends NodeGUI {
    private static final Logger logger = LoggerFactory.getLogger(SubWorkflowNodeGUI.class);
    private SubWorkflowNode node;
    private static final Color HEAD_COLOR = new Color(138, 43, 226);

    public SubWorkflowNodeGUI(SubWorkflowNode node) {
        super((Node)node);
        this.node = node;
        this.setHeadColor(HEAD_COLOR);
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        logger.debug(event.toString());
        if (event.getClickCount() >= 2) {
            this.openWorkflowTab(engine.getGUI());
        }
    }

    @Override
    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : HEAD_COLOR;
    }

    public void openWorkflowTab(XBayaGUI xbayaGUI) {
        try {
            Workflow workflow = this.node.getComponent().getWorkflow();
            xbayaGUI.selectOrCreateGraphCanvas(workflow);
        }
        catch (GraphException e) {
            xbayaGUI.getErrorWindow().error("The workflow file is in wrong format.", e);
        }
        catch (ComponentException e) {
            xbayaGUI.getErrorWindow().error("The component is in wrong format.", e);
        }
    }
}

