/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.dynamic;

import java.awt.event.MouseEvent;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.dynamic.DynamicNode;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.graph.dynamic.DynamicNodeWindow;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicNodeGUI
extends NodeGUI {
    private static final Logger logger = LoggerFactory.getLogger(DynamicNodeGUI.class);
    private DynamicNode node;
    private DynamicNodeWindow window;

    public DynamicNodeGUI(DynamicNode node) {
        super((Node)node);
        this.node = node;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        logger.debug(event.toString());
        if (event.getClickCount() >= 2) {
            this.showWindow(engine);
        }
    }

    private void showWindow(XBayaEngine engine) {
        if (this.window == null) {
            this.window = new DynamicNodeWindow(engine, this.node);
        }
        try {
            this.window.show();
        }
        catch (Throwable e) {
            engine.getGUI().getErrorWindow().error(e);
        }
    }
}

