/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.amazon;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.amazon.TerminateInstanceNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.NodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class TerminateInstanceNodeGUI
extends NodeGUI {
    private TerminateInstanceNode node;
    private Polygon polygon;
    private GeneralPath generalPath;

    public TerminateInstanceNodeGUI(TerminateInstanceNode node) {
        super((Node)node);
        this.node = node;
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.polygon.getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected void paint(Graphics2D g) {
        Point position = this.getPosition();
        if (this.dragged) {
            g.setColor(DRAGGED_BODY_COLOR);
        } else {
            g.setColor(this.bodyColor);
        }
        this.drawBody(g, this.generalPath, g.getColor());
        Polygon head = this.createHeader(position);
        this.drawHeader(g, DrawUtils.getRoundedShape(head), this.node.getName(), this.headColor);
        this.drawEdge(g, this.generalPath, EDGE_COLOR);
        this.drawPorts(g, (Node)this.node);
    }

    private Polygon createHeader(Point position) {
        Polygon head = new Polygon();
        head.addPoint(position.x, position.y);
        head.addPoint(position.x, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight);
        head.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        return head;
    }

    @Override
    protected void setPortPositions() {
        List inputPorts = this.node.getInputPorts();
        for (int i = 0; i < inputPorts.size(); ++i) {
            Port port = (Port)inputPorts.get(i);
            Point offset = new Point(5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        List outputPorts = this.node.getOutputPorts();
        for (int i = 0; i < outputPorts.size(); ++i) {
            Port port = (Port)outputPorts.get(i);
            Point offset = new Point(this.getBounds().width - 5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        ControlPort controlInPort = this.node.getControlInPort();
        NodeController.getGUI((Port)controlInPort).setOffset(new Point(0, 0));
    }

    private void calculatePositions() {
        this.polygon.reset();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y);
        this.polygon.addPoint(position.x, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height + this.headHeight / 2);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.headHeight / 2);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.generalPath);
    }
}

