/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph.amazon;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.workflow.model.graph.impl.NodeImpl;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.graph.amazon.InstanceConfigurationDialog;
import org.apache.airavata.xbaya.ui.graph.system.ConfigurableNodeGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class InstanceNodeGUI
extends ConfigurableNodeGUI {
    private InstanceNode node;
    private Polygon polygon;
    private GeneralPath generalPath;
    private InstanceConfigurationDialog configDialog;

    public InstanceNodeGUI(InstanceNode node) {
        super((NodeImpl)node);
        this.node = node;
        this.polygon = new Polygon();
        this.generalPath = new GeneralPath();
    }

    @Override
    protected void showConfigurationDialog(XBayaGUI xbayaGUI) {
        if (this.configDialog == null) {
            this.configDialog = new InstanceConfigurationDialog(this.node, xbayaGUI);
        }
        this.configDialog.show();
    }

    @Override
    protected void calculatePositions(Graphics g) {
        super.calculatePositions(g);
        this.calculatePositions();
        this.setPortPositions();
    }

    @Override
    protected Rectangle getBounds() {
        return this.getComponentShape().getBounds();
    }

    @Override
    protected boolean isIn(Point point) {
        return this.polygon.contains(point);
    }

    @Override
    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    @Override
    protected String getComponentHeaderText() {
        return this.node.getName();
    }

    @Override
    protected GeneralPath getComponentShape() {
        return this.generalPath;
    }

    @Override
    protected RoundRectangle2D getComponentHeaderShape() {
        RoundRectangle2D.Double componentHeaderBoundaryRect = new RoundRectangle2D.Double(this.getPosition().x, this.getPosition().y, this.dimension.width, this.headHeight, 10.0, 10.0);
        return componentHeaderBoundaryRect;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    @Override
    protected void setPortPositions() {
        Point offset;
        List inputPorts = this.node.getInputPorts();
        for (int i = 0; i < inputPorts.size(); ++i) {
            Port port = (Port)inputPorts.get(i);
            Point offset2 = new Point(5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset2);
        }
        List outputPorts = this.node.getOutputPorts();
        for (int i = 0; i < outputPorts.size(); ++i) {
            Port port = (Port)outputPorts.get(i);
            offset = new Point(this.getBounds().width - 5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        List controlOutPorts = this.node.getControlOutPorts();
        Port controlOutPort1 = (Port)controlOutPorts.get(0);
        offset = new Point(this.getBounds().width / 2, this.getBounds().height);
        NodeController.getGUI(controlOutPort1).setOffset(offset);
    }

    private void calculatePositions() {
        this.polygon.reset();
        Point position = this.getPosition();
        this.polygon.addPoint(position.x, position.y);
        this.polygon.addPoint(position.x, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width / 2, position.y + this.dimension.height + this.headHeight);
        this.polygon.addPoint(position.x + this.dimension.width, position.y + this.dimension.height);
        this.polygon.addPoint(position.x + this.dimension.width, position.y);
        DrawUtils.setupRoundedGeneralPath(this.polygon, this.getComponentShape());
    }
}

