/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.graph.GraphPieceGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class PortGUI
implements GraphPieceGUI {
    public static final int DATA_PORT_SIZE = 10;
    public static final int CONTROL_PORT_SIZE = 6;
    private static final Color DATA_IN_COLOR = Color.BLUE;
    private static final Color DATA_OUT_COLOR = Color.GREEN;
    private static final Color CONTROL_IN_COLOR = Color.RED;
    private static final Color CONTROL_OUT_COLOR = Color.RED;
    private static final Color EPR_COLOR = Color.GREEN;
    private static final Color SELECTED_COLOR = Color.PINK;
    protected static final Color TEXT_COLOR = Color.black;
    private static final int TOKEN_SIZE = 22;
    private static final Color TOKEN_COLOR = Color.GREEN;
    private List<String> tokens = new LinkedList<String>();
    private Port port;
    private String portText = null;
    private Point offset;
    private boolean selected = false;

    public PortGUI(Port port) {
        this.port = port;
        this.offset = new Point();
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
    }

    public void paint(Graphics2D g) {
        Port.Kind kind = this.port.getKind();
        Color color = null;
        switch (kind) {
            case DATA_IN: {
                color = this.selected ? SELECTED_COLOR : DATA_IN_COLOR;
                break;
            }
            case DATA_OUT: {
                color = this.selected ? SELECTED_COLOR : DATA_OUT_COLOR;
                break;
            }
            case CONTROL_IN: {
                color = this.selected ? SELECTED_COLOR : CONTROL_IN_COLOR;
                break;
            }
            case CONTROL_OUT: {
                color = this.selected ? SELECTED_COLOR : CONTROL_OUT_COLOR;
                break;
            }
            case EPR: {
                color = this.selected ? SELECTED_COLOR : EPR_COLOR;
            }
        }
        Point point = this.getPosition();
        Shape shape = null;
        switch (kind) {
            case DATA_IN: {
                shape = this.drawPortArrow(point);
                int count = 0;
                String[] tokenArray = new String[this.tokens.size()];
                this.tokens.toArray(tokenArray);
                for (String token : tokenArray) {
                    g.setColor(TOKEN_COLOR);
                    g.fill(new Ellipse2D.Double(point.x + 22, point.y + 22 * count, 22.0, 11.0));
                    g.setColor(TEXT_COLOR);
                    g.drawString(token, point.x + 66, point.y + 22 * count);
                    ++count;
                }
                break;
            }
            case DATA_OUT: {
                shape = this.drawPortArrow(point);
                int count = 0;
                String[] tokenArray = new String[this.tokens.size()];
                this.tokens.toArray(tokenArray);
                for (String token : tokenArray) {
                    g.setColor(TOKEN_COLOR);
                    g.fill(new Ellipse2D.Double(point.x + 5, point.y + 22 * count, 22.0, 11.0));
                    g.setColor(TEXT_COLOR);
                    g.drawString(token, point.x + 22 + 10, point.y + 22 * count);
                    ++count;
                }
                break;
            }
            case CONTROL_IN: 
            case CONTROL_OUT: {
                shape = new Ellipse2D.Double(point.x - 3, point.y - 3, 6.0, 6.0);
                break;
            }
            case EPR: {
                shape = new Ellipse2D.Double(point.x - 3, point.y - 3, 6.0, 6.0);
            }
        }
        DrawUtils.gradientFillShape(g, color.brighter().brighter().brighter().brighter(), color.darker(), shape);
        if (this.getPortText() != null) {
            g.setColor(Color.WHITE);
            Font oldFont = g.getFont();
            g.setFont(new Font(oldFont.getFontName(), 1, 7));
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.getPortText(), g);
            g.drawString(this.getPortText(), (int)(shape.getBounds().getX() + (shape.getBounds().getWidth() - bounds.getWidth()) * 2.0 / 4.0), (int)(shape.getBounds().getY() + (shape.getBounds().getHeight() + bounds.getHeight()) * 4.0 / 8.0));
            g.setFont(oldFont);
        }
    }

    private Shape drawPortArrow(Point point) {
        Polygon triangle = new Polygon();
        triangle.addPoint(point.x - 5, point.y - 5);
        triangle.addPoint(point.x + 5, point.y);
        triangle.addPoint(point.x - 5, point.y + 5);
        Polygon shape = triangle;
        return shape;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }

    public Point getPosition() {
        Point nodePosition = this.port.getNode().getPosition();
        int offsetX = this.offset.x;
        return new Point(nodePosition.x + offsetX, nodePosition.y + this.offset.y);
    }

    protected void setSelectedFlag(boolean bool) {
        this.selected = bool;
    }

    public void removeToken(String workflowName) {
        int count = -1;
        for (String key : this.tokens) {
            ++count;
            if (!workflowName.equals(key)) continue;
            break;
        }
        if (count != -1) {
            this.tokens.remove(count);
        }
    }

    public void addToken(String workflowName) {
        boolean found = false;
        for (String key : this.tokens) {
            if (!workflowName.equals(key)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.tokens.add(workflowName);
        }
    }

    public void reset() {
        this.tokens.clear();
    }

    public String getPortText() {
        return this.portText;
    }

    public void setPortText(String portText) {
        this.portText = portText;
    }
}

