/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.airavata.workflow.model.graph.ControlPort;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.GraphPieceGUI;
import org.apache.airavata.xbaya.ui.graph.Paintable;
import org.apache.airavata.xbaya.ui.monitor.MonitorEventHandler;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public abstract class NodeGUI
implements GraphPieceGUI,
Node.NodeObserver {
    protected static final Color BREAK_POINT_BORDER_COLOR = new Color(53, 103, 157);
    protected static final int MINIMUM_WIDTH = 100;
    protected static final int MINIMUM_HEIGHT = 37;
    protected static final int TEXT_GAP_X = 5;
    protected static final int TEXT_GAP_Y = 2;
    protected static final Color TEXT_COLOR = Color.black;
    protected static final int PORT_GAP = 13;
    protected static final int PORT_INITIAL_GAP = 10;
    protected static final Color EDGE_COLOR = Color.GRAY;
    protected static final Color DEFAULT_HEAD_COLOR = Color.white;
    protected static final Color SELECTED_HEAD_COLOR = Color.pink;
    public static final Color DEFAULT_BODY_COLOR = new Color(250, 220, 100);
    protected static final Color DRAGGED_BODY_COLOR = Color.lightGray;
    protected static final Color BREAK_POINT_COLOR = new Color(174, 197, 221);
    protected Node node;
    protected Dimension dimension;
    protected int headHeight;
    protected boolean selected = false;
    protected boolean dragged = false;
    protected Color headColor;
    protected Color bodyColor;
    protected List<Paintable> paintables;

    public NodeGUI(Node node) {
        this.node = node;
        this.bodyColor = DEFAULT_BODY_COLOR;
        this.headColor = DEFAULT_HEAD_COLOR;
        this.dimension = new Dimension(100, 37);
        this.paintables = new LinkedList<Paintable>();
        node.registerObserver((Node.NodeObserver)this);
    }

    public void setBodyColor(Color color) {
        this.bodyColor = color;
    }

    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setHeadColor(Color color) {
        this.headColor = color;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
    }

    public void addPaintable(Paintable paintable) {
        this.paintables.add(paintable);
    }

    public void removePaintable(Paintable paintable) {
        this.paintables.remove(paintable);
    }

    protected void setSelectedFlag(boolean flag) {
        this.selected = flag;
        this.headColor = this.selected ? SELECTED_HEAD_COLOR : DEFAULT_HEAD_COLOR;
    }

    protected void setDraggedFlag(boolean flag) {
        this.dragged = flag;
    }

    protected Point getPosition() {
        return this.getNode().getPosition();
    }

    protected Rectangle getBounds() {
        return new Rectangle(this.getNode().getPosition(), this.dimension);
    }

    protected boolean isIn(Point point) {
        Rectangle bounds = this.getBounds();
        return bounds.contains(point);
    }

    protected boolean isInConfig(Point point) {
        return false;
    }

    protected void calculatePositions(Graphics g) {
        Font oldFont = g.getFont();
        g.setFont(new Font(oldFont.getFontName(), 1, oldFont.getSize()));
        FontMetrics fm = g.getFontMetrics();
        this.headHeight = fm.getHeight() + 4;
        int maxNumPort = Math.max(this.getNode().getOutputPorts().size(), this.getNode().getInputPorts().size());
        this.dimension.height = Math.max(this.headHeight + 10 + 13 * maxNumPort, 37);
        this.dimension.width = Math.max(100, fm.stringWidth(this.getNode().getID()) + 25);
        this.setPortPositions();
        g.setFont(oldFont);
    }

    protected void paint(Graphics2D g) {
        Shape componentShape = this.getComponentShape();
        this.drawBody(g, componentShape, this.getComponentBodyColor());
        this.drawHeader(g, this.getComponentHeaderShape(), this.getComponentHeaderText(), this.getComponentHeaderColor());
        this.drawBreaks(g, this.getNode().getPosition());
        this.drawEdge(g, componentShape, this.getComponentEdgeColor());
        this.drawPorts(g, this.getAllPorts());
        this.drawExtras(g);
    }

    protected final Collection<? extends Port> getAllPorts() {
        return this.getNode().getAllPorts();
    }

    protected Node getNode() {
        return this.node;
    }

    protected final Color getComponentEdgeColor() {
        return EDGE_COLOR;
    }

    protected Color getComponentHeaderColor() {
        return this.headColor;
    }

    protected Shape getComponentHeaderShape() {
        Point position = this.getNode().getPosition();
        RoundRectangle2D.Double headerBoundaryRect = new RoundRectangle2D.Double(position.x, position.y, this.dimension.width, this.headHeight, 10.0, 10.0);
        return headerBoundaryRect;
    }

    protected final Color getComponentBodyColor() {
        Color paintBodyColor = this.dragged ? DRAGGED_BODY_COLOR : this.bodyColor;
        return paintBodyColor;
    }

    protected Shape getComponentShape() {
        Point position = this.getNode().getPosition();
        RoundRectangle2D.Float completeComponentBoundaryRect = new RoundRectangle2D.Float(position.x, position.y, this.dimension.width, this.dimension.height, 10.0f, 10.0f);
        return completeComponentBoundaryRect;
    }

    protected String getComponentHeaderText() {
        String headerText = this.getNode().getID();
        return headerText;
    }

    protected void drawBody(Graphics2D g, Shape shape, Color paintBodyColor) {
        DrawUtils.initializeGraphics2D(g);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(5.0, 5.0);
        Shape shadow = affineTransform.createTransformedShape(shape);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.65f));
        g.setColor(Color.GRAY);
        g.fill(shadow);
        g.setComposite(oldComposite);
        DrawUtils.gradientFillShape(g, this.getEndColor(paintBodyColor), paintBodyColor, shape);
    }

    protected void drawBreaks(Graphics2D g, Point position) {
        if (this.getNode().isBreak()) {
            DrawUtils.initializeGraphics2D(g);
            g.setColor(BREAK_POINT_COLOR);
            int r = this.headHeight / 4;
            g.fillOval(position.x + this.dimension.width - 3 * r, position.y + r, 2 * r, 2 * r);
            g.setColor(BREAK_POINT_BORDER_COLOR);
            g.drawOval(position.x + this.dimension.width - 3 * r, position.y + r, 2 * r, 2 * r);
        }
    }

    protected void drawExtras(Graphics2D g) {
        DrawUtils.initializeGraphics2D(g);
        for (Paintable paintable : this.paintables) {
            paintable.paint(g, this.getNode().getPosition());
        }
    }

    protected void drawPorts(Graphics2D g, Collection<? extends Port> ports) {
        DrawUtils.initializeGraphics2D(g);
        for (Port port : ports) {
            NodeController.getGUI(port).paint(g);
        }
    }

    protected void drawPorts(Graphics2D g, Node node) {
        this.drawPorts(g, node.getAllPorts());
    }

    protected void drawEdge(Graphics2D g, Shape completeComponentBoundaryShape, Color edgeColor) {
        DrawUtils.initializeGraphics2D(g);
        g.setColor(edgeColor);
        g.draw(completeComponentBoundaryShape);
    }

    protected void drawHeader(Graphics2D g, Shape shape, String headerText, Color headColor, boolean lowerBorderflat) {
        this.drawHeader(g, shape, headerText, headColor, shape, lowerBorderflat);
    }

    protected void drawHeader(Graphics2D g, Shape shape, String headerText, Color headColor) {
        this.drawHeader(g, shape, headerText, headColor, true);
    }

    protected void drawHeader(Graphics2D g, Shape shape, String headerText, Color headColor, Shape headerDrawBoundaryShape) {
        this.drawHeader(g, shape, headerText, headColor, headerDrawBoundaryShape, true);
    }

    protected void drawHeader(Graphics2D g, Shape shape, String headerText, Color headColor, Shape headerDrawBoundaryShape, boolean lowerBorderflat) {
        DrawUtils.initializeGraphics2D(g);
        if (lowerBorderflat) {
            g.setColor(this.getEndColor(headColor));
            Rectangle rect = new Rectangle((int)shape.getBounds().getX() + 1, (int)(shape.getBounds().getY() + shape.getBounds().getHeight() - 10.0), (int)shape.getBounds().getWidth(), 10);
            DrawUtils.gradientFillShape(g, this.getEndColor(headColor), headColor, rect);
        }
        DrawUtils.gradientFillShape(g, this.getEndColor(headColor), headColor, headerDrawBoundaryShape);
        g.setColor(TEXT_COLOR);
        Font oldFont = g.getFont();
        g.setFont(new Font(oldFont.getFontName(), 1, oldFont.getSize()));
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(headerText, g);
        g.drawString(headerText, (int)(shape.getBounds().getX() + (shape.getBounds().getWidth() - bounds.getWidth()) / 2.0), (int)(shape.getBounds().getY() + (shape.getBounds().getHeight() + bounds.getHeight()) / 2.0));
        g.setFont(oldFont);
    }

    protected void setPortPositions() {
        List inputPorts = this.getNode().getInputPorts();
        for (int i = 0; i < inputPorts.size(); ++i) {
            Port port = (Port)inputPorts.get(i);
            Point offset = new Point(5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        List outputPorts = this.getNode().getOutputPorts();
        for (int i = 0; i < outputPorts.size(); ++i) {
            Port port = (Port)outputPorts.get(i);
            Point offset = new Point(this.getBounds().width - 5, this.headHeight + 10 + 13 * i);
            NodeController.getGUI(port).setOffset(offset);
        }
        ControlPort controlInPort = this.getNode().getControlInPort();
        if (controlInPort != null) {
            NodeController.getGUI((Port)controlInPort).setOffset(new Point(0, 0));
        }
        for (Port controlOutPort : this.getNode().getControlOutPorts()) {
            NodeController.getGUI(controlOutPort).setOffset(new Point(this.getBounds().width, this.getBounds().height));
        }
    }

    public void setToken(String workflowName, MonitorEventHandler.NodeState state) {
        List inputPorts = this.getNode().getInputPorts();
        switch (state) {
            case EXECUTING: {
                for (DataPort dataPort : inputPorts) {
                    NodeController.getGUI((Port)((DataPort)dataPort.getFromPort())).removeToken(workflowName);
                    NodeController.getGUI((Port)dataPort).addToken(workflowName);
                }
                break;
            }
            case FINISHED: {
                for (DataPort dataPort : inputPorts) {
                    NodeController.getGUI((Port)dataPort).removeToken(workflowName);
                }
                List outputPorts = this.getNode().getOutputPorts();
                for (DataPort dataPort : outputPorts) {
                    NodeController.getGUI((Port)dataPort).addToken(workflowName);
                }
                break;
            }
        }
    }

    public void resetTokens() {
        List inputPorts = this.getNode().getInputPorts();
        for (DataPort dataPort : inputPorts) {
            NodeController.getGUI((Port)dataPort).reset();
        }
        List outputPorts = this.getNode().getOutputPorts();
        for (DataPort dataPort : outputPorts) {
            NodeController.getGUI((Port)dataPort).reset();
        }
    }

    protected Color getEndColor(Color bodyColor) {
        return Color.white;
    }

    public void nodeUpdated(Node.NodeUpdateType type) {
        switch (type) {
            case STATE_CHANGED: {
                this.updateNodeColor();
                break;
            }
        }
    }

    private void updateNodeColor() {
        switch (this.node.getState()) {
            case WAITING: {
                this.setBodyColor(MonitorEventHandler.NodeState.DEFAULT.color);
                break;
            }
            case EXECUTING: {
                this.setBodyColor(MonitorEventHandler.NodeState.EXECUTING.color);
                break;
            }
            case FAILED: {
                this.setBodyColor(MonitorEventHandler.NodeState.FAILED.color);
                break;
            }
            case FINISHED: {
                this.setBodyColor(MonitorEventHandler.NodeState.FINISHED.color);
            }
        }
    }
}

