/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.airavata.workflow.model.graph.Edge;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphPiece;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.system.MemoNode;
import org.apache.airavata.workflow.model.graph.system.StreamSourceNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.GraphPieceGUI;

public class GraphGUI
implements GraphPieceGUI {
    private Graph graph;

    public GraphGUI(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
        GraphPiece piece = this.getGraphPieceAt(event.getPoint());
        if (piece != null && this.graph.isEditable()) {
            NodeController.getGUI(piece).mouseClicked(event, engine);
        }
    }

    protected Rectangle getBounds() {
        Rectangle bounds = new Rectangle();
        for (Node node : this.graph.getNodes()) {
            bounds.add(NodeController.getGUI(node).getBounds());
        }
        int margin = 10;
        bounds.height += 10;
        bounds.width += 10;
        return bounds;
    }

    protected void paint(Graphics2D g) {
        for (Node node : this.graph.getNodes()) {
            NodeController.getGUI(node).calculatePositions(g);
        }
        LinkedList nodes = new LinkedList(this.graph.getNodes());
        List memoNodes = GraphUtil.getNodes((Graph)this.graph, MemoNode.class);
        nodes.removeAll(memoNodes);
        for (Edge edge : this.graph.getEdges()) {
            NodeController.getGUI(edge).paint(g);
        }
        for (Node node : nodes) {
            NodeController.getGUI(node).paint(g);
        }
        for (Node node : memoNodes) {
            NodeController.getGUI(node).paint(g);
        }
    }

    protected StreamSourceNode getStreamSourceAt(Point point) {
        for (Node node : this.graph.getNodes()) {
            if (!NodeController.getGUI(node).isIn(point) || !(node instanceof StreamSourceNode)) continue;
            return (StreamSourceNode)node;
        }
        return null;
    }

    protected GraphPiece getGraphPieceAt(Point point) {
        Edge piece = null;
        double minEdgeDist = Double.MAX_VALUE;
        Edge closestEdge = null;
        for (Edge edge : this.graph.getEdges()) {
            double dist = NodeController.getGUI(edge).getMiddlePosition().distance(point);
            if (!(dist < minEdgeDist)) continue;
            closestEdge = edge;
            minEdgeDist = dist;
        }
        if (minEdgeDist < 20.0) {
            piece = closestEdge;
        }
        for (Node node : this.graph.getNodes()) {
            if (NodeController.getGUI(node).isIn(point)) {
                piece = node;
            }
            double minPortDist = Double.MAX_VALUE;
            Port closestPort = null;
            for (Port port : node.getAllPorts()) {
                double dist = NodeController.getGUI(port).getPosition().distance(point);
                if (!(dist < minPortDist)) continue;
                closestPort = port;
                minPortDist = dist;
            }
            if (!(minPortDist <= 10.0)) continue;
            piece = closestPort;
        }
        return piece;
    }

    protected List<Node> getNodesIn(Rectangle rec) {
        ArrayList<Node> pieces = new ArrayList<Node>();
        for (Node node : this.graph.getNodes()) {
            Rectangle inter = SwingUtilities.computeIntersection(rec.x, rec.y, rec.width, rec.height, NodeController.getGUI(node).getBounds());
            if (inter.width == 0 || inter.height == 0) continue;
            pieces.add(node);
        }
        return pieces;
    }
}

