/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.component.Component;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.component.ComponentReference;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Edge;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.GraphPiece;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.dynamic.DynamicNode;
import org.apache.airavata.workflow.model.graph.dynamic.PortAddable;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.StreamSourceNode;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.workflow.model.wf.WorkflowExecutionState;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.EdgeGUI;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasEvent;
import org.apache.airavata.xbaya.ui.graph.GraphCanvasListener;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSourceTransferable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;

public class GraphCanvas
implements XBayaExecutionModeListener {
    private static final Logger logger = LoggerFactory.getLogger(GraphCanvas.class);
    private XBayaEngine engine;
    private JPanel panel;
    private JScrollPane scrollPane;
    private List<GraphCanvasListener> listeners;
    private Workflow workflow;
    private Graph graph;
    private Node selectedNode;
    private Node draggedNode;
    private Port selectedOutputPort;
    private Port selectedInputPort;
    private Edge selectedEdge;
    private Port draggedPort;
    private Dimension graphDimention;
    private JPopupMenu edgePopup;
    private JPopupMenu nodePopup;
    private Point mousePoint;
    private JMenuItem rerunItem;
    private JMenuItem breakPointItem;
    private PortAddable dynamicNodeWithFreePort;
    private File workflowFile;
    private boolean crtlPressed;
    private Point mousePointForSelection;
    private List<Node> multipleSelectedNodes;
    private XmlElement originalWorkflowElement;
    boolean editable = false;

    public GraphCanvas(XBayaEngine engine) {
        this.engine = engine;
        this.listeners = new LinkedList<GraphCanvasListener>();
        this.workflow = new Workflow();
        this.graph = this.workflow.getGraph();
        engine.getConfiguration().registerExecutionModeChangeListener(this);
        this.graph.setName(this.generateNewWorkflowName());
        this.initGUI();
        this.executionModeChanged(engine.getConfiguration());
    }

    private String generateNewWorkflowName() {
        String baseName = "Workflow";
        ArrayList<String> existingNames = new ArrayList<String>();
        if (this.engine.getGUI() != null) {
            List<GraphCanvas> graphCanvases = this.engine.getGUI().getGraphCanvases();
            for (GraphCanvas graphCanvas : graphCanvases) {
                existingNames.add(graphCanvas.getWorkflow().getName());
            }
        }
        int i = 1;
        String newName = baseName + i;
        while (existingNames.contains(newName)) {
            newName = baseName + ++i;
        }
        return newName;
    }

    public JComponent getSwingComponent() {
        return this.scrollPane;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public synchronized Workflow getWorkflowWithImage() {
        BufferedImage image = this.createImage();
        this.workflow.setImage(image);
        return this.workflow;
    }

    public synchronized Graph getGraph() {
        return this.graph;
    }

    public synchronized void setWorkflow(Workflow workflow) {
        this.reset();
        this.workflow = workflow;
        this.graph = this.workflow.getGraph();
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.GRAPH_LOADED, this, this.workflow));
        this.updateSize();
        this.panel.repaint();
        this.updateOriginalWorkflowElement();
        this.executionModeChanged(this.engine.getConfiguration());
    }

    public synchronized void newWorkflow() {
        Workflow newWorkflow = new Workflow();
        this.setWorkflow(newWorkflow);
    }

    public void setNameAndDescription(String name, String description) {
        this.workflow.setName(name);
        this.workflow.setDescription(description);
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.NAME_CHANGED, this, this.workflow));
    }

    public synchronized Node addNode(Component component, Point location) {
        if (component != null) {
            Node node = this.workflow.addNode(component);
            node.setPosition(location);
            this.selectNode(node);
            this.updateSize();
            this.panel.repaint();
            return node;
        }
        return null;
    }

    public void addNode(Component component) {
        Point location = this.getRandomPosition();
        this.addNode(component, location);
    }

    public synchronized void removeSelected() throws GraphException {
        this.removeSelectedEdge();
        this.removeSelectedNode();
    }

    public synchronized void removeSelectedNode() throws GraphException {
        if (this.selectedNode != null) {
            if (this.selectedNode.containsPort(this.selectedInputPort)) {
                this.deselectInputPort();
            }
            if (this.selectedNode.containsPort(this.selectedOutputPort)) {
                this.deselectOutputPort();
            }
            this.workflow.removeNode(this.selectedNode);
            this.deselectNode();
            this.updateSize();
            this.panel.repaint();
        }
        if (this.multipleSelectedNodes != null) {
            for (Node node : this.multipleSelectedNodes) {
                if (node.containsPort(this.selectedInputPort)) {
                    this.deselectInputPort();
                }
                if (node.containsPort(this.selectedOutputPort)) {
                    this.deselectOutputPort();
                }
                this.workflow.removeNode(node);
            }
            this.deselectNode();
            this.updateSize();
            this.panel.repaint();
        }
    }

    public synchronized void removeSelectedEdge() {
        try {
            if (this.selectedEdge != null) {
                this.graph.removeEdge(this.selectedEdge);
                this.deselectEdge();
                this.panel.repaint();
            }
        }
        catch (GraphException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
    }

    public synchronized void addOrRemoveEdge() {
        try {
            if (this.selectedEdge != null) {
                this.graph.removeEdge(this.selectedEdge);
                this.deselectEdge();
            } else if (this.selectedOutputPort != null && this.selectedInputPort != null) {
                if (this.graph.containsEdge(this.selectedOutputPort, this.selectedInputPort)) {
                    this.graph.removeEdge(this.selectedOutputPort, this.selectedInputPort);
                    this.deselectEdge();
                } else {
                    this.connect(this.selectedOutputPort, this.selectedInputPort);
                }
            }
            this.panel.repaint();
        }
        catch (GraphException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public Port getSelectedInputPort() {
        return this.selectedInputPort;
    }

    public Port getSelectedOutputPort() {
        return this.selectedOutputPort;
    }

    public void repaint() {
        this.panel.repaint();
    }

    public synchronized void addGraphCanvasListener(GraphCanvasListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeGraphCanvasListener(GraphCanvasListener listener) {
        this.listeners.remove(listener);
    }

    private void mouseClicked(MouseEvent event) {
        Point point = event.getPoint();
        GraphPiece clicked = NodeController.getGUI(this.graph).getGraphPieceAt(point);
        if (clicked instanceof Node && this.multipleSelectedNodes != null) {
            Node node = (Node)clicked;
            if (!this.crtlPressed) {
                this.selectNode(node);
            }
            return;
        }
        NodeController.getGUI(this.graph).mouseClicked(event, this.engine);
    }

    private void mousePressed(MouseEvent event) {
        Point point = event.getPoint();
        this.panel.requestFocusInWindow();
        GraphPiece selected = NodeController.getGUI(this.graph).getGraphPieceAt(point);
        if (this.multipleSelectedNodes != null) {
            this.maybeShowPopup(event);
            if (this.crtlPressed && this.multipleSelectedNodes.contains(selected)) {
                this.deselectNode((Node)selected);
                return;
            }
            if (this.multipleSelectedNodes.contains(selected)) {
                this.mousePoint = point;
                this.panel.setCursor(SwingUtil.MOVE_CURSOR);
                return;
            }
            if (selected instanceof Node && this.crtlPressed) {
                this.mousePoint = point;
                this.multipleSelectedNodes.add((Node)selected);
                this.panel.setCursor(SwingUtil.MOVE_CURSOR);
                this.selectNodes(this.multipleSelectedNodes);
                return;
            }
        }
        if (selected instanceof Node && this.crtlPressed) {
            this.multipleSelectedNodes = new ArrayList<Node>();
            if (this.selectedNode != null) {
                this.multipleSelectedNodes.add(this.selectedNode);
            }
            this.multipleSelectedNodes.add((Node)selected);
            this.panel.setCursor(SwingUtil.MOVE_CURSOR);
            this.selectNodes(this.multipleSelectedNodes);
            return;
        }
        this.deselectNode();
        this.deselectEdge();
        if (selected instanceof Node) {
            Node node = (Node)selected;
            this.selectNode(node);
            if (!NodeController.getGUI(node).isInConfig(point)) {
                this.draggedNode = node;
                NodeController.getGUI(node).setDraggedFlag(true);
                this.panel.setCursor(SwingUtil.MOVE_CURSOR);
            }
        } else if (selected instanceof Port) {
            Port port = (Port)selected;
            NodeController.getGUI(port).setSelectedFlag(true);
            switch (port.getKind()) {
                case DATA_IN: 
                case CONTROL_IN: {
                    this.selectInputPort(port);
                    break;
                }
                case CONTROL_OUT: 
                case DATA_OUT: 
                case EPR: {
                    this.selectOutputPort(port);
                }
            }
            this.draggedPort = port;
        } else if (selected instanceof Edge) {
            Edge edge = (Edge)selected;
            this.selectEdge(edge);
        } else {
            this.mousePointForSelection = event.getPoint();
        }
        this.maybeShowPopup(event);
        this.mousePoint = point;
        this.panel.repaint();
        event.consume();
    }

    private void mouseReleased(MouseEvent event) {
        Point point = event.getPoint();
        if (this.draggedNode != null) {
            StreamSourceNode streamNode;
            NodeController.getGUI(this.draggedNode).setDraggedFlag(false);
            this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
            if (this.draggedNode instanceof InputNode && (streamNode = NodeController.getGUI(this.graph).getStreamSourceAt(point)) != null) {
                streamNode.addInputNode((InputNode)this.draggedNode);
            }
            this.draggedNode = null;
        }
        if (this.draggedPort != null) {
            GraphPiece graphPiece = NodeController.getGUI(this.graph).getGraphPieceAt(point);
            if (graphPiece instanceof DynamicNode) {
                if (this.draggedPort.getKind() == Port.Kind.DATA_OUT && this.draggedPort instanceof DataPort) {
                    this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
                    DynamicNode dynamicNode = (DynamicNode)graphPiece;
                    dynamicNode.getComponent();
                    DataPort freePort = dynamicNode.getFreeInPort();
                    try {
                        freePort.copyType((DataPort)this.draggedPort);
                    }
                    catch (GraphException e) {
                        this.engine.getGUI().getErrorWindow().error(e);
                        return;
                    }
                    this.connect(this.draggedPort, (Port)freePort);
                    this.dynamicNodeWithFreePort = null;
                }
            } else if (graphPiece instanceof Port) {
                Port port = (Port)graphPiece;
                if (this.draggedPort.getKind() == Port.Kind.DATA_OUT && port.getKind() == Port.Kind.DATA_IN) {
                    this.connect(this.draggedPort, port);
                } else if (port.getKind() == Port.Kind.DATA_OUT && this.draggedPort.getKind() == Port.Kind.DATA_IN) {
                    this.connect(port, this.draggedPort);
                } else if (this.draggedPort.getKind() == Port.Kind.CONTROL_OUT && port.getKind() == Port.Kind.CONTROL_IN) {
                    this.connect(this.draggedPort, port);
                } else if (this.draggedPort.getKind() == Port.Kind.CONTROL_IN && port.getKind() == Port.Kind.CONTROL_OUT) {
                    this.connect(port, this.draggedPort);
                } else if (this.draggedPort.getKind() == Port.Kind.EPR && port.getKind() == Port.Kind.DATA_IN) {
                    this.connect(this.draggedPort, port);
                } else if (this.draggedPort.getKind() == Port.Kind.DATA_IN && port.getKind() == Port.Kind.EPR) {
                    this.connect(port, this.draggedPort);
                }
            }
            this.draggedPort = null;
        }
        if (this.dynamicNodeWithFreePort != null) {
            try {
                this.dynamicNodeWithFreePort.removeLastDynamicallyAddedInPort();
            }
            catch (GraphException e) {
                this.engine.getGUI().getErrorWindow().error(e);
            }
        }
        if (this.mousePointForSelection != null) {
            double width = Math.abs(this.mousePoint.getX() - this.mousePointForSelection.getX());
            double height = Math.abs(this.mousePoint.getY() - this.mousePointForSelection.getY());
            int x = (int)(this.mousePoint.getX() > this.mousePointForSelection.getX() ? this.mousePointForSelection.getX() : this.mousePoint.getX());
            int y = (int)(this.mousePoint.getY() > this.mousePointForSelection.getY() ? this.mousePointForSelection.getY() : this.mousePoint.getY());
            this.multipleSelectedNodes = NodeController.getGUI(this.graph).getNodesIn(new Rectangle(x, y, (int)width, (int)height));
            this.selectNodes(this.multipleSelectedNodes);
            this.mousePointForSelection = null;
        }
        if (this.multipleSelectedNodes != null) {
            this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
        }
        this.maybeShowPopup(event);
        this.updateSize();
        this.panel.repaint();
        event.consume();
    }

    private void mouseDragged(MouseEvent event) {
        Point point = event.getPoint();
        if (this.editable) {
            int diffY;
            int diffX;
            if (this.multipleSelectedNodes != null) {
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                diffX = point.x - this.mousePoint.x;
                diffY = point.y - this.mousePoint.y;
                for (Node node : this.multipleSelectedNodes) {
                    Point newPoint = new Point();
                    Point currentPoint = node.getPosition();
                    newPoint.x = currentPoint.x + diffX;
                    if (newPoint.x < 0) {
                        newPoint.x = 0;
                    }
                    newPoint.y = currentPoint.y + diffY;
                    if (newPoint.y < 0) {
                        newPoint.y = 0;
                    }
                    node.setPosition(newPoint);
                }
                this.panel.repaint();
                event.consume();
            }
            if (this.draggedNode != null) {
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                diffX = point.x - this.mousePoint.x;
                diffY = point.y - this.mousePoint.y;
                Point newPoint = new Point();
                Point currentPoint = this.draggedNode.getPosition();
                newPoint.x = currentPoint.x + diffX;
                if (newPoint.x < 0) {
                    newPoint.x = 0;
                }
                newPoint.y = currentPoint.y + diffY;
                if (newPoint.y < 0) {
                    newPoint.y = 0;
                }
                this.draggedNode.setPosition(newPoint);
                this.panel.repaint();
                event.consume();
            }
            if (this.draggedPort != null) {
                GraphPiece piece = NodeController.getGUI(this.graph).getGraphPieceAt(point);
                if (piece instanceof Port) {
                    Port port = (Port)piece;
                    if (this.draggedPort.getKind() == Port.Kind.DATA_IN && port.getKind() == Port.Kind.DATA_OUT) {
                        this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
                        this.selectOutputPort(port);
                    } else if (this.draggedPort.getKind() == Port.Kind.DATA_OUT && port.getKind() == Port.Kind.DATA_IN) {
                        this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
                        this.selectInputPort(port);
                    } else if (this.draggedPort.getKind() == Port.Kind.DATA_IN && port.getKind() == Port.Kind.EPR) {
                        this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
                        this.selectOutputPort(port);
                    } else if (this.draggedPort.getKind() == Port.Kind.EPR && port.getKind() == Port.Kind.DATA_IN) {
                        this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
                        this.selectInputPort(port);
                    } else {
                        this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
                    }
                } else if (piece instanceof PortAddable) {
                    PortAddable dynamicNode = (PortAddable)piece;
                    dynamicNode.getFreeInPort();
                    this.dynamicNodeWithFreePort = dynamicNode;
                } else {
                    this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
                }
                this.panel.repaint();
                event.consume();
            }
            this.mousePoint = point;
            if (this.mousePointForSelection != null) {
                this.panel.repaint();
            }
        }
    }

    private void mouseMoved(MouseEvent event) {
        Point point = event.getPoint();
        GraphPiece graphPiece = NodeController.getGUI(this.graph).getGraphPieceAt(point);
        if (graphPiece instanceof Node) {
            Node node = (Node)graphPiece;
            if (NodeController.getGUI(node).isInConfig(point)) {
                this.panel.setCursor(SwingUtil.HAND_CURSOR);
            } else {
                this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
            }
        } else if (graphPiece instanceof Port) {
            this.panel.setCursor(SwingUtil.CROSSHAIR_CURSOR);
        } else {
            this.panel.setCursor(SwingUtil.DEFAULT_CURSOR);
        }
    }

    private void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (this.editable && keyCode == 127) {
            try {
                this.removeSelected();
            }
            catch (GraphException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Error e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
        if (keyCode == 17) {
            this.crtlPressed = true;
        }
    }

    private void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 17) {
            this.crtlPressed = false;
        }
    }

    private void drop(final DropTargetDropEvent event) {
        logger.debug("Event:" + event);
        Transferable transferable = event.getTransferable();
        try {
            final ComponentReference componentReference = (ComponentReference)transferable.getTransferData(ComponentSourceTransferable.FLAVOR);
            final Point location = event.getLocation();
            new Thread(){

                @Override
                public void run() {
                    try {
                        Component component = componentReference.getComponent();
                        GraphCanvas.this.addNode(component, location);
                        GraphCanvas.this.panel.requestFocusInWindow();
                        event.dropComplete(true);
                    }
                    catch (ComponentException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        event.dropComplete(false);
                    }
                    catch (ComponentRegistryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        event.dropComplete(false);
                    }
                }
            }.start();
        }
        catch (UnsupportedFlavorException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private BufferedImage createImage() {
        Rectangle bounds = NodeController.getGUI(this.graph).getBounds();
        BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D graphics = image.createGraphics();
        Color background = new Color(226, 226, 222);
        graphics.setBackground(background);
        graphics.clearRect(0, 0, bounds.width, bounds.height);
        this.paintComponent(graphics);
        return image;
    }

    private void connect(Port fromPort, Port toPort) {
        try {
            Edge edge = this.graph.addEdge(fromPort, toPort);
            this.selectEdge(edge);
        }
        catch (GraphException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().warning(e.getMessage());
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.engine.getGUI().getErrorWindow().error("Unexpected error.");
        }
    }

    private void paintComponent(Graphics2D g) {
        NodeController.getGUI(this.graph).paint(g);
        if (this.draggedPort != null) {
            Point p2;
            Point p1;
            Port.Kind kind = this.draggedPort.getKind();
            if (kind == Port.Kind.DATA_OUT || kind == Port.Kind.CONTROL_OUT || kind == Port.Kind.EPR) {
                p1 = NodeController.getGUI(this.draggedPort).getPosition();
                p2 = this.mousePoint;
            } else if (kind == Port.Kind.DATA_IN || kind == Port.Kind.CONTROL_IN) {
                p1 = this.mousePoint;
                p2 = NodeController.getGUI(this.draggedPort).getPosition();
            } else {
                throw new WorkflowRuntimeException();
            }
            g.setColor(Color.RED);
            Stroke originalStroke = g.getStroke();
            if (kind == Port.Kind.CONTROL_IN || kind == Port.Kind.CONTROL_OUT) {
                g.setStroke(EdgeGUI.CONTROL_EDGE_STROKE);
            }
            EdgeGUI.paintLine(p1, p2, g);
            g.setStroke(originalStroke);
        }
        if (this.mousePointForSelection != null) {
            double width = Math.abs(this.mousePoint.getX() - this.mousePointForSelection.getX());
            double height = Math.abs(this.mousePoint.getY() - this.mousePointForSelection.getY());
            int x = (int)(this.mousePoint.getX() > this.mousePointForSelection.getX() ? this.mousePointForSelection.getX() : this.mousePoint.getX());
            int y = (int)(this.mousePoint.getY() > this.mousePointForSelection.getY() ? this.mousePointForSelection.getY() : this.mousePoint.getY());
            g.setColor(Color.RED);
            g.setStroke(new BasicStroke(1.0f, 1, 0, 15.0f, new float[]{5.0f, 5.0f}, 3.0f));
            g.drawRect(x, y, (int)width, (int)height);
        }
    }

    private Point getRandomPosition() {
        Rectangle area = this.panel.getVisibleRect();
        int x = (int)((double)area.x + (double)(area.width - 100) * Math.random());
        int y = (int)((double)area.y + (double)(area.height - 37) * Math.random());
        return new Point(x, y);
    }

    private void updateSize() {
        Rectangle bounds = NodeController.getGUI(this.graph).getBounds();
        Dimension newDimention = new Dimension(bounds.width, bounds.height);
        if (!newDimention.equals(this.graphDimention)) {
            this.panel.setPreferredSize(newDimention);
            this.panel.revalidate();
            this.graphDimention = newDimention;
        }
    }

    private void setSelectedNode(Node node) {
        this.selectedNode = node;
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.NODE_SELECTED, this, this.workflow));
    }

    private void selectNode(Node node) {
        this.deselectNode();
        NodeController.getGUI(node).setSelectedFlag(true);
        this.setSelectedNode(node);
    }

    private void selectNodes(List<Node> nodes) {
        this.deselectNode();
        for (Node node : nodes) {
            NodeController.getGUI(node).setSelectedFlag(true);
            NodeController.getGUI(node).setDraggedFlag(true);
        }
        this.multipleSelectedNodes = nodes;
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.NODE_SELECTED, this, this.workflow));
    }

    private void deselectNode() {
        if (this.selectedNode != null) {
            NodeController.getGUI(this.selectedNode).setSelectedFlag(false);
            NodeController.getGUI(this.selectedNode).setDraggedFlag(false);
            this.setSelectedNode(null);
        }
        if (this.multipleSelectedNodes != null) {
            for (Node node : this.multipleSelectedNodes) {
                NodeController.getGUI(node).setSelectedFlag(false);
                NodeController.getGUI(node).setDraggedFlag(false);
            }
            this.multipleSelectedNodes = null;
        }
    }

    private void deselectNode(Node node) {
        if (this.multipleSelectedNodes != null && this.multipleSelectedNodes.contains(node)) {
            NodeController.getGUI(node).setSelectedFlag(false);
            NodeController.getGUI(node).setDraggedFlag(false);
            this.multipleSelectedNodes.remove(node);
        }
    }

    private void setSelectedInputPort(Port port) {
        this.selectedInputPort = port;
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.INPUT_PORT_SELECTED, this, this.workflow));
    }

    private void selectInputPort(Port port) {
        this.deselectInputPort();
        NodeController.getGUI(port).setSelectedFlag(true);
        this.setSelectedInputPort(port);
    }

    private void deselectInputPort() {
        if (this.selectedInputPort != null) {
            NodeController.getGUI(this.selectedInputPort).setSelectedFlag(false);
            this.setSelectedInputPort(null);
        }
    }

    private void setSelectedOutputPort(Port port) {
        this.selectedOutputPort = port;
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.OUTPUT_PORT_SELECTED, this, this.workflow));
    }

    private void selectOutputPort(Port port) {
        this.deselectOutputPort();
        NodeController.getGUI(port).setSelectedFlag(true);
        this.setSelectedOutputPort(port);
    }

    private void deselectOutputPort() {
        if (this.selectedOutputPort != null) {
            NodeController.getGUI(this.selectedOutputPort).setSelectedFlag(false);
            this.setSelectedOutputPort(null);
        }
    }

    private void selectEdge(Edge edge) {
        if (edge != null) {
            this.deselectEdge();
            NodeController.getGUI(edge).setSelectedFlag(true);
            this.selectedEdge = edge;
            this.selectOutputPort(edge.getFromPort());
            this.selectInputPort(edge.getToPort());
        }
    }

    private void deselectEdge() {
        if (this.selectedEdge != null) {
            NodeController.getGUI(this.selectedEdge).setSelectedFlag(false);
            this.selectedEdge = null;
        }
    }

    private void reset() {
        this.setSelectedNode(null);
        this.draggedNode = null;
        this.setSelectedInputPort(null);
        this.setSelectedOutputPort(null);
        this.selectedEdge = null;
        this.multipleSelectedNodes = null;
    }

    private void notifyListeners(GraphCanvasEvent event) {
        for (GraphCanvasListener listener : this.listeners) {
            listener.graphCanvasChanged(event);
        }
    }

    private void initGUI() {
        this.panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                GraphCanvas.this.paintComponent((Graphics2D)g);
            }
        };
        this.panel.setLayout(null);
        this.panel.setOpaque(true);
        this.panel.setBackground(new Color(255, 255, 255));
        this.panel.setDoubleBuffered(true);
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                GraphCanvas.this.mouseClicked(event);
            }

            @Override
            public void mousePressed(MouseEvent event) {
                GraphCanvas.this.mousePressed(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                GraphCanvas.this.mouseReleased(event);
                GraphCanvas.this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.WORKFLOW_CHANGED, GraphCanvas.this, GraphCanvas.this.workflow));
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                GraphCanvas.this.mouseDragged(event);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                GraphCanvas.this.mouseMoved(event);
            }
        });
        this.panel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                GraphCanvas.this.keyPressed(event);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                GraphCanvas.this.keyReleased(event);
            }
        });
        this.scrollPane = new JScrollPane(this.panel);
        DropTargetAdapter dropTargetListener = new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent event) {
                GraphCanvas.this.drop(event);
            }
        };
        new DropTarget(this.panel, 3, dropTargetListener);
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.createEdgePopupMenu();
        this.createNodePopupMenu();
    }

    private void createNodePopupMenu() {
        this.nodePopup = new JPopupMenu();
        if (this.editable) {
            JMenuItem deleteItem = new JMenuItem("Delete");
            deleteItem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        GraphCanvas.this.removeSelectedNode();
                    }
                    catch (GraphException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    }
                    catch (RuntimeException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    }
                    catch (Error e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    }
                }
            });
            this.nodePopup.add(deleteItem);
        }
        this.rerunItem = new JMenuItem("ReRun");
        this.rerunItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GraphCanvas.this.rerunSelectedNode();
                }
                catch (RuntimeException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        });
        this.breakPointItem = new JMenuItem("Add break Point");
        this.breakPointItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    GraphCanvas.this.toggleBreakPointToNode();
                }
                catch (RuntimeException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
                catch (Error e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    GraphCanvas.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                }
            }
        });
    }

    private synchronized void toggleBreakPointToNode() {
        if (this.selectedNode != null) {
            this.selectedNode.setBreak(!this.selectedNode.isBreak());
            this.repaint();
        }
    }

    private void rerunSelectedNode() {
        if (this.selectedNode != null) {
            ArrayList<Node> exploreNodes = new ArrayList<Node>();
            exploreNodes.add(this.selectedNode);
            while (exploreNodes.size() != 0) {
                Node node = (Node)exploreNodes.get(0);
                List outputPorts = node.getOutputPorts();
                for (DataPort dataPort : outputPorts) {
                    exploreNodes.addAll(dataPort.getToNodes());
                }
                node.setState(Node.NodeExecutionState.WAITING);
                exploreNodes.remove(0);
            }
            this.repaint();
        }
    }

    private void prepareNodePopupMenu(Node node) {
        this.nodePopup.remove(this.rerunItem);
        this.nodePopup.remove(this.breakPointItem);
        if (this.engine.getGUI().getWorkflow().getExecutionState() == WorkflowExecutionState.PAUSED && !(node instanceof InputNode)) {
            this.nodePopup.add(this.rerunItem);
        }
        if (this.engine.getGUI().getWorkflow().getExecutionState() != WorkflowExecutionState.NONE) {
            if (node.isBreak()) {
                this.breakPointItem.setText("Remove break Point");
            } else {
                this.breakPointItem.setText("Add break Point");
            }
            this.nodePopup.add(this.breakPointItem);
        }
    }

    private void createEdgePopupMenu() {
        this.edgePopup = new JPopupMenu();
        if (this.editable) {
            JMenuItem deleteItem = new JMenuItem("Delete");
            deleteItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphCanvas.this.removeSelectedEdge();
                }
            });
            this.edgePopup.add(deleteItem);
        }
    }

    private void maybeShowPopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            GraphPiece piece = NodeController.getGUI(this.graph).getGraphPieceAt(event.getPoint());
            if (piece instanceof Node) {
                this.prepareNodePopupMenu((Node)piece);
                this.nodePopup.show(event.getComponent(), event.getX(), event.getY());
            } else if (piece instanceof Edge) {
                this.edgePopup.show(event.getComponent(), event.getX(), event.getY());
            }
        }
    }

    public File getWorkflowFile() {
        return this.workflowFile;
    }

    public void setWorkflowFile(File workflowFile) {
        this.workflowFile = workflowFile;
    }

    public boolean isWorkflowChanged() {
        try {
            if (this.originalWorkflowElement == null) {
                this.updateOriginalWorkflowElement();
            }
            return !XMLUtil.isEqual((XmlElement)this.originalWorkflowElement, (XmlElement)this.getWorkflow().toXML());
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void workflowSaved() {
        this.updateOriginalWorkflowElement();
        this.notifyListeners(new GraphCanvasEvent(GraphCanvasEvent.GraphCanvasEventType.WORKFLOW_CHANGED, this, this.workflow));
    }

    private void updateOriginalWorkflowElement() {
        this.originalWorkflowElement = this.getWorkflow().toXML();
    }

    @Override
    public void executionModeChanged(XBayaConfiguration config) {
        this.editable = config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE;
        this.getGraph().setEditable(this.editable);
        this.workflow.setEditable(config.getXbayaExecutionMode() == XBayaConfiguration.XBayaExecutionMode.IDE);
    }
}

