/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import org.apache.airavata.workflow.model.graph.ControlEdge;
import org.apache.airavata.workflow.model.graph.Edge;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.ui.graph.GraphPieceGUI;
import org.apache.airavata.xbaya.ui.utils.DrawUtils;

public class EdgeGUI
implements GraphPieceGUI {
    public static final Stroke CONTROL_EDGE_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f}, 0.0f);
    public static final Stroke STREAM_EDGE_STROKE = new BasicStroke(4.0f, 2, 0, 10.0f, new float[]{5.0f}, 0.0f);
    private static final Color lineColor = Color.black;
    private static final Color pointColor = Color.pink;
    private static final Color selectedPointColor = Color.red;
    private static final int POINT_SIZE = 8;
    private Edge edge;
    private boolean selected = false;
    private static Color STREAM_EDGE_COLOR = new Color(51, 255, 204);

    public EdgeGUI(Edge edge) {
        this.edge = edge;
    }

    @Override
    public void mouseClicked(MouseEvent event, XBayaEngine engine) {
    }

    protected void setSelectedFlag(boolean bool) {
        this.selected = bool;
    }

    protected Point getMiddlePosition() {
        Point point1 = this.getFromPosition();
        Point point2 = this.getToPosition();
        Point midPoint = new Point((point1.x + point2.x) / 2, (point1.y + point2.y) / 2);
        return midPoint;
    }

    protected void paint(Graphics2D g) {
        DrawUtils.initializeGraphics2D(g);
        Point point1 = this.getFromPosition();
        Point point2 = this.getToPosition();
        g.setColor(lineColor);
        Stroke originalStroke = g.getStroke();
        if (this.edge instanceof ControlEdge) {
            g.setStroke(CONTROL_EDGE_STROKE);
        }
        EdgeGUI.paintLine(point1, point2, g);
        g.setStroke(originalStroke);
        g.setColor(this.selected ? pointColor : selectedPointColor);
        Point midPoint = this.getMiddlePosition();
        g.fillArc(midPoint.x - 4, midPoint.y - 4, 8, 8, 0, 360);
    }

    protected static void paintLine(Point point1, Point point2, Graphics2D g) {
        int d = 100;
        int dist = (int)point1.distance(point2);
        if (dist < d) {
            d = dist;
        }
        CubicCurve2D.Double line = new CubicCurve2D.Double(point1.x, point1.y, point1.x + d, point1.y, point2.x - d, point2.y, point2.x, point2.y);
        g.draw(line);
    }

    private Point getFromPosition() {
        Port port = this.edge.getFromPort();
        return NodeController.getGUI(port).getPosition();
    }

    private Point getToPosition() {
        Port port = this.edge.getToPort();
        return NodeController.getGUI(port).getPosition();
    }
}

