/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.experiment;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class RegistryWorkflowPublisherWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private JButton okButton;
    private boolean makePublic = false;
    private JCheckBox chkMakePublic;
    private XBayaTextArea descriptionTextArea;
    private XBayaTextField nameTextField;
    private Workflow workflow;

    public RegistryWorkflowPublisherWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGUI();
    }

    private void ok() {
        String name = this.nameTextField.getText();
        String description = this.descriptionTextArea.getText();
        GraphCanvas graphCanvas = this.engine.getGUI().getGraphCanvas();
        graphCanvas.setNameAndDescription(name, description);
        this.hide();
    }

    public void show() {
        this.workflow = this.engine.getGUI().getWorkflow();
        String name = this.workflow.getName();
        this.nameTextField.setText(name);
        String description = this.workflow.getDescription();
        this.descriptionTextArea.setText(description);
        this.dialog.show();
    }

    public void hide() {
        this.dialog.hide();
    }

    private void initGUI() {
        this.nameTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.descriptionTextArea = new XBayaTextArea();
        XBayaLabel descriptionLabel = new XBayaLabel("Description", this.descriptionTextArea);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryWorkflowPublisherWindow.this.ok();
            }
        });
        buttonPanel.add(this.okButton);
        GridPanel mainPanel = new GridPanel();
        TitledBorder border = new TitledBorder(new EtchedBorder(), "Save Workflow to Registry");
        mainPanel.getSwingComponent().setBorder(border);
        mainPanel.add(nameLabel);
        mainPanel.add(this.nameTextField);
        mainPanel.add(descriptionLabel);
        mainPanel.add(this.descriptionTextArea);
        this.chkMakePublic = new JCheckBox("Make public");
        mainPanel.add(this.chkMakePublic);
        mainPanel.layout(2, 2, 0, 0);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Save Workflow to Registry", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(this.okButton);
    }

    public boolean isMakePublic() {
        return this.chkMakePublic.isSelected();
    }
}

