/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.experiment;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.workflow.model.component.ComponentException;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.registry.RegistryAccesser;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.experiment.RegistrySearchResult;
import org.apache.airavata.xbaya.ui.graph.GraphCanvas;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XbayaEnhancedList;
import org.apache.airavata.xbaya.util.XBayaUtil;

public class RegistryLoaderWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private JButton okButton;
    private JButton deleteButton;
    private XbayaEnhancedList<RegistrySearchResult> list;

    public RegistryLoaderWindow(XBayaEngine engine) {
        this.engine = engine;
        if (XBayaUtil.acquireJCRRegistry(this.engine)) {
            this.initGUI();
        }
    }

    public void show() {
        this.list.setEnabled(false);
        this.okButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    RegistryAccesser registryAccesser = new RegistryAccesser(RegistryLoaderWindow.this.engine);
                    final Map<String, String> resultList = registryAccesser.getOGCEWorkflowTemplateList();
                    final Set<String> keys = resultList.keySet();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (resultList != null && resultList.size() != 0) {
                                Vector<RegistrySearchResult> results = new Vector<RegistrySearchResult>();
                                String val = null;
                                for (String key : keys) {
                                    val = (String)resultList.get(key);
                                    try {
                                        results.add(new RegistrySearchResult(new Workflow(val)));
                                    }
                                    catch (GraphException e) {
                                        e.printStackTrace();
                                    }
                                    catch (ComponentException e) {
                                        e.printStackTrace();
                                    }
                                }
                                RegistryLoaderWindow.this.list.setListData(results);
                                RegistryLoaderWindow.this.list.setEnabled(true);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    RegistryLoaderWindow.this.engine.getGUI().getErrorWindow().error("Failed to get list of workflows from Registry.", e);
                    RegistryLoaderWindow.this.hide();
                }
                catch (Error e) {
                    RegistryLoaderWindow.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    RegistryLoaderWindow.this.hide();
                }
                catch (AiravataAPIInvocationException e) {
                    RegistryLoaderWindow.this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
                    RegistryLoaderWindow.this.hide();
                }
            }
        }.start();
        this.dialog.show();
    }

    public void hide() {
        this.dialog.hide();
    }

    private void ok() {
        RegistrySearchResult result = this.list.getSelectedValue();
        this.hide();
        try {
            Workflow workflow = new RegistryAccesser(this.engine).getWorkflow(result.getResourceName());
            GraphCanvas newGraphCanvas = this.engine.getGUI().newGraphCanvas(true);
            newGraphCanvas.setWorkflow(workflow);
            this.engine.getGUI().getGraphCanvas().setWorkflowFile(null);
        }
        catch (Exception e) {
            this.engine.getGUI().getErrorWindow().error(e);
        }
    }

    private void delete() {
        RegistryAccesser registryAccesser = new RegistryAccesser(this.engine);
        for (RegistrySearchResult i : this.list.getSelectedValues()) {
            try {
                registryAccesser.deleteOGCEWorkflow(i.getResourceId());
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
        }
        this.list.removeSelectedRows();
        this.hide();
    }

    private void initGUI() {
        this.list = new XbayaEnhancedList();
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    RegistryLoaderWindow.this.okButton.doClick();
                }
                if (RegistryLoaderWindow.this.list.getSelectedIndex() == -2) {
                    RegistryLoaderWindow.this.okButton.setEnabled(false);
                    RegistryLoaderWindow.this.deleteButton.setEnabled(true);
                } else if (RegistryLoaderWindow.this.list.getSelectedIndex() != -1) {
                    RegistryLoaderWindow.this.okButton.setEnabled(true);
                    RegistryLoaderWindow.this.deleteButton.setEnabled(true);
                } else {
                    RegistryLoaderWindow.this.okButton.setEnabled(false);
                    RegistryLoaderWindow.this.deleteButton.setEnabled(false);
                }
            }
        });
        GridPanel mainPanel = new GridPanel();
        TitledBorder border = new TitledBorder(new EtchedBorder(), "Select a workflow to load");
        mainPanel.getSwingComponent().setBorder(border);
        mainPanel.add(this.list);
        mainPanel.layout(1, 1, 0, 0);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("Load");
        this.okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryLoaderWindow.this.ok();
            }
        });
        buttonPanel.add(this.okButton);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryLoaderWindow.this.delete();
            }
        });
        buttonPanel.add(this.deleteButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryLoaderWindow.this.hide();
            }
        });
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Load a Workflow from the Registry", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(this.okButton);
    }
}

