/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.experiment;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.registry.RegistryAccesser;
import org.apache.airavata.xbaya.util.XBayaUtil;

public class ExperimentMenu {
    private JMenu experimentMenu;
    protected RegistryAccesser registryAccesser;
    private JMenuItem configureRegistryItem;
    private JMenuItem deleteWorkflowfromRegistryItem;
    private XBayaEngine engine;

    public ExperimentMenu(XBayaEngine engine) {
        this.engine = engine;
        this.registryAccesser = new RegistryAccesser(engine);
        this.createExperimentMenu();
    }

    private void createExperimentMenu() {
        this.createConfigureRegistryItem();
        this.createDeleteWorkflowtoRegistryItem();
        this.experimentMenu = new JMenu("Experiment");
        this.experimentMenu.setMnemonic(70);
        this.experimentMenu.add(this.configureRegistryItem);
        this.experimentMenu.addSeparator();
        this.experimentMenu.add(this.deleteWorkflowfromRegistryItem);
        this.experimentMenu.addSeparator();
        this.experimentMenu.addSeparator();
    }

    public JMenu getMenu() {
        return this.experimentMenu;
    }

    private void createConfigureRegistryItem() {
        this.configureRegistryItem = new JMenuItem("Configure Registry");
        this.configureRegistryItem.setMnemonic(67);
        this.configureRegistryItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XBayaEngine xbayaEngine = ExperimentMenu.this.engine;
                XBayaUtil.updateJCRRegistryInfo(xbayaEngine);
            }
        });
    }

    private void createDeleteWorkflowtoRegistryItem() {
        this.deleteWorkflowfromRegistryItem = new JMenuItem("Delete Workflows in Registry");
        this.deleteWorkflowfromRegistryItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExperimentMenu.this.registryAccesser.deleteOGCEWorkflow(ExperimentMenu.this.engine.getGUI().getWorkflow().getQname());
                }
                catch (AiravataAPIInvocationException e1) {
                    throw new WorkflowRuntimeException((Throwable)e1);
                }
            }
        });
    }
}

