/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.workflow;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSGraph;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.views.ParameterPropertyPanel;
import org.xmlpull.infoset.XmlElement;

public class ParameterPropertyWindow {
    private XBayaEngine engine;
    protected XBayaDialog dialog;
    private ParameterPropertyPanel inputPanel;
    private ParameterPropertyPanel outputPanel;
    private JButton okButton;
    private WSGraph graph;
    private List<? extends Node> nodes;
    private List<InputNode> inputNodes;
    private List<OutputNode> outputNodes;

    public ParameterPropertyWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGui();
    }

    public void show() {
        this.graph = this.engine.getGUI().getWorkflow().getGraph();
        this.nodes = this.graph.getNodes();
        this.inputNodes = GraphUtil.getInputNodes((Graph)this.graph);
        this.outputNodes = GraphUtil.getOutputNodes((Graph)this.graph);
        this.inputPanel.setParameterNodes(this.inputNodes);
        this.inputPanel.setMetadata(this.graph.getInputMetadata());
        this.outputPanel.setParameterNodes(this.outputNodes);
        this.outputPanel.setMetadata(this.graph.getOutputMetadata());
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void ok() {
        int i;
        XmlElement outputMetadata;
        XmlElement inputMetadata;
        String inputMetadataText = this.inputPanel.getMetadata();
        if (inputMetadataText.length() == 0) {
            inputMetadata = null;
        } else {
            try {
                inputMetadata = XMLUtil.stringToXmlElement((String)inputMetadataText);
            }
            catch (RuntimeException e) {
                String warning = "The input metadata is ill-formed.";
                this.engine.getGUI().getErrorWindow().error(warning, e);
                return;
            }
        }
        String outputMetadataText = this.outputPanel.getMetadata();
        if (outputMetadataText.length() == 0) {
            outputMetadata = null;
        } else {
            try {
                outputMetadata = XMLUtil.stringToXmlElement((String)outputMetadataText);
            }
            catch (RuntimeException e) {
                String warning = "The output metadata is ill-formed.";
                this.engine.getGUI().getErrorWindow().error(warning, e);
                return;
            }
        }
        this.graph.setInputMetadata(inputMetadata);
        this.graph.setOutputMetadata(outputMetadata);
        for (i = 0; i < this.inputNodes.size(); ++i) {
            InputNode inputNode = this.inputNodes.get(i);
            Collections.swap(this.nodes, i, this.nodes.indexOf(inputNode));
        }
        for (i = 0; i < this.outputNodes.size(); ++i) {
            OutputNode outputNode = this.outputNodes.get(i);
            Collections.swap(this.nodes, this.inputNodes.size() + i, this.nodes.indexOf(outputNode));
        }
        this.hide();
    }

    private void initGui() {
        this.inputPanel = new ParameterPropertyPanel("Inputs");
        this.outputPanel = new ParameterPropertyPanel("Outputs");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 2));
        mainPanel.add(this.inputPanel.getSwingComponent());
        mainPanel.add(this.outputPanel.getSwingComponent());
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setDefaultCapable(true);
        this.okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPropertyWindow.this.ok();
            }
        });
        buttonPanel.add(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPropertyWindow.this.hide();
            }
        });
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Workflow Paremeter Properties", (JComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(this.okButton);
    }
}

