/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.registry;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.apache.airavata.client.AiravataAPIFactory;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ClientSettings;
import org.apache.airavata.registry.api.PasswordCallback;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentRegistryLoader;
import org.apache.airavata.xbaya.registry.PasswordCallbackImpl;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.dialogs.registry.NewRegistryUserDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLinkButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class RegistryWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XBayaTextField urlTextField;
    private XBayaTextField gatewayTextField;
    private XBayaTextField usernameTextField;
    private JPasswordField passwordTextField;
    private XBayaLinkButton newUserButton;
    private NewRegistryUserDialog newUserWindow;
    private String userName;
    private String password;
    private String regURL;
    private String gateway;
    private static String previousRegURL;

    public RegistryWindow(XBayaEngine engine) {
        this.engine = engine;
        ComponentRegistryLoader.getLoader(this.engine, "registry.type.jcr");
        this.initGUI();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void ok() {
        URI url;
        this.setRegURL(this.urlTextField.getText());
        RegistryWindow.setPreviousRegURL(this.urlTextField.getText());
        this.setUserName(this.usernameTextField.getText());
        this.setPassword(new String(this.passwordTextField.getPassword()));
        this.setGateway(this.gatewayTextField.getText());
        if (this.getRegURL().length() == 0) {
            this.engine.getGUI().getErrorWindow().error("URL cannot be empty.");
            return;
        }
        try {
            url = new URI(this.regURL);
        }
        catch (URISyntaxException e) {
            this.engine.getGUI().getErrorWindow().error("URL is in wrong format.", e);
            return;
        }
        AiravataAPI airavataAPI = this.getAiravataAPI();
        XBayaConfiguration configuration = this.engine.getConfiguration();
        this.engine.setAiravataAPI(airavataAPI);
        configuration.setAiravataAPI(airavataAPI);
        configuration.setRegigstryUserName(this.userName);
        configuration.setRegistryPassphrase(this.password);
        configuration.setRegistryURL(url);
        configuration.setDefaultGateway(this.gateway);
        this.engine.updateXBayaConfigurationServiceURLs();
        this.hide();
    }

    private void createNewUser() {
        URL specifiedURL = null;
        try {
            specifiedURL = new URL(this.urlTextField.getText());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.newUserWindow == null) {
            this.newUserWindow = new NewRegistryUserDialog(this.engine);
        }
        this.newUserWindow.setUsername(this.usernameTextField.getText());
        this.newUserWindow.updateControlData();
        this.newUserWindow.show();
        if (this.newUserWindow.isUserCreated()) {
            this.usernameTextField.setText(this.newUserWindow.getUsername());
            this.passwordTextField.setText(this.newUserWindow.getPassword());
        }
    }

    private void initGUI() {
        this.urlTextField = new XBayaTextField();
        this.gatewayTextField = new XBayaTextField();
        this.usernameTextField = new XBayaTextField();
        this.passwordTextField = new JPasswordField();
        try {
            if (RegistryWindow.getPreviousRegURL() != null) {
                this.urlTextField.setText(this.engine.getConfiguration().getRegistryURL().toASCIIString());
            } else if (this.engine.getConfiguration().isRegURLSetByCMD()) {
                this.urlTextField.setText(this.engine.getConfiguration().getRegistryURL().toASCIIString());
            } else if (ClientSettings.isSettingDefined((String)"xbaya.registry.url")) {
                this.urlTextField.setText(ClientSettings.getSetting((String)"xbaya.registry.url"));
            } else {
                this.urlTextField.setText(this.engine.getConfiguration().getRegistryURL().toASCIIString());
            }
            if (ClientSettings.isSettingDefined((String)"xbaya.registry.user")) {
                this.usernameTextField.setText(ClientSettings.getSetting((String)"xbaya.registry.user"));
            } else {
                this.usernameTextField.setText(this.engine.getConfiguration().getRegistryUserName());
            }
            if (ClientSettings.isSettingDefined((String)"xbaya.default.gateway")) {
                this.gatewayTextField.setText(ClientSettings.getSetting((String)"xbaya.default.gateway"));
            } else {
                this.gatewayTextField.setText(this.engine.getConfiguration().getDefaultGateway());
            }
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
        try {
            ClientSettings.initializeTrustStore();
        }
        catch (ApplicationSettingsException e) {
            throw new RuntimeException("An error occurred while initializing client configurations");
        }
        this.passwordTextField.setText(this.engine.getConfiguration().getRegistryPassphrase());
        XBayaLabel urlLabel = new XBayaLabel("Registry URL", this.urlTextField);
        XBayaLabel gatewayLabel = new XBayaLabel("Gateway", this.gatewayTextField);
        XBayaLabel nameLabel = new XBayaLabel("Username", this.usernameTextField);
        XBayaLabel passLabel = new XBayaLabel("Password", this.usernameTextField);
        this.newUserButton = new XBayaLinkButton("Create new user...");
        this.newUserButton.setHorizontalAlignment(4);
        JLabel emptyLabel = new JLabel("");
        this.newUserButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryWindow.this.createNewUser();
            }
        });
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(urlLabel);
        infoPanel.add(this.urlTextField);
        infoPanel.add(gatewayLabel);
        infoPanel.add(this.gatewayTextField);
        infoPanel.add(nameLabel);
        infoPanel.add(this.usernameTextField);
        infoPanel.add(passLabel);
        infoPanel.add(this.passwordTextField);
        infoPanel.add(emptyLabel);
        infoPanel.add(this.newUserButton);
        infoPanel.layout(5, 2, -1, 1);
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryWindow.this.ok();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistryWindow.this.hide();
            }
        });
        GridPanel buttonPanel = new GridPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Configure Airavata Registry", (XBayaComponent)infoPanel, buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }

    public AiravataAPI getAiravataAPI() {
        try {
            URI regURI = new URI(this.getRegURL());
            PasswordCallbackImpl passwordCallback = new PasswordCallbackImpl(this.userName, this.password);
            AiravataAPI airavataAPI = AiravataAPIFactory.getAPI((URI)regURI, (String)this.getGateway(), (String)this.userName, (PasswordCallback)passwordCallback);
            return airavataAPI;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRegURL() {
        return this.regURL;
    }

    public void setRegURL(String regURL) {
        this.regURL = regURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public static String getPreviousRegURL() {
        return previousRegURL;
    }

    public static void setPreviousRegURL(String previousRegURL) {
        RegistryWindow.previousRegURL = previousRegURL;
    }
}

