/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.registry;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class NewRegistryUserDialog {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XBayaTextField usernameTextField;
    private JPasswordField passwordTextField;
    private String gatewayName = "default";
    private String username;
    private URL url;
    private String password;
    private JPasswordField confirmPasswordTextField;
    private JButton okButton;
    private boolean userCreated = false;

    public NewRegistryUserDialog(XBayaEngine engine) {
        this(engine, null, null);
    }

    public NewRegistryUserDialog(XBayaEngine engine, URL url) {
        this(engine, url, null);
    }

    public NewRegistryUserDialog(XBayaEngine engine, String username) {
        this(engine, null, username);
    }

    public NewRegistryUserDialog(XBayaEngine engine, URL url, String username) {
        this.engine = engine;
        this.setUrl(url);
        this.setUsername(username);
        this.initGUI();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setData() {
        this.updateUsername();
        this.updatePassword();
    }

    private void ok() {
        this.setData();
        String status = this.updateStatus();
        if (status == null) {
            try {
                GatewayResource gatewayResource = (GatewayResource)ResourceUtils.getGateway((String)this.getGatewayName());
                UserResource userResource = (UserResource)gatewayResource.create(ResourceType.USER);
                userResource.setUserName(this.getUsername());
                userResource.setPassword(this.getPassword());
                userResource.save();
                WorkerResource workerResource = (WorkerResource)gatewayResource.create(ResourceType.GATEWAY_WORKER);
                workerResource.setUser(userResource.getUserName());
                workerResource.save();
                this.setUserCreated(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.engine.getGUI().getErrorWindow().error(e.getMessage());
            }
        } else {
            this.engine.getGUI().getErrorWindow().error(status);
        }
        this.close();
    }

    private String updateStatus() {
        String msg = null;
        if (this.getUsername() == null || this.getUsername().equals("")) {
            msg = "Username cannot be empty";
        } else if (this.getPassword() == null || this.getPassword().equals("")) {
            msg = "Passwords must match or cannot be empty";
        }
        return msg;
    }

    private void initGUI() {
        this.usernameTextField = new XBayaTextField();
        this.passwordTextField = new JPasswordField();
        this.confirmPasswordTextField = new JPasswordField();
        XBayaLabel userLabel = new XBayaLabel("Username", this.usernameTextField);
        XBayaLabel passLabel = new XBayaLabel("Password", this.passwordTextField);
        XBayaLabel confirmPassLabel = new XBayaLabel("Confirm Password", this.confirmPasswordTextField);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(userLabel);
        infoPanel.add(this.usernameTextField);
        infoPanel.add(passLabel);
        infoPanel.add(this.passwordTextField);
        infoPanel.add(confirmPassLabel);
        infoPanel.add(this.confirmPasswordTextField);
        infoPanel.layout(3, 2, -1, 1);
        this.usernameTextField.getSwingComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewRegistryUserDialog.this.updateUsername();
                NewRegistryUserDialog.this.updateStatus();
            }
        });
        this.passwordTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewRegistryUserDialog.this.updatePassword();
                NewRegistryUserDialog.this.updateStatus();
            }
        });
        this.confirmPasswordTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewRegistryUserDialog.this.updatePassword();
                NewRegistryUserDialog.this.updateStatus();
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewRegistryUserDialog.this.ok();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewRegistryUserDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Registry New User", (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(this.okButton);
        this.updateControlData();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void updateControlData() {
        if (this.usernameTextField != null && this.getUsername() != null) {
            this.usernameTextField.setText(this.getUsername());
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void updateUsername() {
        this.setUsername(this.usernameTextField.getText());
    }

    private void updatePassword() {
        String ctext;
        String password = null;
        String ptext = new String(this.passwordTextField.getPassword());
        if (ptext.equals(ctext = new String(this.confirmPasswordTextField.getPassword()))) {
            password = ptext;
        }
        this.setPassword(password);
    }

    public boolean isUserCreated() {
        return this.userCreated;
    }

    public void setUserCreated(boolean userCreated) {
        this.userCreated = userCreated;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public void close() {
        this.hide();
    }
}

