/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.monitor;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class MonitorConfigurationWindow {
    private XBayaEngine engine;
    private MonitorConfiguration configuration;
    private XBayaDialog dialog;
    private XBayaTextField brokerTextField;
    private XBayaTextField topicTextField;
    private JCheckBox pullCheckBox;
    private XBayaTextField messageBoxTextField;

    public MonitorConfigurationWindow(XBayaEngine engine) {
        this.engine = engine;
        this.configuration = engine.getMonitor().getConfiguration();
        this.initGui();
    }

    public void show() {
        this.brokerTextField.setText(this.configuration.getBrokerURL());
        this.topicTextField.setText(this.configuration.getTopic());
        this.pullCheckBox.setSelected(this.configuration.isPullMode());
        this.messageBoxTextField.setText(this.configuration.getMessageBoxURL());
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setConfiguration() {
        URI brokerURL;
        String broker = this.brokerTextField.getText();
        String topic = this.topicTextField.getText();
        String messageBox = this.messageBoxTextField.getText();
        boolean pull = this.pullCheckBox.isSelected();
        if (broker.length() == 0) {
            this.engine.getGUI().getErrorWindow().error("Broker URL cannot be empty");
            return;
        }
        try {
            brokerURL = new URI(broker).parseServerAuthority();
        }
        catch (URISyntaxException e) {
            String message = "Broker URL is in a wrong format";
            this.engine.getGUI().getErrorWindow().error(message, e);
            return;
        }
        if (topic.length() == 0) {
            String message = "Topic cannot be empty";
            this.engine.getGUI().getErrorWindow().error(message);
            return;
        }
        URI messageBoxURL = null;
        if (pull) {
            if (messageBox.length() == 0) {
                this.engine.getGUI().getErrorWindow().error("Message box URL cannot be empty");
                return;
            }
            try {
                messageBoxURL = new URI(messageBox).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                String message = "Message box URL is in a wrong format";
                this.engine.getGUI().getErrorWindow().error(message, e);
                return;
            }
        } else {
            messageBoxURL = this.configuration.getMessageBoxURL();
        }
        this.configuration.set(brokerURL, topic, pull, messageBoxURL);
        this.engine.getConfiguration().setMessageBoxURL(messageBoxURL);
        this.engine.getConfiguration().setBrokerURL(brokerURL);
        this.engine.getConfiguration().setTopic(topic);
        this.hide();
    }

    private void initGui() {
        this.brokerTextField = new XBayaTextField();
        XBayaLabel brokerLabel = new XBayaLabel("Broker URL", this.brokerTextField);
        this.topicTextField = new XBayaTextField();
        XBayaLabel topicLabel = new XBayaLabel("Topic", this.topicTextField);
        this.pullCheckBox = new JCheckBox("Pull Mode");
        JLabel dummyLabel = new JLabel();
        this.messageBoxTextField = new XBayaTextField();
        XBayaLabel msgBoxLabel = new XBayaLabel("Message Box URL", this.messageBoxTextField);
        this.messageBoxTextField.setEnabled(false);
        this.pullCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                int stateChange = event.getStateChange();
                if (stateChange == 1) {
                    MonitorConfigurationWindow.this.messageBoxTextField.setEnabled(true);
                } else if (stateChange == 2) {
                    MonitorConfigurationWindow.this.messageBoxTextField.setEnabled(false);
                }
            }
        });
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(brokerLabel);
        infoPanel.add(this.brokerTextField);
        infoPanel.add(topicLabel);
        infoPanel.add(this.topicTextField);
        infoPanel.add(dummyLabel);
        infoPanel.add(this.pullCheckBox);
        infoPanel.add(msgBoxLabel);
        infoPanel.add(this.messageBoxTextField);
        infoPanel.layout(4, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorConfigurationWindow.this.setConfiguration();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorConfigurationWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Notification Configuration", (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

