/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.ws;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.common.utils.WSDLUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import xsul5.wsdl.WsdlDefinitions;

public class WSNodeWindow {
    private XBayaEngine engine;
    private WSNode node;
    private XBayaDialog dialog;
    private XBayaTextField nameTextField;
    private XBayaTextField idTextField;
    private XBayaTextField typeTextField;
    private XBayaTextArea wsdlTextArea;

    public WSNodeWindow(XBayaEngine engine, WSNode node) {
        this.engine = engine;
        this.node = node;
        this.initGUI();
    }

    public void show() {
        WsdlDefinitions wsdl = this.node.getComponent().getWSDL();
        String type = WSDLUtil.isAWSDL((WsdlDefinitions)wsdl) ? "Abstract WSDL" : "Concrete WSDL";
        this.nameTextField.setText(this.node.getName());
        this.idTextField.setText(this.node.getID());
        this.typeTextField.setText(type);
        this.wsdlTextArea.setText(XMLUtil.BUILDER.serializeToStringPretty((Object)wsdl.xml()));
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void initGUI() {
        this.nameTextField = new XBayaTextField();
        this.nameTextField.setEditable(false);
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.idTextField = new XBayaTextField();
        this.idTextField.setEditable(false);
        XBayaLabel idLabel = new XBayaLabel("ID", this.idTextField);
        this.typeTextField = new XBayaTextField();
        this.typeTextField.setEditable(false);
        XBayaLabel typeLabel = new XBayaLabel("Type", this.typeTextField);
        this.wsdlTextArea = new XBayaTextArea();
        this.wsdlTextArea.setEditable(false);
        XBayaLabel wsdlLabel = new XBayaLabel("WSDL", this.wsdlTextArea);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(nameLabel);
        infoPanel.add(this.nameTextField);
        infoPanel.add(idLabel);
        infoPanel.add(this.idTextField);
        infoPanel.add(typeLabel);
        infoPanel.add(this.typeTextField);
        infoPanel.add(wsdlLabel);
        infoPanel.add(this.wsdlTextArea);
        infoPanel.layout(4, 2, 3, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WSNodeWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), this.node.getName(), (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

