/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.ws;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.views.MonitorPanel;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class ServiceInteractionWindow {
    private XBayaGUI xbayaGUI;
    private XBayaDialog dialog;
    private WaitDialog invokingDialog;
    private XBayaTextArea consoleTextArea;
    private XBayaTextField commandField;
    private String nodeID;
    private Monitor monitor;

    public ServiceInteractionWindow(XBayaGUI xbayaGUI, String nodeID, Monitor monitor) {
        this.xbayaGUI = xbayaGUI;
        this.nodeID = nodeID;
        this.monitor = monitor;
        this.initGui();
    }

    private void initGui() {
        GridPanel mainPanel = new GridPanel();
        MonitorPanel monitorPanel = new MonitorPanel(this.xbayaGUI, this.nodeID, this.monitor);
        this.consoleTextArea = new XBayaTextArea();
        XBayaLabel consoleLabel = new XBayaLabel("Console", this.consoleTextArea);
        this.commandField = new XBayaTextField();
        XBayaLabel commandLabel = new XBayaLabel("Command", this.commandField);
        mainPanel.add(monitorPanel);
        mainPanel.add(consoleLabel);
        mainPanel.add(this.consoleTextArea);
        mainPanel.add(commandLabel);
        mainPanel.add(this.commandField);
        mainPanel.layout(5, 1, -1, 1);
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceInteractionWindow.this.send();
            }
        });
        JButton cancelButton = new JButton("Done");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceInteractionWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(sendButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Deploy workflow to ODE and Registry", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(sendButton);
    }

    private void hide() {
        this.dialog.hide();
    }

    public void show() {
        this.dialog.show();
    }

    private void send() {
        String command = this.commandField.getText();
        this.commandField.setText("");
        this.consoleTextArea.setText(this.consoleTextArea.getText() + "\n>" + command + "\n");
    }
}

