/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.workflow.model.graph.system.StreamSourceNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class StreamSourceConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private StreamSourceNode node;
    private XBayaDialog dialog;
    private GridPanel gridPanel;
    private XBayaLabel wsdlLabel;
    private XBayaTextField wsdlTextField;
    private XBayaLabel descriptionLabel;
    private XBayaTextField descriptionTextField;

    public StreamSourceConfigurationDialog(StreamSourceNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setInput() {
        this.node.setStreamSourceURL(this.wsdlTextField.getText());
        this.node.setConfigured(true);
        this.node.setDescription(this.descriptionTextField.getText());
        this.hide();
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void initGui() {
        this.wsdlTextField = new XBayaTextField();
        this.wsdlLabel = new XBayaLabel("The EPR of the Stream Source", this.wsdlTextField);
        this.descriptionTextField = new XBayaTextField();
        this.descriptionLabel = new XBayaLabel("Description", this.descriptionTextField);
        this.gridPanel = new GridPanel();
        this.gridPanel.add(this.wsdlLabel);
        this.gridPanel.add(this.wsdlTextField);
        this.gridPanel.add(this.descriptionLabel);
        this.gridPanel.add(this.descriptionTextField);
        this.gridPanel.layout(2, 2, 1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreamSourceConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StreamSourceConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Configure Streaming Data source", (XBayaComponent)this.gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

