/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.airavata.workflow.model.graph.system.S3InputNode;
import org.apache.airavata.xbaya.core.amazon.AmazonCredential;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.dialogs.amazon.BucketsLoader;
import org.apache.airavata.xbaya.ui.dialogs.amazon.ChangeCredentialWindow;
import org.apache.airavata.xbaya.ui.widgets.amazon.S3Tree;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3FileChooser
implements TreeSelectionListener {
    private XBayaDialog dialog;
    private XBayaGUI xbayaGUI;
    protected S3InputNode inputNode;
    private String chosenFile;
    private S3Tree s3Tree;

    public S3FileChooser(XBayaGUI xbayaGUI, S3InputNode inputNode) {
        this.xbayaGUI = xbayaGUI;
        this.inputNode = inputNode;
        this.initGUI();
    }

    private void initGUI() {
        this.s3Tree = new S3Tree();
        this.s3Tree.addTreeSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.s3Tree);
        JButton refreshButton = new JButton("Connect/Refresh");
        refreshButton.addActionListener(new AbstractAction(){
            private ChangeCredentialWindow credentialWindow;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AmazonCredential.getInstance().getAwsAccessKeyId().isEmpty() || AmazonCredential.getInstance().getAwsSecretAccessKey().isEmpty()) {
                    S3FileChooser.this.xbayaGUI.getErrorWindow().warning(S3FileChooser.this.dialog.getDialog(), "Error", "Aws Access Key not set!");
                    if (this.credentialWindow == null) {
                        this.credentialWindow = new ChangeCredentialWindow(S3FileChooser.this.dialog.getDialog());
                    }
                    try {
                        this.credentialWindow.show();
                    }
                    catch (Exception e1) {
                        S3FileChooser.this.xbayaGUI.getErrorWindow().error(e1);
                    }
                    return;
                }
                S3FileChooser.this.s3Tree.clean();
                try {
                    RestS3Service s3Service = new RestS3Service((ProviderCredentials)new AWSCredentials(AmazonCredential.getInstance().getAwsAccessKeyId(), AmazonCredential.getInstance().getAwsSecretAccessKey()));
                    BucketsLoader bucketsLoader = new BucketsLoader(S3FileChooser.this.xbayaGUI, S3FileChooser.this.dialog.getDialog());
                    bucketsLoader.load((S3Service)s3Service, S3FileChooser.this.s3Tree);
                }
                catch (S3ServiceException s3ex) {
                    S3FileChooser.this.xbayaGUI.getErrorWindow().error(s3ex);
                }
            }
        });
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (S3FileChooser.this.chosenFile != null) {
                    S3FileChooser.this.inputNode.setDefaultValue((Object)new String(S3FileChooser.this.chosenFile));
                }
                S3FileChooser.this.hide();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                S3FileChooser.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(refreshButton);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Amazon S3 Input Chooser", (JComponent)scrollPane, (JComponent)buttonPanel);
    }

    public void hide() {
        this.dialog.hide();
    }

    public void show() {
        this.dialog.show();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = this.s3Tree.getSelectedNode();
        if (node == null) {
            this.chosenFile = null;
            return;
        }
        Object nodeInfo = node.getUserObject();
        String bucketName = "";
        if (node.isLeaf()) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            bucketName = (String)parentNode.getUserObject();
            String keyName = (String)nodeInfo;
            this.chosenFile = "s3n://" + bucketName + "/" + keyName;
        } else {
            bucketName = (String)nodeInfo;
            this.chosenFile = "s3n://" + bucketName;
        }
    }
}

