/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.system.OutputNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.xmlpull.infoset.XmlElement;

public class OutputConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private OutputNode node;
    private XBayaDialog dialog;
    private XBayaTextField nameTextField;
    private XBayaTextArea descriptionTextArea;
    private XBayaTextArea metadataTextArea;

    public OutputConfigurationDialog(OutputNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        String name = this.node.getConfiguredName();
        if (name == null) {
            name = this.node.getName();
        }
        this.nameTextField.setText(name);
        this.descriptionTextArea.setText(this.node.getDescription());
        XmlElement metadata = this.node.getMetadata();
        String metadataText = metadata == null ? "<appinfo xmlns=\"http://www.w3.org/2001/XMLSchema\">\n\n</appinfo>" : XMLUtil.xmlElementToString((XmlElement)metadata);
        this.metadataTextArea.setText(metadataText);
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setInput() {
        XmlElement metadata;
        String name = this.nameTextField.getText();
        String description = this.descriptionTextArea.getText();
        String metadataText = this.metadataTextArea.getText();
        if (name.length() == 0) {
            String warning = "The name cannot be empty.";
            this.xbayaGUI.getErrorWindow().error(warning);
            return;
        }
        if (metadataText.length() == 0) {
            metadata = null;
        } else {
            try {
                metadata = XMLUtil.stringToXmlElement((String)metadataText);
            }
            catch (RuntimeException e) {
                String warning = "The metadata is ill-formed.";
                this.xbayaGUI.getErrorWindow().error(warning, e);
                return;
            }
        }
        this.node.setConfigured(true);
        this.node.setConfiguredName(name);
        this.node.setDescription(description);
        this.node.setMetadata(metadata);
        this.hide();
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void initGui() {
        this.nameTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.descriptionTextArea = new XBayaTextArea();
        XBayaLabel descriptionLabel = new XBayaLabel("Description", this.descriptionTextArea);
        this.metadataTextArea = new XBayaTextArea();
        XBayaLabel metadataLabel = new XBayaLabel("Metadata", this.metadataTextArea);
        GridPanel mainPanel = new GridPanel();
        mainPanel.add(nameLabel);
        mainPanel.add(this.nameTextField);
        mainPanel.add(descriptionLabel);
        mainPanel.add(this.descriptionTextArea);
        mainPanel.add(metadataLabel);
        mainPanel.add(this.metadataTextArea);
        mainPanel.layout(3, 2, 2, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Input Parameter Configuration", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

