/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.workflow.model.graph.system.MemoNode;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;

public class MemoConfigurationDialog {
    private XBayaEngine engine;
    private MemoNode node;
    private XBayaDialog dialog;
    private XBayaTextArea memoTextArea;

    public MemoConfigurationDialog(MemoNode node, XBayaEngine engine) {
        this.engine = engine;
        this.node = node;
        this.initGui();
    }

    public void show() {
        this.memoTextArea.setText(this.node.getMemo());
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setInput() {
        String memo = this.memoTextArea.getText();
        this.node.setMemo(memo);
        this.hide();
        this.engine.getGUI().getGraphCanvas().repaint();
    }

    private void initGui() {
        this.memoTextArea = new XBayaTextArea();
        XBayaLabel memoLabel = new XBayaLabel("Memo", this.memoTextArea);
        GridPanel gridPanel = new GridPanel();
        gridPanel.add(memoLabel);
        gridPanel.add(this.memoTextArea);
        gridPanel.layout(1, 2, 0, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Memo", (XBayaComponent)gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

