/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.airavata.workflow.model.graph.GraphException;
import org.apache.airavata.workflow.model.graph.system.EndForEachNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class EndForEachConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private EndForEachNode node;
    private XBayaDialog dialog;
    private XBayaTextField nameTextField;
    private XBayaTextField idTextField;
    private JSpinner numPorts;

    public EndForEachConfigurationDialog(EndForEachNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        String name = this.node.getName();
        this.nameTextField.setText(name);
        this.idTextField.setText(this.node.getID());
        int number = this.node.getInputPorts().size();
        this.numPorts.setValue(number);
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setInput() {
        Integer value = (Integer)this.numPorts.getValue();
        int number = value;
        int current = this.node.getOutputPorts().size();
        try {
            if (number > current) {
                for (int i = 0; i < number - current; ++i) {
                    this.node.addInputPort();
                    this.node.addOutputPort();
                }
            } else if (number < current) {
                for (int i = 0; i < current - number; ++i) {
                    this.node.removeInputPort();
                    this.node.removeOutputPort();
                }
            }
        }
        catch (GraphException e) {
            this.xbayaGUI.getErrorWindow().error("Unexpected error.", e);
        }
        this.hide();
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void initGui() {
        this.nameTextField = new XBayaTextField();
        this.nameTextField.setEditable(false);
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.idTextField = new XBayaTextField();
        this.idTextField.setEditable(false);
        XBayaLabel idLabel = new XBayaLabel("ID", this.idTextField);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
        this.numPorts = new JSpinner(model);
        XBayaLabel numPortLabel = new XBayaLabel("Number of Parameters", this.numPorts);
        GridPanel gridPanel = new GridPanel();
        gridPanel.add(nameLabel);
        gridPanel.add(this.nameTextField);
        gridPanel.add(idLabel);
        gridPanel.add(this.idTextField);
        gridPanel.add(numPortLabel);
        gridPanel.add(this.numPorts);
        gridPanel.layout(3, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EndForEachConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EndForEachConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "EndForEach Configuration", (XBayaComponent)gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

