/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.DifferedInputNode;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.lead.LEADTypes;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.graph.system.DifferedInputNodeGUI;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.xmlpull.infoset.XmlElement;

public class DifferedInputConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private DifferedInputNode node;
    private XBayaDialog dialog;
    private GridPanel gridPanel;
    private XBayaTextField nameTextField;
    private XBayaTextArea descriptionTextArea;
    private XBayaLabel valueLabel;
    private XBayaTextField valueTextField;
    private XBayaTextArea valueTextArea;
    private XBayaTextArea metadataTextArea;

    public DifferedInputConfigurationDialog(DifferedInputNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        XBayaTextComponent textComponent;
        QName type = this.node.getParameterType();
        boolean knownType = LEADTypes.isKnownType(type);
        if (knownType) {
            textComponent = this.valueTextField;
            this.valueLabel.setText("Default value");
        } else {
            textComponent = this.valueTextArea;
            this.valueLabel.setText("Default value (in XML)");
        }
        this.valueLabel.setLabelFor(textComponent);
        int index = 5;
        this.gridPanel.remove(5);
        this.gridPanel.add(textComponent, 5);
        if (knownType) {
            this.gridPanel.layout(new double[]{0.0, 0.5, 0.0, 0.5}, new double[]{0.0, 1.0});
        } else {
            this.gridPanel.layout(new double[]{0.0, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, new double[]{0.0, 1.0});
        }
        String name = this.node.getID();
        this.nameTextField.setText(name);
        this.descriptionTextArea.setText(this.node.getDescription());
        Object value = this.node.getDefaultValue();
        String valueString = value == null ? "" : (value instanceof XmlElement ? XMLUtil.xmlElementToString((XmlElement)((XmlElement)value)) : value.toString());
        textComponent.setText(valueString);
        XmlElement metadata = this.node.getMetadata();
        String metadataText = metadata == null ? "<appinfo xmlns=\"http://www.w3.org/2001/XMLSchema\">\n\n</appinfo>" : XMLUtil.xmlElementToString((XmlElement)metadata);
        this.metadataTextArea.setText(metadataText);
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
        ((DifferedInputNodeGUI)NodeController.getGUI((Node)this.node)).closingDisplay();
    }

    private void setInput() {
        XmlElement metadata;
        QName type = this.node.getParameterType();
        XBayaTextComponent textComponent = LEADTypes.isKnownType(type) ? this.valueTextField : this.valueTextArea;
        String name = this.nameTextField.getText();
        String description = this.descriptionTextArea.getText();
        String valueString = textComponent.getText();
        String metadataText = this.metadataTextArea.getText();
        if (name.length() == 0) {
            String warning = "The name cannot be empty.";
            this.xbayaGUI.getErrorWindow().error(warning);
            return;
        }
        Object value = null;
        if (valueString.length() > 0) {
            if (LEADTypes.isKnownType(type)) {
                if (!this.node.isInputValid(valueString)) {
                    String warning = "The defalut value is not valid for " + this.node.getParameterType() + ".";
                    this.xbayaGUI.getErrorWindow().error(warning);
                }
                value = valueString;
            } else {
                try {
                    value = XMLUtil.stringToXmlElement((String)valueString);
                }
                catch (RuntimeException e) {
                    String warning = "The XML for the default value is not valid.";
                    this.xbayaGUI.getErrorWindow().error(warning, e);
                }
            }
        }
        if (metadataText.length() == 0) {
            metadata = null;
        } else {
            try {
                metadata = XMLUtil.stringToXmlElement((String)metadataText);
            }
            catch (RuntimeException e) {
                String warning = "The metadata is ill-formed.";
                this.xbayaGUI.getErrorWindow().error(warning, e);
                return;
            }
        }
        this.node.setConfigured(true);
        this.node.setConfiguredName(name);
        this.node.setDescription(description);
        this.node.setDefaultValue(value);
        this.node.setMetadata(metadata);
        this.node.setState(Node.NodeExecutionState.FINISHED);
        this.hide();
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void initGui() {
        this.nameTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.descriptionTextArea = new XBayaTextArea();
        XBayaLabel descriptionLabel = new XBayaLabel("Description", this.descriptionTextArea);
        this.valueTextField = new XBayaTextField();
        this.valueTextArea = new XBayaTextArea();
        this.valueLabel = new XBayaLabel("", this.valueTextField);
        this.metadataTextArea = new XBayaTextArea();
        XBayaLabel metadataLabel = new XBayaLabel("Metadata", this.metadataTextArea);
        this.gridPanel = new GridPanel();
        this.gridPanel.add(nameLabel);
        this.gridPanel.add(this.nameTextField);
        this.gridPanel.add(descriptionLabel);
        this.gridPanel.add(this.descriptionTextArea);
        this.gridPanel.add(this.valueLabel);
        this.gridPanel.add(this.valueTextField);
        this.gridPanel.add(metadataLabel);
        this.gridPanel.add(this.metadataTextArea);
        this.gridPanel.layout(4, 2, 3, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DifferedInputConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DifferedInputConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Input Parameter Configuration", (XBayaComponent)this.gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

