/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.system;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.graph.system.ConstantNode;
import org.apache.airavata.xbaya.lead.LEADTypes;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.xmlpull.infoset.XmlElement;

public class ConstantConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private ConstantNode node;
    private XBayaDialog dialog;
    private GridPanel gridPanel;
    private XBayaTextField nameTextField;
    private XBayaTextField idTextField;
    private XBayaTextField typeTextField;
    private XBayaLabel valueLabel;
    private XBayaTextField valueTextField;
    private XBayaTextArea valueTextArea;

    public ConstantConfigurationDialog(ConstantNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        XBayaTextComponent textComponent;
        QName type = this.node.getType();
        if (LEADTypes.isKnownType(type)) {
            textComponent = this.valueTextField;
            this.valueLabel.setText("Default value");
        } else {
            textComponent = this.valueTextArea;
            this.valueLabel.setText("Default value (in XML)");
        }
        this.valueLabel.setLabelFor(textComponent);
        int index = 7;
        this.gridPanel.remove(7);
        this.gridPanel.add(textComponent, 7);
        this.gridPanel.layout(4, 2, 3, 1);
        String name = this.node.getName();
        this.nameTextField.setText(name);
        this.idTextField.setText(this.node.getID());
        this.typeTextField.setText(type.toString());
        Object value = this.node.getValue();
        String valueString = value == null ? "" : (value instanceof XmlElement ? XMLUtil.xmlElementToString((XmlElement)((XmlElement)value)) : value.toString());
        textComponent.setText(valueString);
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void setInput() {
        String name = this.nameTextField.getText();
        QName type = this.node.getType();
        String valueString = LEADTypes.isKnownType(type) ? this.valueTextField.getText() : this.valueTextArea.getText();
        if (name.length() == 0) {
            String warning = "The name cannot be empty.";
            this.xbayaGUI.getErrorWindow().error(warning);
            return;
        }
        Object value = null;
        if (valueString.length() > 0) {
            if (LEADTypes.isKnownType(type)) {
                if (!this.node.isInputValid(valueString)) {
                    String warning = "The defalut value is not valid for " + this.node.getType() + ".";
                    this.xbayaGUI.getErrorWindow().error(warning);
                }
                value = valueString;
            } else {
                try {
                    value = XMLUtil.stringToXmlElement((String)valueString);
                }
                catch (RuntimeException e) {
                    String warning = "The XML for the default value is not valid.";
                    this.xbayaGUI.getErrorWindow().error(warning, e);
                }
            }
        }
        this.node.setName(name);
        this.node.setValue(value);
        this.hide();
        this.xbayaGUI.getGraphCanvas().repaint();
    }

    private void initGui() {
        this.nameTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.idTextField = new XBayaTextField();
        this.idTextField.setEditable(false);
        XBayaLabel idLabel = new XBayaLabel("ID", this.idTextField);
        this.typeTextField = new XBayaTextField();
        this.typeTextField.setEditable(false);
        XBayaLabel typeLabel = new XBayaLabel("Type", this.typeTextField);
        this.valueTextField = new XBayaTextField();
        this.valueTextArea = new XBayaTextArea();
        this.valueLabel = new XBayaLabel("", this.valueTextField);
        this.gridPanel = new GridPanel();
        this.gridPanel.add(nameLabel);
        this.gridPanel.add(this.nameTextField);
        this.gridPanel.add(idLabel);
        this.gridPanel.add(this.idTextField);
        this.gridPanel.add(typeLabel);
        this.gridPanel.add(this.typeTextField);
        this.gridPanel.add(this.valueLabel);
        this.gridPanel.add(this.valueTextField);
        this.gridPanel.layout(4, 2, 3, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstantConfigurationDialog.this.setInput();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstantConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Constant Configuration", (XBayaComponent)this.gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

