/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.dynamic;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.common.utils.XMLUtil;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.system.InputNode;
import org.apache.airavata.workflow.model.graph.util.GraphUtil;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.ode.ODEClient;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.ws.monitor.MonitorException;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.graph.controller.NodeController;
import org.apache.airavata.xbaya.interpretor.GUIWorkflowInterpreterInteractorImpl;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreterConfiguration;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.graph.ws.WSNodeGUI;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.airavata.xbaya.util.XBayaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import xsul.XmlConstants;
import xsul.lead.LeadResourceMapping;

public class DynamicWorkflowRunnerWindow {
    private static final Logger logger = LoggerFactory.getLogger(DynamicWorkflowRunnerWindow.class);
    private XBayaEngine engine;
    private Workflow workflow;
    private XBayaDialog dialog;
    private GridPanel parameterPanel;
    private XBayaTextField topicTextField;
    private List<XBayaTextField> parameterTextFields = new ArrayList<XBayaTextField>();
    private XBayaLabel resourceSelectionLabel;
    private JCheckBox interactChkBox;
    private JCheckBox chkRunWithCrossProduct;
    private XBayaTextField instanceNameTextField;
    protected static final XmlInfosetBuilder builder = XmlConstants.BUILDER;

    public DynamicWorkflowRunnerWindow(XBayaEngine engine) {
        this.engine = engine;
        if (XBayaUtil.acquireJCRRegistry(this.engine)) {
            this.initGUI();
        }
    }

    public void show() {
        this.workflow = this.engine.getGUI().getWorkflow();
        MonitorConfiguration notifConfig = this.engine.getMonitor().getConfiguration();
        if (notifConfig.getBrokerURL() == null) {
            this.engine.getGUI().getErrorWindow().error("Broker URL is not set.");
            return;
        }
        List inputNodes = GraphUtil.getInputNodes((Graph)this.workflow.getGraph());
        Iterator iterator = inputNodes.iterator();
        while (iterator.hasNext()) {
            String valueString;
            InputNode node = (InputNode)iterator.next();
            String id = node.getID();
            QName parameterType = node.getParameterType();
            if (parameterType == null) {
                iterator.remove();
                continue;
            }
            JLabel nameLabel = new JLabel(id);
            JLabel typeField = new JLabel(parameterType.getLocalPart());
            XBayaTextField paramField = new XBayaTextField();
            Object value = node.getDefaultValue();
            if (value == null) {
                valueString = "";
            } else if (value instanceof XmlElement) {
                XmlElement valueElement = (XmlElement)value;
                valueString = XMLUtil.xmlElementToString((XmlElement)valueElement);
            } else {
                valueString = value.toString();
            }
            if (!node.isVisibility()) {
                paramField.setEditable(false);
            }
            paramField.setText(valueString);
            this.parameterPanel.add(nameLabel);
            this.parameterPanel.add(typeField);
            this.parameterPanel.add(paramField);
            this.parameterTextFields.add(paramField);
        }
        this.parameterPanel.layout(inputNodes.size(), 3, -1, 2);
        this.topicTextField.setText(UUID.randomUUID().toString());
        this.dialog.show();
    }

    public void hide() {
        this.dialog.hide();
        this.parameterPanel.resetPanel();
        this.parameterTextFields.clear();
    }

    private void initGUI() {
        this.parameterPanel = new GridPanel(true);
        this.instanceNameTextField = new XBayaTextField();
        XBayaLabel instanceNameLabel = new XBayaLabel("Experiment name", this.instanceNameTextField);
        this.topicTextField = new XBayaTextField();
        XBayaLabel topicLabel = new XBayaLabel("Notification topic", this.topicTextField);
        this.interactChkBox = new JCheckBox();
        this.interactChkBox.setSelected(false);
        XBayaLabel interactLabel = new XBayaLabel("Enable Service Interactions", this.interactChkBox);
        this.chkRunWithCrossProduct = new JCheckBox();
        XBayaLabel crossProductLabel = new XBayaLabel("Execute in cross product", this.chkRunWithCrossProduct);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(instanceNameLabel);
        infoPanel.add(this.instanceNameTextField);
        infoPanel.add(topicLabel);
        infoPanel.add(this.topicTextField);
        infoPanel.add(interactLabel);
        infoPanel.add(this.interactChkBox);
        infoPanel.add(crossProductLabel);
        infoPanel.add(this.chkRunWithCrossProduct);
        infoPanel.layout(5, 2, -1, 1);
        GridPanel mainPanel = new GridPanel();
        mainPanel.add(this.parameterPanel);
        mainPanel.add(infoPanel);
        mainPanel.layout(2, 1, 0, 0);
        JButton okButton = new JButton("Run");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicWorkflowRunnerWindow.this.execute();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicWorkflowRunnerWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Invoke workflow", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }

    private void execute() {
        LeadResourceMapping mapping;
        ArrayList<String> arguments = new ArrayList<String>();
        String instanceName = this.instanceNameTextField.getText();
        if (instanceName.trim().equals("")) {
            JOptionPane.showMessageDialog(this.engine.getGUI().getFrame(), "Experiment name cannot be empty", "Experiment Name", 0);
            return;
        }
        String instanceNameFinal = instanceName;
        String topic = this.topicTextField.getText();
        if (topic.length() == 0) {
            this.engine.getGUI().getErrorWindow().error("Topic cannot be empty.");
            return;
        }
        URI workfowInstanceID = URI.create(StringUtil.convertToJavaIdentifier((String)topic));
        this.workflow.setGPELInstanceID(workfowInstanceID);
        MonitorConfiguration notifConfig = this.engine.getMonitor().getConfiguration();
        notifConfig.setTopic(topic);
        arguments.add("-topic");
        arguments.add(topic);
        Collection wsNodes = GraphUtil.getWSNodes((Graph)this.engine.getGUI().getWorkflow().getGraph());
        if (this.interactChkBox.isSelected()) {
            LinkedList<String> nodeIDs = new LinkedList<String>();
            for (WSNode node : wsNodes) {
                nodeIDs.add(node.getID());
                ((WSNodeGUI)NodeController.getGUI((Node)node)).setInteractiveMode(true);
            }
            notifConfig.setInteractiveNodeIDs(nodeIDs);
        } else {
            for (WSNode node : wsNodes) {
                ((WSNodeGUI)NodeController.getGUI((Node)node)).setInteractiveMode(false);
            }
        }
        final boolean isRunCrossProduct = this.chkRunWithCrossProduct.isSelected();
        List inputNodes = GraphUtil.getInputNodes((Graph)this.workflow.getGraph());
        builder.newFragment("inputs");
        new ODEClient();
        for (int i = 0; i < inputNodes.size(); ++i) {
            InputNode inputNode = (InputNode)inputNodes.get(i);
            XBayaTextField parameterTextField = this.parameterTextFields.get(i);
            inputNode.getID();
            String value = parameterTextField.getText();
            inputNode.setDefaultValue((Object)value);
        }
        this.engine.getConfiguration().setTopic(topic);
        final LeadResourceMapping resourceMapping = mapping = null;
        final String topicString = topic;
        new Thread(){

            @Override
            public void run() {
                XBayaConfiguration conf = DynamicWorkflowRunnerWindow.this.engine.getConfiguration();
                WorkflowInterpreterConfiguration workflowInterpreterConfiguration = new WorkflowInterpreterConfiguration(DynamicWorkflowRunnerWindow.this.engine.getGUI().getWorkflow(), topicString, conf.getMessageBoxURL(), conf.getBrokerURL(), conf.getAiravataAPI(), conf, DynamicWorkflowRunnerWindow.this.engine.getGUI(), DynamicWorkflowRunnerWindow.this.engine.getMonitor());
                workflowInterpreterConfiguration.setRunWithCrossProduct(isRunCrossProduct);
                WorkflowInterpreter workflowInterpreter = new WorkflowInterpreter(workflowInterpreterConfiguration, new GUIWorkflowInterpreterInteractorImpl(DynamicWorkflowRunnerWindow.this.engine, DynamicWorkflowRunnerWindow.this.engine.getGUI().getWorkflow()));
                DynamicWorkflowRunnerWindow.this.engine.registerWorkflowInterpreter(workflowInterpreter);
                try {
                    MonitorConfiguration notifConfig = DynamicWorkflowRunnerWindow.this.engine.getMonitor().getConfiguration();
                    notifConfig.setTopic(topicString);
                    DynamicWorkflowRunnerWindow.this.engine.getMonitor().start();
                    if (resourceMapping != null) {
                        workflowInterpreter.setResourceMapping(resourceMapping);
                    }
                    workflowInterpreter.scheduleDynamically();
                }
                catch (WorkflowException e) {
                    try {
                        workflowInterpreter.cleanup();
                    }
                    catch (MonitorException e1) {
                        DynamicWorkflowRunnerWindow.this.engine.getGUI().getErrorWindow().error(e1);
                    }
                    DynamicWorkflowRunnerWindow.this.engine.getGUI().getErrorWindow().error(e);
                }
            }
        }.start();
        this.hide();
    }
}

