/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.dynamic;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.url.URLComponentRegistry;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.workflow.model.graph.DataPort;
import org.apache.airavata.workflow.model.graph.Graph;
import org.apache.airavata.workflow.model.graph.Node;
import org.apache.airavata.workflow.model.graph.Port;
import org.apache.airavata.workflow.model.graph.dynamic.BasicTypeMapping;
import org.apache.airavata.workflow.model.graph.dynamic.DynamicNode;
import org.apache.airavata.workflow.model.graph.dynamic.SchemaCompilerUtil;
import org.apache.airavata.workflow.model.graph.ws.WSNode;
import org.apache.airavata.workflow.model.graph.ws.WSPort;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentController;
import org.apache.airavata.xbaya.component.registry.ComponentRegistryLoader;
import org.apache.airavata.xbaya.invoker.DynamicServiceCreator;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextArea;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentTreeNode;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.v1.builder.XmlBuilderException;
import xsul5.XmlConstants;
import xsul5.wsdl.WsdlDefinitions;

public class DynamicNodeWindow {
    private static final String CLASSES_DIR = "classes";
    private static final String SRC_DIR = "src";
    private static final String CLASS = "class";
    private static final String PACKAGE = "package";
    private static final String LINE = "\n";
    private static final String TAB = "\t";
    private static final String SPACE = " ";
    private XBayaEngine engine;
    private DynamicNode node;
    private XBayaDialog dialog;
    private XBayaTextArea javaCodeTxtArea;
    private String typesPath;
    private String functionStr;
    private JCheckBox checkBox;

    public DynamicNodeWindow(XBayaEngine engine, DynamicNode node) {
        this.engine = engine;
        this.node = node;
        this.initGUI();
    }

    public void show() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int ret = fileChooser.showOpenDialog(this.engine.getGUI().getFrame());
        if (0 != ret) {
            throw new WorkflowRuntimeException("Cannot proceed without valid directory");
        }
        File selectedDir = fileChooser.getSelectedFile();
        File rootDir = new File(selectedDir, "xbaya");
        DynamicNodeWindow.deleteDir(rootDir);
        rootDir.mkdir();
        File srcDir = new File(rootDir, SRC_DIR);
        srcDir.mkdir();
        File classesDir = new File(rootDir, CLASSES_DIR);
        classesDir.mkdir();
        this.initSchema(rootDir, srcDir, srcDir);
        this.javaCodeTxtArea.setText(this.generateClass());
        this.dialog.show();
        if (this.checkBox.isSelected()) {
            this.deployWebservice();
        } else {
            this.compileAndRegisterJar(rootDir, srcDir, srcDir);
        }
    }

    private void deployWebservice() {
        try {
            DynamicServiceCreator factory = new DynamicServiceCreator("http://129.79.246.108:8080/axis2/services/ServiceCreator?wsdl");
            String code = this.javaCodeTxtArea.getText();
            factory.createService(code);
            URLComponentRegistry registry = null;
            Thread.sleep(10000L);
            registry = new URLComponentRegistry(new URI("http://129.79.246.108:8080/axis2/services/" + this.getClassName(code) + "?wsdl"));
            ComponentRegistryLoader.getLoader(this.engine, "registry.type.url").load((ComponentRegistry)registry);
            Node newNode = this.engine.getGUI().getGraphCanvas().addNode(((ComponentTreeNode)ComponentController.getComponentTree((ComponentRegistry)registry).getFirstLeaf()).getComponentReference().getComponent(), this.node.getPosition());
            List inputPorts = newNode.getInputPorts();
            Graph graph = this.engine.getGUI().getGraphCanvas().getGraph();
            for (int i = 0; i < inputPorts.size(); ++i) {
                graph.addEdge(this.node.getInputPort(i).getFromPort(), (Port)inputPorts.get(i));
            }
            List outputPorts = newNode.getOutputPorts();
            for (int i = 0; i < outputPorts.size(); ++i) {
                List toPorts = this.node.getOutputPort(i).getToPorts();
                for (Port port : toPorts) {
                    graph.removeEdge((Port)this.node.getOutputPort(i), port);
                    graph.addEdge((Port)outputPorts.get(i), port);
                }
            }
            this.engine.getGUI().getWorkflow().removeNode((Node)this.node);
        }
        catch (Exception e) {
            this.engine.getGUI().getErrorWindow().error(e);
        }
    }

    private void hide() {
        this.dialog.hide();
    }

    private void initGUI() {
        BasicTypeMapping.reset();
        this.javaCodeTxtArea = new XBayaTextArea();
        XBayaLabel operationLabel = new XBayaLabel("Operation", this.javaCodeTxtArea);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(operationLabel);
        infoPanel.add(this.javaCodeTxtArea);
        this.checkBox = new JCheckBox("Export as webservice");
        infoPanel.add(new XBayaLabel("", this.checkBox));
        infoPanel.add(this.checkBox);
        infoPanel.layout(2, 2, 0, 0);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicNodeWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), this.node.getName(), (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }

    private String generateClass() {
        String ret = "package org.apache.airavata.xbaya;";
        ret = ret + "\n\n";
        ret = ret + "public class DefaultClassName{";
        ret = ret + "\n\n\tpublic";
        String function = "";
        List toNodes = this.node.getOutputPort(0).getToPorts();
        XmlElement returnElement = null;
        QName returnType = null;
        if (toNodes.size() == 0) {
            function = function + " void";
        } else {
            if (toNodes.size() != 1 || !(toNodes.get(0) instanceof WSPort)) {
                throw new WorkflowRuntimeException("Unhandled  port type for Dynamic component or to many outputs");
            }
            WSPort outPort = (WSPort)toNodes.get(0);
            returnElement = outPort.getComponentPort().getElement();
            returnType = outPort.getType();
            for (Port port : toNodes) {
                if (toNodes.get(0) instanceof DataPort) {
                    if (returnType.equals(((DataPort)toNodes.get(0)).getType())) continue;
                    throw new WorkflowRuntimeException("Dynamic output port connected to input ports of different types.");
                }
                throw new WorkflowRuntimeException("Unhandled  port type for Dynamic component");
            }
            int index = BasicTypeMapping.getSimpleTypeIndex((XmlElement)returnElement);
            if (-1 != index) {
                function = function + SPACE + BasicTypeMapping.getTypeName((int)index);
            } else {
                throw new WorkflowRuntimeException("WIll be fixed with complex type mappign");
            }
        }
        function = function + " operationName(";
        List inputPorts = this.node.getInputPorts();
        boolean first = true;
        for (DataPort inPort : inputPorts) {
            Port fromPort = inPort.getFromPort();
            if (fromPort instanceof WSPort) {
                WSPort wsPort = (WSPort)fromPort;
                XmlElement element = wsPort.getComponentPort().getElement();
                int typeIndex = BasicTypeMapping.getSimpleTypeIndex((XmlElement)element);
                if (-1 != typeIndex) {
                    if (first) {
                        first = false;
                    } else {
                        function = function + " ,";
                    }
                    function = function + BasicTypeMapping.getTypeName((int)typeIndex) + SPACE + BasicTypeMapping.getTypeVariableName((int)typeIndex);
                    continue;
                }
                throw new WorkflowRuntimeException("Complex Type occured:This will be fixed!!!!!");
            }
            throw new WorkflowRuntimeException("Dynamic Node connected to non data port");
        }
        function = function + ")";
        ret = ret + function;
        this.functionStr = function;
        ret = ret + "{\n\n";
        if (null != returnElement) {
            ret = ret + "\t\treturn " + BasicTypeMapping.getTypeDefault((int)BasicTypeMapping.getSimpleTypeIndex((XmlElement)returnElement)) + ";";
        }
        ret = ret + LINE;
        ret = ret + "\t}";
        ret = ret + "\n}";
        return ret;
    }

    private void initSchema(File rootDir, File srcDir, File classesDir) {
        List inputPorts = this.node.getInputPorts();
        for (DataPort inPort : inputPorts) {
            Port fromPort = inPort.getFromPort();
            Node fromNode = inPort.getFromNode();
            if (fromNode instanceof WSNode) {
                WSNode fromWsNode = (WSNode)fromNode;
                if (null != fromPort && fromPort instanceof DataPort) {
                    DataPort fromDataPort = (DataPort)fromPort;
                    WsdlDefinitions wsdl = (WsdlDefinitions)this.engine.getGUI().getWorkflow().getWSDLs().get(fromWsNode.getWSDLID());
                    Iterator itr = wsdl.xml().namespaces().iterator();
                    try {
                        XmlElement schema = wsdl.getTypes().element("schema").clone();
                        schema.setNamespace(XmlConstants.BUILDER.newNamespace("http://www.w3.org/2001/XMLSchema"));
                        while (itr.hasNext()) {
                            XmlNamespace next = (XmlNamespace)itr.next();
                            if ("".equals(next.getPrefix()) || null == next.getPrefix()) continue;
                            schema.setAttributeValue("xmlns:" + next.getPrefix(), next.getName());
                        }
                        try {
                            XmlConstants.BUILDER.serializeToOutputStream((Object)schema, (OutputStream)new FileOutputStream(rootDir.getCanonicalPath() + File.separatorChar + "types.xsd"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.typesPath = rootDir.getCanonicalPath() + File.separatorChar + "mytype.jar";
                        String[] args = new String[]{"-d", classesDir.getCanonicalPath(), "-src", srcDir.getCanonicalPath(), "-out", this.typesPath, rootDir.getCanonicalPath() + File.separatorChar + "types.xsd"};
                        SchemaCompilerUtil.compile((String[])args);
                    }
                    catch (XmlBuilderException e) {
                        this.engine.getGUI().getErrorWindow().error(e);
                    }
                    catch (CloneNotSupportedException e) {
                        this.engine.getGUI().getErrorWindow().error(e);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                throw new WorkflowRuntimeException("Unknown port for code generation" + fromPort);
            }
            throw new WorkflowRuntimeException("Unknown from node for code generation" + fromNode);
        }
    }

    private void compileAndRegisterJar(File rootDir, File srcDir, File classesDir) {
    }

    private String getOperationName(String code) {
        String[] publicSplit = code.split("public");
        String searchStr = this.functionStr.substring(this.functionStr.indexOf("("), this.functionStr.indexOf(")"));
        int index = -1;
        for (int i = 0; i < publicSplit.length; ++i) {
            if (publicSplit[i].indexOf(searchStr) == -1) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new WorkflowRuntimeException("Operation name not found");
        }
        return publicSplit[index].substring(0, publicSplit[index].indexOf(searchStr)).trim().split(SPACE)[1];
    }

    private String getPackageName(String code) {
        return code.substring(code.indexOf(PACKAGE) + PACKAGE.length(), code.indexOf(";")).trim();
    }

    private String getClassName(String code) {
        return code.substring(code.indexOf(CLASS) + CLASS.length(), code.indexOf("{")).trim().split(SPACE)[0].trim();
    }

    private boolean hasComplexTypes() {
        List inputPorts = this.node.getInputPorts();
        for (DataPort inPort : inputPorts) {
            Port fromPort = inPort.getFromPort();
            Node fromNode = inPort.getFromNode();
            if (fromNode instanceof WSNode) {
                if (null != fromPort && fromPort instanceof DataPort) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DynamicNodeWindow.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

