/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.graph.amazon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.airavata.workflow.model.graph.amazon.InstanceNode;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComboBox;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.airavata.xbaya.util.AmazonUtil;

public class InstanceConfigurationDialog {
    private XBayaGUI xbayaGUI;
    private InstanceNode node;
    private XBayaDialog dialog;
    private XBayaTextField nameTextField;
    private XBayaTextField idTextField;
    private XBayaTextField usernameTextField;
    private XBayaComboBox instanceTypeComboBox;
    private JRadioButton amiButton;
    private JRadioButton idButton;

    public InstanceConfigurationDialog(InstanceNode node, XBayaGUI xbayaGUI) {
        this.xbayaGUI = xbayaGUI;
        this.node = node;
        this.initGui();
    }

    public void show() {
        String name = this.node.getName();
        this.nameTextField.setText(name);
        this.amiButton.setSelected(this.node.isStartNewInstance());
        this.idButton.setSelected(!this.node.isStartNewInstance());
        if (this.node.isStartNewInstance()) {
            this.instanceTypeComboBox.getJComboBox().setEnabled(true);
        } else {
            this.instanceTypeComboBox.getJComboBox().setEnabled(false);
        }
        this.idTextField.setText(this.node.getIdAsValue());
        this.usernameTextField.setText(this.node.getUsername());
        if (this.node.getInstanceType() != null) {
            this.instanceTypeComboBox.setSelectedItem(this.node.getInstanceType());
        } else {
            this.instanceTypeComboBox.setSelectedItem(AmazonUtil.INSTANCE_TYPE[1]);
        }
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void initGui() {
        this.nameTextField = new XBayaTextField();
        XBayaLabel nameLabel = new XBayaLabel("Name", this.nameTextField);
        this.nameTextField.setEditable(false);
        this.amiButton = new JRadioButton("Start new instance");
        this.amiButton.setSelected(true);
        this.amiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                InstanceConfigurationDialog.this.instanceTypeComboBox.getJComboBox().setEnabled(true);
            }
        });
        this.instanceTypeComboBox = new XBayaComboBox(new DefaultComboBoxModel<String>(AmazonUtil.INSTANCE_TYPE));
        this.instanceTypeComboBox.setSelectedItem(AmazonUtil.INSTANCE_TYPE[1]);
        GridPanel amiPanel = new GridPanel();
        amiPanel.add(this.amiButton);
        amiPanel.add(this.instanceTypeComboBox);
        amiPanel.layout(1, 2, -1, 1);
        this.idButton = new JRadioButton("Use existing instance");
        this.idButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                InstanceConfigurationDialog.this.instanceTypeComboBox.getJComboBox().setEnabled(false);
            }
        });
        ButtonGroup serviceTypeButtonGroup = new ButtonGroup();
        serviceTypeButtonGroup.add(this.amiButton);
        serviceTypeButtonGroup.add(this.idButton);
        XBayaLabel radioLabel = new XBayaLabel("Options", this.amiButton);
        this.idTextField = new XBayaTextField();
        XBayaLabel idLabel = new XBayaLabel("AMI/Instance ID", this.amiButton);
        this.usernameTextField = new XBayaTextField();
        XBayaLabel usernameLabel = new XBayaLabel("Username", this.amiButton);
        GridPanel gridPanel = new GridPanel();
        gridPanel.add(nameLabel);
        gridPanel.add(this.nameTextField);
        gridPanel.add(radioLabel);
        gridPanel.add(amiPanel);
        gridPanel.add(new JPanel());
        gridPanel.add(this.idButton);
        gridPanel.add(idLabel);
        gridPanel.add(this.idTextField);
        gridPanel.add(usernameLabel);
        gridPanel.add(this.usernameTextField);
        gridPanel.layout(5, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InstanceConfigurationDialog.this.idTextField.getText() == null || InstanceConfigurationDialog.this.idTextField.getText().isEmpty()) {
                    InstanceConfigurationDialog.this.xbayaGUI.getErrorWindow().error("Please input AMI ID or Instance ID");
                    return;
                }
                if (InstanceConfigurationDialog.this.usernameTextField.getText() == null || InstanceConfigurationDialog.this.usernameTextField.getText().isEmpty()) {
                    InstanceConfigurationDialog.this.xbayaGUI.getErrorWindow().error("Please input username to access instance");
                    return;
                }
                InstanceConfigurationDialog.this.node.setStartNewInstance(InstanceConfigurationDialog.this.amiButton.isSelected());
                if (InstanceConfigurationDialog.this.amiButton.isSelected()) {
                    InstanceConfigurationDialog.this.node.setAmiId(InstanceConfigurationDialog.this.idTextField.getText());
                    InstanceConfigurationDialog.this.node.setInstanceType(InstanceConfigurationDialog.this.instanceTypeComboBox.getText());
                } else {
                    InstanceConfigurationDialog.this.node.setInstanceId(InstanceConfigurationDialog.this.idTextField.getText());
                    InstanceConfigurationDialog.this.node.setInstanceType(null);
                }
                InstanceConfigurationDialog.this.node.setUsername(InstanceConfigurationDialog.this.usernameTextField.getText());
                InstanceConfigurationDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceConfigurationDialog.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.xbayaGUI, "Instance Configuration", (XBayaComponent)gridPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

