/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.xml.namespace.QName;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.schemas.gfac.DataType;
import org.apache.airavata.schemas.gfac.InputParameterType;
import org.apache.airavata.schemas.gfac.OutputParameterType;
import org.apache.airavata.schemas.gfac.ParameterType;
import org.apache.airavata.schemas.gfac.ServiceDescriptionType;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DescriptorListDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.xmlbeans.XmlCursor;

public class ServiceDescriptionDialog
extends JDialog {
    private static final long serialVersionUID = 2705760838264284423L;
    private final GridPanel contentPanel = new GridPanel();
    private XBayaLabel lblServiceName;
    private XBayaTextField txtServiceName;
    private JTable tblParameters;
    private boolean serviceCreated = false;
    private JLabel lblError;
    private ServiceDescription serviceDescription;
    private ServiceDescription orginalServiceDescription;
    private JButton okButton;
    private JButton btnDeleteParameter;
    private DefaultTableModel defaultTableModel;
    private AiravataAPI registry;
    private boolean newDescription;
    private boolean ignoreTableChanges = false;
    private JCheckBox chkForceFileStagingToWorkDir;
    private boolean serviceDescriptionMode;
    private String suggestedNamePrefix;
    private String titlePrefix;

    public static void main(String[] args) {
        try {
            ServiceDescriptionDialog dialog = new ServiceDescriptionDialog(null, true, null);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ServiceDescriptionDialog(AiravataAPI registry) {
        this(registry, true, null);
    }

    public ServiceDescriptionDialog(AiravataAPI registry, boolean newDescription, ServiceDescription serviceDescription) {
        this(registry, newDescription, serviceDescription, true, null);
    }

    public ServiceDescriptionDialog(AiravataAPI registry, boolean newDescription, ServiceDescription serviceDescription, boolean serviceDescriptionMode, String suggestedNamePrefix) {
        this.setNewDescription(newDescription);
        this.setOrginalServiceDescription(serviceDescription);
        this.setServiceDescriptionMode(serviceDescriptionMode);
        this.setSuggestedNamePrefix(suggestedNamePrefix);
        if (this.isNewDescription()) {
            this.setTitlePrefix(this.isServiceDescriptionMode() ? "New Service Description" : "Input/Output parameters for " + this.getSuggestedNamePrefix());
        } else {
            this.setTitlePrefix(this.isServiceDescriptionMode() ? "Update Service Description: " + this.getOrginalServiceDescription().getType().getName() : "Update Input/Output parameters for " + this.getSuggestedNamePrefix());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                if (ServiceDescriptionDialog.this.isNewDescription() && !ServiceDescriptionDialog.this.isServiceDescriptionMode()) {
                    String defaultName;
                    int i;
                    String baseName;
                    String string = baseName = ServiceDescriptionDialog.this.isServiceDescriptionMode() ? "Service" : ServiceDescriptionDialog.this.getSuggestedNamePrefix() + "_Service";
                    if (ServiceDescriptionDialog.this.isServiceDescriptionMode()) {
                        i = 1;
                        defaultName = baseName + i;
                    } else {
                        i = 0;
                        defaultName = baseName;
                    }
                    try {
                        while (ServiceDescriptionDialog.this.getRegistry().getApplicationManager().isServiceDescriptorExists(defaultName)) {
                            defaultName = baseName + ++i;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ServiceDescriptionDialog.this.txtServiceName.setText(defaultName);
                    ServiceDescriptionDialog.this.setServiceName(ServiceDescriptionDialog.this.txtServiceName.getText());
                }
            }
        });
        this.setRegistry(registry);
        this.initGUI();
    }

    public void open() {
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected ServiceDescriptionDialog getDialog() {
        return this;
    }

    private void initGUI() {
        this.setTitle(this.getTitlePrefix());
        this.setBounds(100, 100, 463, 459);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        borderLayout.setHgap(5);
        this.getContentPane().setLayout(borderLayout);
        this.txtServiceName = new XBayaTextField();
        this.txtServiceName.getSwingComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServiceDescriptionDialog.this.setServiceName(ServiceDescriptionDialog.this.txtServiceName.getText());
            }
        });
        this.txtServiceName.setColumns(10);
        this.lblServiceName = new XBayaLabel(this.isServiceDescriptionMode() ? "Service name" : "Bind parameters to service", this.txtServiceName);
        if (!this.isServiceDescriptionMode()) {
            this.lblServiceName.getSwingComponent().setFont(new Font("Tahoma", 2, 11));
        }
        JLabel lblInputParameters = new JLabel(this.isServiceDescriptionMode() ? "Service Parameters" : "Input/Output Parameters");
        lblInputParameters.setFont(new Font("Tahoma", 1, 11));
        JScrollPane scrollPane = new JScrollPane();
        this.btnDeleteParameter = new JButton("Delete parameter");
        this.btnDeleteParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServiceDescriptionDialog.this.deleteSelectedRows();
            }
        });
        this.btnDeleteParameter.setEnabled(false);
        this.tblParameters = new JTable();
        this.tblParameters.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblParameters.setFillsViewportHeight(true);
        this.defaultTableModel = new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"I/O", "Parameter Name", "Type", "Description"});
        this.tblParameters.setModel(this.defaultTableModel);
        this.defaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (!ServiceDescriptionDialog.this.ignoreTableChanges) {
                    int selectedRow = ServiceDescriptionDialog.this.tblParameters.getSelectedRow();
                    if (selectedRow != -1 && ServiceDescriptionDialog.this.defaultTableModel.getRowCount() > 0) {
                        Object parameterIOType = ServiceDescriptionDialog.this.defaultTableModel.getValueAt(selectedRow, 0);
                        Object parameterDataType = ServiceDescriptionDialog.this.defaultTableModel.getValueAt(selectedRow, 2);
                        if (parameterIOType == null || parameterIOType.equals("")) {
                            ServiceDescriptionDialog.this.defaultTableModel.setValueAt(ServiceDescriptionDialog.this.getIOStringList()[0], selectedRow, 0);
                        }
                        if (parameterDataType == null || parameterDataType.equals("")) {
                            ServiceDescriptionDialog.this.defaultTableModel.setValueAt(ServiceDescriptionDialog.this.getDataTypes()[0], selectedRow, 2);
                        }
                    }
                    ServiceDescriptionDialog.this.addNewRowIfLastIsNotEmpty();
                }
            }
        });
        TableColumn ioColumn = this.tblParameters.getColumnModel().getColumn(0);
        Object[] ioStringList = this.getIOStringList();
        ioColumn.setCellEditor(new StringArrayComboBoxEditor(ioStringList));
        TableColumn datatypeColumn = this.tblParameters.getColumnModel().getColumn(2);
        Object[] dataTypeStringList = this.getDataTypes();
        datatypeColumn.setCellEditor(new StringArrayComboBoxEditor(dataTypeStringList));
        TableColumn parameterNameCol = this.tblParameters.getColumnModel().getColumn(1);
        parameterNameCol.setPreferredWidth(190);
        scrollPane.setViewportView(this.tblParameters);
        ListSelectionModel selectionModel = this.tblParameters.getSelectionModel();
        selectionModel.setSelectionMode(2);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServiceDescriptionDialog.this.btnDeleteParameter.setEnabled(ServiceDescriptionDialog.this.tblParameters.getSelectedRows().length > 0);
            }
        });
        JLabel lblTableParameterNote = null;
        if (!this.isServiceDescriptionMode()) {
            final JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Bind to parameters in existing service...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ServiceDescriptionDialog.this.bindExistingServiceDescriptionAsParameters();
                }
            });
            popup.add(menuItem);
            this.tblParameters.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.show(ServiceDescriptionDialog.this.tblParameters, e.getX(), e.getY());
                    }
                }
            });
            lblTableParameterNote = new JLabel("*Note: Right click on the table to bind an existing service");
            lblTableParameterNote.setFont(new Font("Tahoma", 2, 11));
        }
        this.chkForceFileStagingToWorkDir = new JCheckBox("Advanced: Force input file staging to working directory");
        this.chkForceFileStagingToWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServiceDescriptionDialog.this.setForceFileStagingToWorkDir(ServiceDescriptionDialog.this.chkForceFileStagingToWorkDir.isSelected());
            }
        });
        GridPanel buttonPane = new GridPanel();
        GridBagLayout gbl_buttonPane = new GridBagLayout();
        gbl_buttonPane.columnWidths = new int[]{307, 136, 0};
        gbl_buttonPane.rowHeights = new int[]{33, 0};
        gbl_buttonPane.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_buttonPane.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.lblError = new JLabel("");
        this.lblError.setForeground(Color.RED);
        GridBagConstraints gbc_lblError = new GridBagConstraints();
        gbc_lblError.insets = new Insets(0, 0, 0, 5);
        gbc_lblError.gridx = 0;
        gbc_lblError.gridy = 0;
        buttonPane.add(this.lblError);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.anchor = 18;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 0;
        buttonPane.add(panel);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDescriptionDialog.this.loadData();
            }
        });
        panel.add(resetButton);
        this.okButton = new JButton("Save");
        if (!this.isNewDescription()) {
            this.okButton.setText("Update");
        }
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDescriptionDialog.this.saveServiceDescription();
                ServiceDescriptionDialog.this.close();
            }
        });
        panel.add(this.okButton);
        this.okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDescriptionDialog.this.setServiceCreated(false);
                ServiceDescriptionDialog.this.close();
            }
        });
        panel.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        this.contentPanel.add(this.lblServiceName);
        this.contentPanel.add(this.txtServiceName);
        GridPanel parameterPanel = new GridPanel();
        if (this.isServiceDescriptionMode()) {
            parameterPanel.add(lblInputParameters);
        }
        if (lblTableParameterNote != null) {
            parameterPanel.add(lblTableParameterNote);
        }
        parameterPanel.add(scrollPane);
        parameterPanel.add(this.btnDeleteParameter);
        SwingUtil.layoutToGrid((Container)this.contentPanel.getSwingComponent(), (int)1, (int)2, (int)-1, (int)1);
        SwingUtil.layoutToGrid((Container)parameterPanel.getSwingComponent(), (int)3, (int)1, (int)1, (int)0);
        GridPanel infoPanel = new GridPanel();
        if (this.isServiceDescriptionMode()) {
            infoPanel.add(this.contentPanel);
        }
        infoPanel.add(parameterPanel);
        infoPanel.add(this.chkForceFileStagingToWorkDir);
        if (!this.isServiceDescriptionMode()) {
            infoPanel.add(this.contentPanel);
        }
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        if (this.isServiceDescriptionMode()) {
            infoPanel.layout(3, 1, 1, 0);
        } else {
            infoPanel.layout(3, 1, 0, 0);
        }
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!this.isNewDescription()) {
            this.loadData();
        }
    }

    private void loadData() {
        OutputParameterType[] oparameters;
        InputParameterType[] iparameters;
        ServiceDescriptionType descType = this.getOrginalServiceDescription().getType();
        this.txtServiceName.setText(descType.getName());
        this.setServiceName(this.txtServiceName.getText());
        this.txtServiceName.setEditable(!this.isServiceDescriptionMode() || this.isNewDescription());
        this.ignoreTableChanges = true;
        while (this.defaultTableModel.getRowCount() > 0) {
            this.defaultTableModel.removeRow(0);
        }
        for (InputParameterType parameter : iparameters = descType.getInputParametersArray()) {
            this.defaultTableModel.addRow(new Object[]{this.getIOStringList()[0], parameter.getParameterName(), parameter.getParameterType().getName(), parameter.getParameterDescription()});
        }
        for (OutputParameterType parameter : oparameters = descType.getOutputParametersArray()) {
            this.defaultTableModel.addRow(new Object[]{this.getIOStringList()[1], parameter.getParameterName(), parameter.getParameterType().getName(), parameter.getParameterDescription()});
        }
        this.addNewRowIfLastIsNotEmpty();
        Boolean selected = false;
        if (descType.getPortType() != null && descType.getPortType().getMethod() != null) {
            XmlCursor cursor = descType.getPortType().getMethod().newCursor();
            String value = cursor.getAttributeText(new QName("forceFileStagingToWorkDir"));
            cursor.dispose();
            selected = false;
            if (value != null) {
                selected = Boolean.parseBoolean(value);
            }
        }
        this.chkForceFileStagingToWorkDir.setSelected(selected);
        this.setForceFileStagingToWorkDir(selected);
        this.ignoreTableChanges = false;
    }

    private String[] getIOStringList() {
        String[] ioStringList = new String[]{"Input", "Output"};
        return ioStringList;
    }

    private String[] getDataTypes() {
        String[] type = new String[DataType.Enum.table.lastInt()];
        for (int i = 1; i <= DataType.Enum.table.lastInt(); ++i) {
            type[i - 1] = DataType.Enum.forInt((int)i).toString();
        }
        return type;
    }

    public boolean isServiceCreated() {
        return this.serviceCreated;
    }

    public void setServiceCreated(boolean serviceCreated) {
        this.serviceCreated = serviceCreated;
    }

    public ServiceDescription getServiceDescription() {
        if (this.serviceDescription == null) {
            this.serviceDescription = new ServiceDescription();
        }
        return this.serviceDescription;
    }

    public ServiceDescriptionType getServiceDescriptionType() {
        return this.getServiceDescription().getType();
    }

    public String getServiceName() {
        return this.getServiceDescription().getType().getName();
    }

    public void setServiceName(String serviceName) {
        this.getServiceDescription().getType().setName(serviceName);
        this.updateDialogStatus();
    }

    private void setupMethod() {
        if (this.getServiceDescriptionType().getPortType() == null) {
            this.getServiceDescriptionType().setPortType(this.getServiceDescriptionType().addNewPortType());
        }
        if (this.getServiceDescriptionType().getPortType().getMethod() == null) {
            this.getServiceDescriptionType().getPortType().setMethod(this.getServiceDescriptionType().getPortType().addNewMethod());
        }
    }

    public void setForceFileStagingToWorkDir(Boolean force) {
        this.setupMethod();
        XmlCursor cursor = this.getServiceDescriptionType().getPortType().getMethod().newCursor();
        cursor.toNextToken();
        if (!cursor.setAttributeText(new QName("http://airavata.apache.org/schemas/gfac/2012/12", "forceFileStagingToWorkDir"), force.toString())) {
            cursor.insertAttributeWithValue("forceFileStagingToWorkDir", force.toString());
        }
        cursor.dispose();
    }

    public Boolean getForceFileStagingToWorkDir() {
        this.setupMethod();
        XmlCursor cursor = this.getServiceDescriptionType().getPortType().getMethod().newCursor();
        cursor.toNextToken();
        String value = cursor.getAttributeText(new QName("forceFileStagingToWorkDir"));
        cursor.dispose();
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private void updateDialogStatus() {
        String message = null;
        try {
            this.validateDialog();
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        this.okButton.setEnabled(message == null);
        this.setError(message);
    }

    private void validateDialog() throws Exception {
        ServiceDescription serviceDescription2;
        block4: {
            if (this.getServiceName() == null || this.getServiceName().trim().equals("")) {
                throw new Exception("Name of the service cannot be empty!!!");
            }
            serviceDescription2 = null;
            try {
                serviceDescription2 = this.getRegistry().getApplicationManager().getServiceDescription(this.getServiceName());
            }
            catch (AiravataAPIInvocationException e) {
                if (e.getCause() instanceof PathNotFoundException) break block4;
                throw e;
            }
        }
        if (this.isNewDescription() && serviceDescription2 != null) {
            throw new Exception("Service descriptor with the given name already exists!!!");
        }
    }

    public void saveServiceDescription() {
        ArrayList<InputParameterType> inputParameters = new ArrayList<InputParameterType>();
        ArrayList<InputParameterType> outputParameters = new ArrayList<InputParameterType>();
        for (int i = 0; i < this.defaultTableModel.getRowCount(); ++i) {
            ParameterType parameterType;
            InputParameterType parameter;
            String parameterName = (String)this.defaultTableModel.getValueAt(i, 1);
            String paramType = (String)this.defaultTableModel.getValueAt(i, 2);
            String parameterDescription = (String)this.defaultTableModel.getValueAt(i, 3);
            if (parameterName == null || parameterName.trim().equals("")) continue;
            if (this.getIOStringList()[0].equals(this.defaultTableModel.getValueAt(i, 0))) {
                parameter = InputParameterType.Factory.newInstance();
                parameter.setParameterName(parameterName);
                parameter.setParameterDescription(parameterDescription);
                parameterType = parameter.addNewParameterType();
                parameterType.setType(DataType.Enum.forString((String)paramType));
                parameterType.setName(paramType);
                inputParameters.add(parameter);
                continue;
            }
            parameter = OutputParameterType.Factory.newInstance();
            parameter.setParameterName(parameterName);
            parameter.setParameterDescription(parameterDescription);
            parameterType = parameter.addNewParameterType();
            parameterType.setType(DataType.Enum.forString((String)paramType));
            parameterType.setName(paramType);
            outputParameters.add(parameter);
        }
        this.getServiceDescriptionType().setInputParametersArray(inputParameters.toArray(new InputParameterType[0]));
        this.getServiceDescriptionType().setOutputParametersArray(outputParameters.toArray(new OutputParameterType[0]));
        try {
            if (this.getRegistry().getApplicationManager().isServiceDescriptorExists(this.getServiceDescription().getType().getName())) {
                this.getRegistry().getApplicationManager().updateServiceDescriptor(this.getServiceDescription());
            } else {
                this.getRegistry().getApplicationManager().saveServiceDescription(this.getServiceDescription());
            }
            this.setServiceCreated(true);
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
            this.setError(e.getMessage());
        }
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    private void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().equals("")) {
            this.lblError.setText("");
        } else {
            this.lblError.setText(errorMessage.trim());
        }
    }

    private void deleteSelectedRows() {
        int selectedRow = this.tblParameters.getSelectedRow();
        while (selectedRow >= 0 && this.tblParameters.getRowCount() > 0) {
            this.defaultTableModel.removeRow(selectedRow);
            selectedRow = this.tblParameters.getSelectedRow();
        }
        this.addNewRowIfLastIsNotEmpty();
    }

    private void addNewRowIfLastIsNotEmpty() {
        if (this.defaultTableModel.getRowCount() > 0) {
            Object parameterName = this.defaultTableModel.getValueAt(this.defaultTableModel.getRowCount() - 1, 1);
            if (parameterName != null && !parameterName.equals("")) {
                this.defaultTableModel.addRow(new Object[]{null, null, null, null});
            }
        } else if (this.tblParameters.getSelectedRow() == -1) {
            this.defaultTableModel.addRow(new Object[]{null, null, null, null});
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public boolean isNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(boolean newDescription) {
        this.newDescription = newDescription;
    }

    public ServiceDescription getOrginalServiceDescription() {
        return this.orginalServiceDescription;
    }

    public void setOrginalServiceDescription(ServiceDescription orginalServiceDescription) {
        this.orginalServiceDescription = orginalServiceDescription;
    }

    public boolean isServiceDescriptionMode() {
        return this.serviceDescriptionMode;
    }

    public void setServiceDescriptionMode(boolean serviceDescriptionMode) {
        this.serviceDescriptionMode = serviceDescriptionMode;
    }

    public String getSuggestedNamePrefix() {
        return this.suggestedNamePrefix;
    }

    public void setSuggestedNamePrefix(String suggestedNamePrefix) {
        this.suggestedNamePrefix = suggestedNamePrefix;
    }

    public String getTitlePrefix() {
        return this.titlePrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.titlePrefix = titlePrefix;
    }

    private void bindExistingServiceDescriptionAsParameters() {
        DescriptorListDialog descriptorListDialog = new DescriptorListDialog(this.getRegistry(), DescriptorListDialog.DescriptorType.SERVICE);
        descriptorListDialog.open();
        if (descriptorListDialog.isServiceSelected()) {
            this.setOrginalServiceDescription((ServiceDescription)descriptorListDialog.getSelected());
            this.setNewDescription(false);
            this.loadData();
        }
    }

    private class StringArrayComboBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -304464739219209395L;

        public StringArrayComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }
    }
}

