/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.client.api.exception.DescriptorAlreadyExistsException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.schemas.gfac.Ec2HostType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.gfac.SSHHostType;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class HostDescriptionDialog
extends JDialog {
    private static final long serialVersionUID = -2910634296292034085L;
    private XBayaTextField hostIdTextField;
    private XBayaTextField hostAddressTextField;
    private XBayaTextField gateKeeperTextField;
    private XBayaTextField gridFTPTextField;
    private HostDescription hostDescription;
    private boolean hostCreated = false;
    private AiravataAPI registry;
    private XBayaLabel gateKeeperLabel;
    private XBayaLabel gridFTPLabel;
    private JLabel lblError;
    private String hostId;
    private JButton okButton;
    private boolean newHost;
    private HostDescription originalHostDescription;
    private JComboBox cmbResourceProtocol;
    private GridPanel infoPanel2;
    private static final String REMOTE_PROTOCOL_STR_LOCAL = "Local";
    private static final String REMOTE_PROTOCOL_STR_SSH = "SSH";
    private static final String REMOTE_PROTOCOL_STR_GLOBUS = "Globus";
    private static final String REMOTE_PROTOCOL_STR_UNICORE = "Unicore";
    private static final String REMOTE_PROTOCOL_STR_AMAZON_EC2 = "Amazon EC2";
    private static final String REMOTE_PROTOCOL_STR_HADOOP = "Hadoop";
    String previousProtocol = null;

    public HostDescriptionDialog(AiravataAPI registry, JFrame parent) {
        this(registry, true, null, parent);
    }

    public HostDescriptionDialog(AiravataAPI registry, boolean newHost, HostDescription originalHostDescription, JFrame parent) {
        super(parent);
        this.setNewHost(newHost);
        this.setOriginalHostDescription(originalHostDescription);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        this.setRegistry(registry);
        this.initGUI();
    }

    public void open() {
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }

    private void ok() {
        this.hostId = this.hostIdTextField.getText();
        String hostAddress = this.hostAddressTextField.getText();
        this.setHostId(this.hostId);
        this.setHostLocation(hostAddress);
        HostDescriptionType host = this.getHostDescription().getType();
        if (host instanceof GlobusHostType) {
            ((GlobusHostType)this.hostDescription.getType()).addGlobusGateKeeperEndPoint(this.gateKeeperTextField.getText());
            ((GlobusHostType)this.hostDescription.getType()).addGridFTPEndPoint(this.gridFTPTextField.getText());
        } else if (host instanceof UnicoreHostType) {
            ((UnicoreHostType)this.hostDescription.getType()).addUnicoreBESEndPoint(this.gateKeeperTextField.getText());
            ((UnicoreHostType)this.hostDescription.getType()).addGridFTPEndPoint(this.gridFTPTextField.getText());
        }
        this.saveHostDescription();
        this.close();
    }

    private GridPanel createPanelWithMessage(String message) {
        GridPanel gridPanel = new GridPanel();
        JLabel lblMessage = new JLabel(message, 0);
        gridPanel.add(lblMessage);
        lblMessage.setFont(new Font("Tahoma", 2, 11));
        gridPanel.layout(1, 1, 0, 0);
        return gridPanel;
    }

    private void initGUI() {
        this.setBounds(100, 100, 400, 350);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        if (this.isNewHost()) {
            this.setTitle("Register Host");
        } else {
            this.setTitle("Update Host: " + this.getOriginalHostDescription().getType().getHostName());
        }
        this.hostIdTextField = new XBayaTextField();
        this.hostAddressTextField = new XBayaTextField();
        XBayaLabel hostIdLabel = new XBayaLabel("Host ID", this.hostIdTextField);
        XBayaLabel hostAddressLabel = new XBayaLabel("Host Address", this.hostAddressTextField);
        this.cmbResourceProtocol = new JComboBox<String>(new String[]{REMOTE_PROTOCOL_STR_LOCAL, REMOTE_PROTOCOL_STR_SSH, REMOTE_PROTOCOL_STR_GLOBUS, REMOTE_PROTOCOL_STR_UNICORE, REMOTE_PROTOCOL_STR_AMAZON_EC2, REMOTE_PROTOCOL_STR_HADOOP});
        JLabel lblResourceProtocol = new JLabel("Resource Protocol");
        GridPanel pnlResourceProtocolSelection = new GridPanel();
        pnlResourceProtocolSelection.add(lblResourceProtocol);
        pnlResourceProtocolSelection.add(this.cmbResourceProtocol);
        pnlResourceProtocolSelection.layout(1, 2, 0, 1);
        this.cmbResourceProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HostDescriptionDialog.this.updateRemoteProtocolTypeAndControls();
            }
        });
        this.hostIdTextField.getSwingComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HostDescriptionDialog.this.updateDialogStatus();
            }
        });
        this.hostAddressTextField.getSwingComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HostDescriptionDialog.this.updateDialogStatus();
            }
        });
        GridPanel infoPanel1 = new GridPanel();
        infoPanel1.add(hostIdLabel);
        infoPanel1.add(this.hostIdTextField);
        infoPanel1.add(hostAddressLabel);
        infoPanel1.add(this.hostAddressTextField);
        this.infoPanel2 = new GridPanel();
        this.infoPanel2.add(this.createPanelWithMessage("Initializing..."));
        SwingUtil.layoutToGrid((Container)infoPanel1.getSwingComponent(), (int)2, (int)2, (int)-1, (int)1);
        SwingUtil.layoutToGrid((Container)this.infoPanel2.getSwingComponent(), (int)1, (int)1, (int)-1, (int)1);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(infoPanel1);
        infoPanel.add(pnlResourceProtocolSelection);
        infoPanel.add(this.infoPanel2);
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)infoPanel.getSwingComponent(), (int)3, (int)1, (int)-1, (int)0);
        GridPanel buttonPanel = new GridPanel();
        this.lblError = new JLabel();
        this.lblError.setForeground(Color.RED);
        buttonPanel.add(this.lblError);
        this.okButton = new JButton("Save");
        if (!this.isNewHost()) {
            this.okButton.setText("Update");
        }
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDescriptionDialog.this.ok();
            }
        });
        buttonPanel.add(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDescriptionDialog.this.close();
            }
        });
        buttonPanel.add(cancelButton);
        buttonPanel.layout(1, 3, -1, 0);
        buttonPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPanel.getSwingComponent());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cmbResourceProtocol.setSelectedIndex(0);
        this.updateRemoteProtocolTypeAndControls();
        if (!this.isNewHost()) {
            this.loadData();
        }
        this.updateDialogStatus();
    }

    private GridPanel createGlobusRemoteProtocolPanel() {
        GridPanel globusPanel = new GridPanel();
        if (this.gridFTPTextField == null) {
            this.gridFTPTextField = new XBayaTextField();
            this.gateKeeperTextField = new XBayaTextField();
            this.gateKeeperLabel = new XBayaLabel("GRAM Endpoint", this.gateKeeperTextField);
            this.gridFTPLabel = new XBayaLabel("Grid FTP Endpoint", this.gridFTPTextField);
        }
        globusPanel.add(this.gateKeeperLabel);
        globusPanel.add(this.gateKeeperTextField);
        globusPanel.add(this.gridFTPLabel);
        globusPanel.add(this.gridFTPTextField);
        SwingUtil.layoutToGrid((Container)globusPanel.getSwingComponent(), (int)2, (int)2, (int)-1, (int)1);
        return globusPanel;
    }

    private GridPanel createUnicoreRemoteProtocolPanel() {
        GridPanel globusPanel = new GridPanel();
        if (this.gridFTPTextField == null) {
            this.gridFTPTextField = new XBayaTextField();
            this.gateKeeperTextField = new XBayaTextField();
            this.gateKeeperLabel = new XBayaLabel("Unicore Endpoint", this.gateKeeperTextField);
            this.gridFTPLabel = new XBayaLabel("GridFTP Endpoint", this.gridFTPTextField);
        }
        globusPanel.add(this.gateKeeperLabel);
        globusPanel.add(this.gateKeeperTextField);
        globusPanel.add(this.gridFTPLabel);
        globusPanel.add(this.gridFTPTextField);
        SwingUtil.layoutToGrid((Container)globusPanel.getSwingComponent(), (int)2, (int)2, (int)-1, (int)1);
        return globusPanel;
    }

    private String arrayToString(String[] list) {
        String result = "";
        for (String s : list) {
            result = result.equals("") ? s : result + "," + s;
        }
        return result;
    }

    private void loadData() {
        HostDescriptionType t = this.getOriginalHostDescription().getType();
        this.hostIdTextField.setText(t.getHostName());
        this.hostAddressTextField.setText(t.getHostAddress());
        if (t instanceof GlobusHostType) {
            this.cmbResourceProtocol.setSelectedItem(REMOTE_PROTOCOL_STR_GLOBUS);
            this.gateKeeperTextField.setText(this.arrayToString(((GlobusHostType)t).getGlobusGateKeeperEndPointArray()));
            this.gridFTPTextField.setText(this.arrayToString(((GlobusHostType)t).getGridFTPEndPointArray()));
        } else if (t instanceof SSHHostType) {
            this.cmbResourceProtocol.setSelectedItem(REMOTE_PROTOCOL_STR_SSH);
        } else if (t instanceof UnicoreHostType) {
            this.cmbResourceProtocol.setSelectedItem(REMOTE_PROTOCOL_STR_UNICORE);
            this.gateKeeperTextField.setText(this.arrayToString(((UnicoreHostType)t).getUnicoreBESEndPointArray()));
            this.gridFTPTextField.setText(this.arrayToString(((UnicoreHostType)t).getGridFTPEndPointArray()));
        } else if (t instanceof Ec2HostType) {
            this.cmbResourceProtocol.setSelectedItem(REMOTE_PROTOCOL_STR_AMAZON_EC2);
        }
        this.hostIdTextField.setEditable(this.isNewHost());
        this.updateRemoteProtocolTypeAndControls();
    }

    public String getHostId() {
        return this.getHostDescription().getType().getHostName();
    }

    public void setHostId(String hostId) {
        this.getHostDescription().getType().setHostName(hostId);
        this.updateDialogStatus();
    }

    public String getHostLocation() {
        return this.getHostDescription().getType().getHostName();
    }

    public void setHostLocation(String hostLocation) {
        this.getHostDescription().getType().setHostAddress(hostLocation);
        this.updateDialogStatus();
    }

    private void validateDialog() throws Exception {
        String hostAddress;
        if (this.isNewHost()) {
            String hostName = this.hostIdTextField.getText();
            if (hostName == null || hostName.trim().equals("")) {
                throw new Exception("Id of the host cannot be empty!!!");
            }
            HostDescription hostDescription2 = null;
            hostDescription2 = this.getRegistry().getApplicationManager().getHostDescription(hostName);
            if (hostDescription2 != null) {
                throw new Exception("Host descriptor with the given id already exists!!!");
            }
        }
        if ((hostAddress = this.hostAddressTextField.getText()) == null || hostAddress.trim().equals("")) {
            throw new Exception("Host location/ip cannot be empty!!!");
        }
    }

    private void updateDialogStatus() {
        String message = null;
        try {
            this.validateDialog();
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        this.okButton.setEnabled(message == null);
        this.setError(message);
    }

    private void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().equals("")) {
            this.lblError.setText("");
        } else {
            this.lblError.setText(errorMessage.trim());
        }
    }

    public boolean isHostCreated() {
        return this.hostCreated;
    }

    public void setHostCreated(boolean hostCreated) {
        this.hostCreated = hostCreated;
    }

    public HostDescription getHostDescription() {
        if (this.hostDescription == null) {
            this.hostDescription = new HostDescription(GlobusHostType.type);
        }
        return this.hostDescription;
    }

    public void saveHostDescription() {
        HostDescription desc = this.getHostDescription();
        try {
            if (this.getRegistry().getApplicationManager().isHostDescriptorExists(desc.getType().getHostName())) {
                this.getRegistry().getApplicationManager().updateHostDescriptor(desc);
            } else {
                this.getRegistry().getApplicationManager().addHostDescription(desc);
            }
            this.setHostCreated(true);
        }
        catch (DescriptorAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    private void updateRemoteProtocolTypeAndControls() {
        String selectedProtocol = this.cmbResourceProtocol.getSelectedItem().toString();
        if (this.previousProtocol == null || !this.previousProtocol.equals(selectedProtocol)) {
            this.infoPanel2.getContentPanel().removeAll();
            if (selectedProtocol.equals(REMOTE_PROTOCOL_STR_LOCAL)) {
                this.getHostDescription().getType().changeType(HostDescriptionType.type);
                this.infoPanel2.add(this.createPanelWithMessage("No configurations needed."));
            } else if (selectedProtocol.equals(REMOTE_PROTOCOL_STR_SSH)) {
                this.getHostDescription().getType().changeType(SSHHostType.type);
                this.infoPanel2.add(this.createPanelWithMessage("No configurations needed."));
            } else if (selectedProtocol.equals(REMOTE_PROTOCOL_STR_GLOBUS)) {
                this.getHostDescription().getType().changeType(GlobusHostType.type);
                this.infoPanel2.add(this.createGlobusRemoteProtocolPanel());
            } else if (selectedProtocol.equals(REMOTE_PROTOCOL_STR_UNICORE)) {
                this.getHostDescription().getType().changeType(UnicoreHostType.type);
                this.infoPanel2.add(this.createUnicoreRemoteProtocolPanel());
            } else if (selectedProtocol.equals(REMOTE_PROTOCOL_STR_AMAZON_EC2)) {
                this.getHostDescription().getType().changeType(Ec2HostType.type);
                this.infoPanel2.add(this.createPanelWithMessage("No configurations needed."));
            } else {
                this.infoPanel2.add(this.createPanelWithMessage("Not supported."));
            }
            this.infoPanel2.getContentPanel().setBorder(BorderFactory.createEtchedBorder());
            this.infoPanel2.getContentPanel().updateUI();
            this.infoPanel2.layout(1, 1, 0, 0);
        }
    }

    public boolean isNewHost() {
        return this.newHost;
    }

    public void setNewHost(boolean newHost) {
        this.newHost = newHost;
    }

    public HostDescription getOriginalHostDescription() {
        return this.originalHostDescription;
    }

    public void setOriginalHostDescription(HostDescription originalHostDescription) {
        this.originalHostDescription = originalHostDescription;
    }
}

