/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionAdvancedOptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionHostAdvancedOptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;
import org.apache.airavata.xbaya.ui.menues.MenuIcons;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLinkButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.xmlbeans.XmlException;

public class HostDeploymentDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2745085755585610025L;
    private XBayaTextField txtExecPath;
    private XBayaTextField txtTempDir;
    private AiravataAPI registry;
    private ApplicationDescription shellApplicationDescription;
    private JLabel lblError;
    private boolean applcationDescCreated = false;
    private JButton okButton;
    private String hostName;
    private JComboBox cmbHostName;
    private JButton btnHostAdvanceOptions;
    private boolean newDescriptor;
    private ApplicationDescription originalDescription;
    private String originalHost;
    private JButton btnTmpDirBrowse;
    private JButton btnExecBrowse;
    private List<String> existingHostList;

    public HostDeploymentDialog(AiravataAPI registry, boolean newDescriptor, ApplicationDescription originalDescription, String originalHost, List<String> existingHostList) {
        this.setNewDescriptor(newDescriptor);
        this.setOriginalDescription(originalDescription);
        this.setOriginalHost(originalHost);
        this.setRegistry(registry);
        this.setExistingHostList(existingHostList);
        this.iniGUI();
    }

    public void open() {
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected HostDeploymentDialog getDialog() {
        return this;
    }

    private void iniGUI() {
        if (this.isNewDescriptor()) {
            this.setTitle("New Application Deployment");
        } else {
            this.setTitle("Update Application Deployment: " + this.getOriginalDescription().getType().getApplicationName().getStringValue());
        }
        this.setBounds(100, 100, 600, 620);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        GridPanel buttonPane = new GridPanel();
        this.lblError = new JLabel("");
        this.lblError.setForeground(Color.RED);
        buttonPane.add(this.lblError);
        if (!this.isNewDescriptor()) {
            JButton resetButton = new JButton("Reset");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostDeploymentDialog.this.loadData();
                }
            });
            buttonPane.add(resetButton);
        }
        this.okButton = new JButton("Add");
        if (!this.isNewDescriptor()) {
            this.okButton.setText("Update");
        }
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDeploymentDialog.this.saveApplicationDescription();
                HostDeploymentDialog.this.close();
            }
        });
        this.okButton.setEnabled(false);
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDeploymentDialog.this.setApplicationDescCreated(false);
                HostDeploymentDialog.this.close();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JPanel execPath = new JPanel();
        this.txtExecPath = new XBayaTextField();
        this.txtExecPath.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HostDeploymentDialog.this.setExecutablePath(HostDeploymentDialog.this.txtExecPath.getText());
            }
        });
        this.txtExecPath.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                HostDeploymentDialog.this.updateTempDirWithExecPath(HostDeploymentDialog.this.txtExecPath.getText());
            }
        });
        this.txtExecPath.setColumns(10);
        this.btnExecBrowse = new JButton(MenuIcons.OPEN_ICON);
        this.btnExecBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser c = new JFileChooser();
                int rVal = c.showOpenDialog(null);
                if (rVal == 0) {
                    HostDeploymentDialog.this.txtExecPath.setText(c.getSelectedFile().toString());
                    HostDeploymentDialog.this.setExecutablePath(HostDeploymentDialog.this.txtExecPath.getText());
                }
            }
        });
        execPath.add(this.txtExecPath.getSwingComponent());
        execPath.add(this.btnExecBrowse);
        this.setupLayoutForBrowse(execPath, this.txtExecPath.getSwingComponent());
        JLabel lblExecutablePath = new JLabel("Executable path");
        JPanel tmpDirPath = new JPanel();
        this.txtTempDir = new XBayaTextField();
        this.txtTempDir.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                HostDeploymentDialog.this.setTempDir(HostDeploymentDialog.this.txtTempDir.getText());
            }
        });
        this.txtTempDir.setColumns(10);
        this.btnTmpDirBrowse = new JButton(MenuIcons.OPEN_DIR_ICON);
        this.btnTmpDirBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser c = new JFileChooser();
                c.setFileSelectionMode(1);
                int rVal = c.showOpenDialog(null);
                if (rVal == 0) {
                    HostDeploymentDialog.this.txtTempDir.setText(c.getSelectedFile().toString());
                    HostDeploymentDialog.this.setTempDir(HostDeploymentDialog.this.txtTempDir.getText());
                }
            }
        });
        JTextField component = this.txtTempDir.getSwingComponent();
        tmpDirPath.add(component);
        tmpDirPath.add(this.btnTmpDirBrowse);
        this.setupLayoutForBrowse(tmpDirPath, component);
        JLabel lblTemporaryDirectory = new JLabel("Scratch working directory");
        JButton btnAdvance = new JButton("Advanced application configurations...");
        btnAdvance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ApplicationDescriptionAdvancedOptionDialog serviceDescriptionDialog = new ApplicationDescriptionAdvancedOptionDialog(HostDeploymentDialog.this.getRegistry(), HostDeploymentDialog.this.getShellApplicationDescription());
                    serviceDescriptionDialog.open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        this.cmbHostName = new JComboBox();
        this.cmbHostName.addActionListener(this);
        XBayaLabel lblHostName = new XBayaLabel("Application host", this.cmbHostName);
        XBayaLinkButton lnkNewHost = new XBayaLinkButton("New button");
        lnkNewHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(HostDeploymentDialog.this.getRegistry(), null);
                    hostDescriptionDialog.setLocationRelativeTo(HostDeploymentDialog.this.getContentPane());
                    hostDescriptionDialog.open();
                    if (hostDescriptionDialog.isHostCreated()) {
                        ProgressMonitor progressMonitor = new ProgressMonitor(HostDeploymentDialog.this.getContentPane(), "Host Descriptions", "Refreshing host list..", 0, 200);
                        int progress = 1;
                        progressMonitor.setProgress(progress++);
                        while (HostDeploymentDialog.this.cmbHostName.getSelectedIndex() == -1 || !HostDeploymentDialog.this.cmbHostName.getSelectedItem().toString().equals(hostDescriptionDialog.getHostLocation())) {
                            HostDeploymentDialog.this.loadHostDescriptions();
                            HostDeploymentDialog.this.cmbHostName.setSelectedItem(hostDescriptionDialog.getHostLocation());
                            progressMonitor.setProgress(progress++);
                            Thread.sleep(50L);
                        }
                        progressMonitor.setProgress(200);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        lnkNewHost.setText("Create new host...");
        lnkNewHost.setHorizontalAlignment(11);
        this.btnHostAdvanceOptions = new JButton("HPC Configuration...");
        this.btnHostAdvanceOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ApplicationDescriptionHostAdvancedOptionDialog hostAdvancedOptionsDialog = new ApplicationDescriptionHostAdvancedOptionDialog(HostDeploymentDialog.this.getRegistry(), HostDeploymentDialog.this.getShellApplicationDescription());
                    hostAdvancedOptionsDialog.open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        this.btnHostAdvanceOptions.setVisible(false);
        GridPanel hostPanel = new GridPanel();
        hostPanel.add(this.cmbHostName);
        hostPanel.add(new JLabel());
        SwingUtil.layoutToGrid((Container)hostPanel.getSwingComponent(), (int)1, (int)2, (int)0, (int)0);
        GridPanel infoPanel1 = new GridPanel();
        infoPanel1.add(lblExecutablePath);
        infoPanel1.add(execPath);
        infoPanel1.add(lblTemporaryDirectory);
        infoPanel1.add(tmpDirPath);
        GridPanel infoPanel3 = new GridPanel();
        infoPanel3.add(lblHostName);
        infoPanel3.add(hostPanel);
        infoPanel3.add(new JLabel());
        infoPanel3.add(lnkNewHost);
        GridPanel infoPanel4 = new GridPanel();
        infoPanel4.add(this.btnHostAdvanceOptions);
        infoPanel4.add(btnAdvance);
        infoPanel4.layout(1, 2, 0, 0);
        SwingUtil.layoutToGrid((Container)infoPanel1.getSwingComponent(), (int)4, (int)1, (int)-1, (int)0);
        SwingUtil.layoutToGrid((Container)infoPanel3.getSwingComponent(), (int)2, (int)2, (int)-1, (int)1);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel3);
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel1);
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel4);
        SwingUtil.layoutToGrid((Container)infoPanel.getSwingComponent(), (int)6, (int)1, (int)-1, (int)0);
        SwingUtil.layoutToGrid((Container)buttonPane.getSwingComponent(), (int)1, (int)buttonPane.getContentPanel().getComponentCount(), (int)-1, (int)0);
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)-1, (int)0);
        this.loadHostDescriptions();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!this.isNewDescriptor()) {
            this.loadData();
        }
        this.pack();
        if (this.getSize().getWidth() < 500.0) {
            this.setSize(500, this.getSize().height);
        }
    }

    private void setupLayoutForBrowse(JPanel tmpDirPath, JTextField component) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        layout.setConstraints(component, constraints);
        tmpDirPath.setLayout(layout);
    }

    private void loadData() {
        this.txtExecPath.setText(this.getOriginalDescription().getType().getExecutableLocation());
        this.setExecutablePath(this.txtExecPath.getText());
        this.txtTempDir.setText(this.getOriginalDescription().getType().getScratchWorkingDirectory());
        this.setTempDir(this.txtTempDir.getText());
        this.cmbHostName.setSelectedItem(this.getOriginalHost());
        this.setHostName(this.cmbHostName.getSelectedItem().toString());
        this.cmbHostName.setEnabled(this.isNewDescriptor());
    }

    private void loadHostDescriptions() {
        this.cmbHostName.removeAllItems();
        this.setHostName(null);
        try {
            List hostDescriptions = this.getRegistry().getApplicationManager().getAllHostDescriptions();
            for (HostDescription hostDescription : hostDescriptions) {
                if (this.isNewDescriptor() && this.getExistingHostList().contains(hostDescription.getType().getHostName())) continue;
                this.cmbHostName.addItem(hostDescription.getType().getHostName());
            }
        }
        catch (Exception e) {
            this.setError(e.getLocalizedMessage());
        }
        this.updateHostName();
    }

    public ApplicationDescription getShellApplicationDescription() {
        if (this.shellApplicationDescription == null) {
            if (this.isNewDescriptor()) {
                this.shellApplicationDescription = new ApplicationDescription();
            } else {
                try {
                    this.shellApplicationDescription = ApplicationDescription.fromXML((String)this.getOriginalDescription().toXML());
                }
                catch (XmlException xmlException) {
                    // empty catch block
                }
            }
        }
        return this.shellApplicationDescription;
    }

    public ApplicationDeploymentDescriptionType getApplicationDescriptionType() {
        return this.getShellApplicationDescription().getType();
    }

    public String getExecutablePath() {
        return this.getApplicationDescriptionType().getExecutableLocation();
    }

    public void setExecutablePath(String executablePath) {
        this.getApplicationDescriptionType().setExecutableLocation(executablePath);
        this.updateTempDirWithExecPath(executablePath);
        this.updateDialogStatus();
    }

    private void updateTempDirWithExecPath(String executablePath) {
    }

    public String getTempDir() {
        return this.getApplicationDescriptionType().getScratchWorkingDirectory();
    }

    public void setTempDir(String tempDir) {
        this.getApplicationDescriptionType().setScratchWorkingDirectory(tempDir);
        this.updateDialogStatus();
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    public void saveApplicationDescription() {
        this.setApplicationDescCreated(true);
    }

    public boolean isApplicationDescCreated() {
        return this.applcationDescCreated;
    }

    public void setApplicationDescCreated(boolean applicationDescCreated) {
        this.applcationDescCreated = applicationDescCreated;
    }

    private void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().equals("")) {
            this.lblError.setText("");
        } else {
            this.lblError.setText(errorMessage.trim());
        }
    }

    private void updateDialogStatus() {
        String message = null;
        try {
            this.validateDialog();
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        this.okButton.setEnabled(message == null);
        this.setError(message);
    }

    private void validateDialog() throws Exception {
        if (this.getExecutablePath() == null || this.getExecutablePath().trim().equals("")) {
            throw new Exception("Executable path cannot be empty!!!");
        }
        if (this.getTempDir() == null || this.getTempDir().trim().equals("")) {
            throw new Exception("Temporary directory location cannot be empty!!!");
        }
        if (this.getHostName() == null || this.getHostName().trim().equals("")) {
            throw new Exception("Please select/create host to bind to this deployment description");
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        if (hostName != null) {
            try {
                HostDescription hostDescription = this.registry.getApplicationManager().getHostDescription(hostName);
                if (hostDescription.getType() instanceof GlobusHostType) {
                    this.getShellApplicationDescription().getType().changeType(HpcApplicationDeploymentType.type);
                } else {
                    this.getShellApplicationDescription().getType().changeType(ApplicationDeploymentDescriptionType.type);
                }
                this.btnHostAdvanceOptions.setVisible(hostDescription.getType() instanceof GlobusHostType);
                String hostAddress = hostDescription.getType().getHostAddress();
                boolean isLocal = this.isLocalAddress(hostAddress);
                this.btnExecBrowse.setVisible(isLocal);
                this.btnTmpDirBrowse.setVisible(isLocal);
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
        }
        this.updateDialogStatus();
    }

    private boolean isLocalAddress(String hostAddress) {
        return hostAddress.equalsIgnoreCase("localhost") || hostAddress.equalsIgnoreCase("127.0.0.1");
    }

    private void updateHostName() {
        if (this.cmbHostName.getSelectedItem() != null) {
            this.setHostName(this.cmbHostName.getSelectedItem().toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbHostName) {
            this.updateHostName();
        }
        if (e.getSource() == this.txtExecPath) {
            this.setExecutablePath(this.txtExecPath.getText());
        }
        if (e.getSource() == this.txtTempDir) {
            this.setTempDir(this.txtTempDir.getText());
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public boolean isNewDescriptor() {
        return this.newDescriptor;
    }

    public void setNewDescriptor(boolean newDescriptor) {
        this.newDescriptor = newDescriptor;
    }

    public ApplicationDescription getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(ApplicationDescription originalDescription) {
        this.originalDescription = originalDescription;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public void setOriginalHost(String originalHost) {
        this.originalHost = originalHost;
    }

    public HostDeployment execute() throws AiravataAPIInvocationException {
        this.open();
        if (this.isApplicationDescCreated()) {
            return new HostDeployment(this.getRegistry().getApplicationManager().getHostDescription(this.getHostName()), this.getShellApplicationDescription());
        }
        return null;
    }

    public List<String> getExistingHostList() {
        return this.existingHostList;
    }

    public void setExistingHostList(List<String> existingHostList) {
        this.existingHostList = existingHostList;
    }

    public static class HostDeployment {
        private HostDescription hostDescription;
        private ApplicationDescription applicationDescription;

        public HostDeployment(HostDescription hostDescription, ApplicationDescription applicationDescription) {
            this.setHostDescription(hostDescription);
            this.setApplicationDescription(applicationDescription);
        }

        public ApplicationDescription getApplicationDescription() {
            return this.applicationDescription;
        }

        public void setApplicationDescription(ApplicationDescription applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public HostDescription getHostDescription() {
            return this.hostDescription;
        }

        public void setHostDescription(HostDescription hostDescription) {
            this.hostDescription = hostDescription;
        }
    }
}

