/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;

public class DescriptorListDialog
extends JDialog {
    private static final long serialVersionUID = 478151437279682576L;
    private XBayaGUI xbayaGUI;
    private XBayaDialog dialog;
    private AiravataAPI registry;
    private JList descriptorList;
    private Map<String[], ApplicationDescription> dlist;
    private JButton okButton;
    private boolean serviceSelected = false;
    public DescriptorType descriptorType;

    public DescriptorListDialog(AiravataAPI registry, DescriptorType descriptorType) {
        this.setRegistry(registry);
        this.descriptorType = descriptorType;
        this.initGUI();
    }

    public void open() {
        int height;
        this.pack();
        this.setModal(true);
        Dimension size = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int inset = 100;
        int width = size.width;
        if (width > screenSize.width) {
            width = screenSize.width - 100;
        }
        if ((height = size.height) > screenSize.height) {
            height = screenSize.height - 100;
        }
        this.setSize(width, height);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }

    private void initGUI() {
        this.descriptorList = new JList(new DefaultListModel());
        this.descriptorList.setCellRenderer(new DescriptorListCellRenderer(this.descriptorType));
        JScrollPane pane = new JScrollPane(this.descriptorList);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(pane);
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)infoPanel.getSwingComponent(), (int)1, (int)1, (int)0, (int)0);
        this.descriptorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean isSelected = DescriptorListDialog.this.descriptorList.getSelectedIndex() != -1;
                DescriptorListDialog.this.okButton.setEnabled(isSelected);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DescriptorListDialog.this.serviceSelected = true;
                DescriptorListDialog.this.close();
            }
        });
        JButton closeButton = new JButton("Cancel");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DescriptorListDialog.this.close();
            }
        });
        GridPanel buttonPanel = new GridPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(closeButton);
        buttonPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        String title = null;
        switch (this.descriptorType) {
            case HOST: {
                title = "Host Descriptions";
                break;
            }
            case SERVICE: {
                title = "Service Descriptions";
                break;
            }
            case APPLICATION: {
                title = "Application Descriptions";
            }
        }
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPanel.getSwingComponent());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setEnabled(false);
        this.loadDescriptors();
    }

    public Object getSelected() {
        return this.descriptorList.getModel().getElementAt(this.descriptorList.getSelectedIndex());
    }

    protected boolean askQuestion(String title, String question) {
        return JOptionPane.showConfirmDialog(null, question, title, 0) == 0;
    }

    private void loadDescriptors() {
        ((DefaultListModel)this.descriptorList.getModel()).removeAllElements();
        try {
            List<ApplicationDescription> descriptors = null;
            switch (this.descriptorType) {
                case HOST: {
                    descriptors = this.getRegistry().getApplicationManager().getAllHostDescriptions();
                    break;
                }
                case SERVICE: {
                    descriptors = this.getRegistry().getApplicationManager().getAllServiceDescriptions();
                    break;
                }
                case APPLICATION: {
                    this.dlist = this.getRegistry().getApplicationManager().getAllApplicationDescriptions();
                    descriptors = Arrays.asList(this.dlist.values().toArray(new ApplicationDescription[0]));
                }
            }
            for (Object e : descriptors) {
                ((DefaultListModel)this.descriptorList.getModel()).addElement(e);
            }
        }
        catch (AiravataAPIInvocationException e) {
            this.xbayaGUI.getErrorWindow().error(e);
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public boolean isServiceSelected() {
        return this.serviceSelected;
    }

    public void setServiceSelected(boolean serviceSelected) {
        this.serviceSelected = serviceSelected;
    }

    private static class DescriptorListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -1019715929291926180L;
        private DescriptorType descriptorType;

        public DescriptorListCellRenderer(DescriptorType descriptorType) {
            this.descriptorType = descriptorType;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                switch (this.descriptorType) {
                    case HOST: {
                        ((JLabel)c).setText(((HostDescription)value).getType().getHostName());
                        ((JLabel)c).setIcon(JCRBrowserIcons.HOST_ICON);
                        break;
                    }
                    case SERVICE: {
                        ((JLabel)c).setText(((ServiceDescription)value).getType().getName());
                        ((JLabel)c).setIcon(JCRBrowserIcons.SERVICE_ICON);
                        break;
                    }
                    case APPLICATION: {
                        ((JLabel)c).setText(((ApplicationDescription)value).getType().getApplicationName().getStringValue());
                        ((JLabel)c).setIcon(JCRBrowserIcons.APPLICATION_ICON);
                    }
                }
            }
            return c;
        }
    }

    public static enum DescriptorType {
        HOST,
        SERVICE,
        APPLICATION;

    }
}

