/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.registrybrowser.nodes.JCRBrowserIcons;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.DeploymentDescriptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;

public class DescriptorEditorDialog
extends JDialog {
    private static final long serialVersionUID = 478151437279682576L;
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private AiravataAPI registry;
    private JList descriptorList;
    private Map<ApplicationDescription, String> dlist;
    private JButton editButton;
    private AbstractButton removeButton;
    public DescriptorType descriptorType;

    public DescriptorEditorDialog(XBayaEngine engine, DescriptorType descriptorType) {
        this.engine = engine;
        this.setRegistry(engine.getConfiguration().getAiravataAPI());
        this.descriptorType = descriptorType;
        this.initGUI();
    }

    @Override
    public void show() {
        this.dialog.show();
    }

    @Override
    public void hide() {
        this.dialog.hide();
    }

    private void initGUI() {
        this.descriptorList = new JList(new DefaultListModel());
        this.descriptorList.setCellRenderer(new DescriptorListCellRenderer(this.descriptorType));
        JScrollPane pane = new JScrollPane(this.descriptorList);
        this.descriptorList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        DescriptorEditorDialog.this.editDescriptor();
                    }
                    catch (AiravataAPIInvocationException e1) {
                        DescriptorEditorDialog.this.engine.getGUI().getErrorWindow().error("Error while editing descriptor", e1);
                        e1.printStackTrace();
                    }
                }
            }
        });
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(pane);
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)infoPanel.getSwingComponent(), (int)1, (int)1, (int)0, (int)0);
        JButton newButton = new JButton("New...");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DescriptorEditorDialog.this.newDescriptor();
                }
                catch (AiravataAPIInvocationException e1) {
                    DescriptorEditorDialog.this.engine.getGUI().getErrorWindow().error("Error while creating descriptors", e1);
                    e1.printStackTrace();
                }
            }
        });
        this.descriptorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean isSelected = DescriptorEditorDialog.this.descriptorList.getSelectedIndex() != -1;
                DescriptorEditorDialog.this.editButton.setEnabled(isSelected);
                DescriptorEditorDialog.this.removeButton.setEnabled(isSelected);
            }
        });
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DescriptorEditorDialog.this.editDescriptor();
                }
                catch (AiravataAPIInvocationException e1) {
                    DescriptorEditorDialog.this.engine.getGUI().getErrorWindow().error("Error while editing descriptor", e1);
                    e1.printStackTrace();
                }
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DescriptorEditorDialog.this.deleteDescriptor();
                }
                catch (AiravataAPIInvocationException e1) {
                    DescriptorEditorDialog.this.engine.getGUI().getErrorWindow().error("Error while removing descriptor", e1);
                    e1.printStackTrace();
                }
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DescriptorEditorDialog.this.hide();
            }
        });
        GridPanel buttonPanel = new GridPanel();
        buttonPanel.add(newButton);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(closeButton);
        buttonPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        String title = null;
        switch (this.descriptorType) {
            case HOST: {
                title = "Host Descriptions";
                break;
            }
            case SERVICE: {
                title = "Applications";
                break;
            }
            case APPLICATION: {
                title = "Application Descriptions";
            }
        }
        this.dialog = new XBayaDialog(this.engine.getGUI(), title, (XBayaComponent)infoPanel, buttonPanel);
        this.dialog.setDefaultButton(this.editButton);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        try {
            this.loadDescriptors();
        }
        catch (AiravataAPIInvocationException e1) {
            this.engine.getGUI().getErrorWindow().error("Error while loading descriptors", e1);
            e1.printStackTrace();
        }
    }

    private void editDescriptor() throws AiravataAPIInvocationException {
        switch (this.descriptorType) {
            case HOST: {
                HostDescription h = (HostDescription)this.getSelected();
                HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(this.engine.getConfiguration().getAiravataAPI(), false, h, null);
                hostDescriptionDialog.setLocationRelativeTo(this.engine.getGUI().getFrame());
                hostDescriptionDialog.open();
                if (!hostDescriptionDialog.isHostCreated()) break;
                this.loadDescriptors();
                break;
            }
            case SERVICE: {
                ServiceDescription d = (ServiceDescription)this.getSelected();
                DeploymentDescriptionDialog serviceDescriptionDialog = new DeploymentDescriptionDialog(this.getAPI(), false, d, null);
                serviceDescriptionDialog.open();
                if (!serviceDescriptionDialog.isServiceCreated()) break;
                this.loadDescriptors();
                break;
            }
            case APPLICATION: {
                ApplicationDescription a = (ApplicationDescription)this.getSelected();
                String[] s = this.dlist.get(a).split("\\$");
                ApplicationDescriptionDialog aDescriptionDialog = new ApplicationDescriptionDialog(this.engine, false, a, s[1], s[0]);
                aDescriptionDialog.setLocationRelativeTo(this.engine.getGUI().getFrame());
                aDescriptionDialog.open();
                if (!aDescriptionDialog.isApplicationDescCreated()) break;
                this.loadDescriptors();
            }
        }
    }

    private void newDescriptor() throws AiravataAPIInvocationException {
        switch (this.descriptorType) {
            case HOST: {
                HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(this.engine.getConfiguration().getAiravataAPI(), null);
                hostDescriptionDialog.open();
                if (!hostDescriptionDialog.isHostCreated()) break;
                this.loadDescriptors();
                break;
            }
            case SERVICE: {
                DeploymentDescriptionDialog serviceDescriptionDialog = new DeploymentDescriptionDialog(null, this.getAPI());
                serviceDescriptionDialog.open();
                if (!serviceDescriptionDialog.isServiceCreated()) break;
                this.loadDescriptors();
                break;
            }
            case APPLICATION: {
                ApplicationDescriptionDialog applicationDescriptionDialog = new ApplicationDescriptionDialog(this.engine);
                applicationDescriptionDialog.setLocationRelativeTo(this.engine.getGUI().getFrame());
                applicationDescriptionDialog.open();
                if (!applicationDescriptionDialog.isApplicationDescCreated()) break;
                this.loadDescriptors();
            }
        }
    }

    private Object getSelected() {
        return this.descriptorList.getModel().getElementAt(this.descriptorList.getSelectedIndex());
    }

    protected boolean askQuestion(String title, String question) {
        return JOptionPane.showConfirmDialog(this, question, title, 0) == 0;
    }

    private boolean deleteDescriptor() throws AiravataAPIInvocationException {
        ApplicationDescription a;
        ServiceDescription d;
        HostDescription h;
        String title = null;
        String question = null;
        switch (this.descriptorType) {
            case HOST: {
                h = (HostDescription)this.getSelected();
                title = "Host description";
                question = "Are you sure that you want to remove the service description \"" + h.getType().getHostName() + "\"?";
                break;
            }
            case SERVICE: {
                d = (ServiceDescription)this.getSelected();
                title = "Service description";
                question = "Are you sure that you want to remove the applications associated with \"" + d.getType().getName() + "\"?";
                break;
            }
            case APPLICATION: {
                a = (ApplicationDescription)this.getSelected();
                title = "Service description";
                question = "Are you sure that you want to remove the service description \"" + a.getType().getApplicationName().getStringValue() + "\"?";
            }
        }
        if (this.askQuestion(title, question)) {
            switch (this.descriptorType) {
                case HOST: {
                    h = (HostDescription)this.getSelected();
                    this.getAPI().getApplicationManager().deleteHostDescription(h.getType().getHostName());
                    this.loadDescriptors();
                    break;
                }
                case SERVICE: {
                    d = (ServiceDescription)this.getSelected();
                    this.getAPI().getApplicationManager().deleteServiceDescription(d.getType().getName());
                    this.loadDescriptors();
                    break;
                }
                case APPLICATION: {
                    a = (ApplicationDescription)this.getSelected();
                    String[] s = this.dlist.get(a).split("\\$");
                    this.getAPI().getApplicationManager().deleteApplicationDescription(s[0], s[1], a.getType().getApplicationName().getStringValue());
                    this.loadDescriptors();
                }
            }
        }
        return true;
    }

    private void loadDescriptors() throws AiravataAPIInvocationException {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        ((DefaultListModel)this.descriptorList.getModel()).removeAllElements();
        List<ApplicationDescription> descriptors = null;
        switch (this.descriptorType) {
            case HOST: {
                descriptors = this.getAPI().getApplicationManager().getAllHostDescriptions();
                break;
            }
            case SERVICE: {
                descriptors = this.getAPI().getApplicationManager().getAllServiceDescriptions();
                break;
            }
            case APPLICATION: {
                Map temp = this.getAPI().getApplicationManager().getApplicationDescriptors(null);
                for (String value : temp.keySet()) {
                    this.dlist.put((ApplicationDescription)temp.get(value), value);
                }
                descriptors = Arrays.asList(this.dlist.keySet().toArray(new ApplicationDescription[0]));
            }
        }
        for (Object e : descriptors) {
            ((DefaultListModel)this.descriptorList.getModel()).addElement(e);
        }
    }

    public AiravataAPI getAPI() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    private static class DescriptorListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -1019715929291926180L;
        private DescriptorType descriptorType;

        public DescriptorListCellRenderer(DescriptorType descriptorType) {
            this.descriptorType = descriptorType;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (c instanceof JLabel) {
                switch (this.descriptorType) {
                    case HOST: {
                        ((JLabel)c).setText(((HostDescription)value).getType().getHostName());
                        ((JLabel)c).setIcon(JCRBrowserIcons.HOST_ICON);
                        break;
                    }
                    case SERVICE: {
                        ((JLabel)c).setText(((ServiceDescription)value).getType().getName());
                        ((JLabel)c).setIcon(JCRBrowserIcons.SERVICE_ICON);
                        break;
                    }
                    case APPLICATION: {
                        ((JLabel)c).setText(((ApplicationDescription)value).getType().getApplicationName().getStringValue());
                        ((JLabel)c).setIcon(JCRBrowserIcons.APPLICATION_ICON);
                    }
                }
            }
            return c;
        }
    }

    public static enum DescriptorType {
        HOST,
        SERVICE,
        APPLICATION;

    }
}

