/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.xml.namespace.QName;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.DataType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.gfac.InputParameterType;
import org.apache.airavata.schemas.gfac.OutputParameterType;
import org.apache.airavata.schemas.gfac.ParameterType;
import org.apache.airavata.schemas.gfac.ServiceDescriptionType;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDeploymentDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.xmlbeans.XmlCursor;

public class DeploymentDescriptionDialog
extends JDialog {
    private static final long serialVersionUID = 2705760838264284423L;
    private final GridPanel contentPanel = new GridPanel();
    private XBayaLabel lblServiceName;
    private XBayaTextField txtApplicationServiceName;
    private JTable tblParameters;
    private boolean serviceCreated = false;
    private JLabel lblError;
    private ServiceDescription serviceDescription;
    private ServiceDescription orginalServiceDescription;
    private JButton okButton;
    private JButton btnDeleteParameter;
    private DefaultTableModel defaultTableModel;
    private AiravataAPI registry;
    private boolean newDescription;
    private boolean ignoreTableChanges = false;
    private JCheckBox chkForceFileStagingToWorkDir;
    private String suggestedNamePrefix;
    private String titlePrefix;
    private Map<String, HostDeploymentDialog.HostDeployment> deployments;
    private JTable tblHosts;
    private DefaultTableModel tblModelHosts;

    public static void main(String[] args) {
        try {
            DeploymentDescriptionDialog dialog = new DeploymentDescriptionDialog(null, true, null, null);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DeploymentDescriptionDialog(JFrame parent, AiravataAPI registry) {
        this(registry, true, null, parent);
    }

    public DeploymentDescriptionDialog(AiravataAPI registry, boolean newDescription, ServiceDescription serviceDescription, JFrame parent) {
        super(parent);
        this.setNewDescription(newDescription);
        this.setOrginalServiceDescription(serviceDescription);
        this.setSuggestedNamePrefix(this.suggestedNamePrefix);
        if (this.isNewDescription()) {
            this.setTitlePrefix("Register Application");
        } else {
            this.setTitlePrefix("Update Application: " + this.getOrginalServiceDescription().getType().getName());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        this.setRegistry(registry);
        this.initGUI();
    }

    public void open() {
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected DeploymentDescriptionDialog getDialog() {
        return this;
    }

    private void initGUI() {
        this.setTitle(this.getTitlePrefix());
        this.setBounds(100, 100, 463, 459);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        borderLayout.setHgap(5);
        this.getContentPane().setLayout(borderLayout);
        this.txtApplicationServiceName = new XBayaTextField();
        this.txtApplicationServiceName.getSwingComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                DeploymentDescriptionDialog.this.setServiceName(DeploymentDescriptionDialog.this.txtApplicationServiceName.getText());
            }
        });
        this.txtApplicationServiceName.setColumns(10);
        this.lblServiceName = new XBayaLabel("Application name", this.txtApplicationServiceName);
        JLabel lblInputParameters = new JLabel("Application Parameters");
        lblInputParameters.setFont(new Font("Tahoma", 1, 11));
        JScrollPane scrollPane = new JScrollPane();
        this.tblParameters = this.createParameterTableControls();
        scrollPane.setViewportView(this.tblParameters);
        this.chkForceFileStagingToWorkDir = new JCheckBox("Advanced: Force input file staging to working directory");
        this.chkForceFileStagingToWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeploymentDescriptionDialog.this.setForceFileStagingToWorkDir(DeploymentDescriptionDialog.this.chkForceFileStagingToWorkDir.isSelected());
            }
        });
        GridPanel buttonPane = new GridPanel();
        GridBagLayout gbl_buttonPane = new GridBagLayout();
        gbl_buttonPane.columnWidths = new int[]{307, 136, 0};
        gbl_buttonPane.rowHeights = new int[]{33, 0};
        gbl_buttonPane.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_buttonPane.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.lblError = new JLabel("");
        this.lblError.setForeground(Color.RED);
        GridBagConstraints gbc_lblError = new GridBagConstraints();
        gbc_lblError.insets = new Insets(0, 0, 0, 5);
        gbc_lblError.gridx = 0;
        gbc_lblError.gridy = 0;
        buttonPane.add(this.lblError);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.anchor = 18;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 0;
        buttonPane.add(panel);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentDescriptionDialog.this.loadData();
            }
        });
        panel.add(resetButton);
        this.okButton = new JButton("Register");
        if (!this.isNewDescription()) {
            this.okButton.setText("Update");
        }
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if ("Register".equals(DeploymentDescriptionDialog.this.okButton.getText())) {
                        DeploymentDescriptionDialog.this.saveServiceDescription(false);
                    } else {
                        DeploymentDescriptionDialog.this.saveServiceDescription(true);
                    }
                    DeploymentDescriptionDialog.this.close();
                }
                catch (AiravataAPIInvocationException e1) {
                    e1.printStackTrace();
                }
            }
        });
        panel.add(this.okButton);
        this.okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentDescriptionDialog.this.setServiceCreated(false);
                DeploymentDescriptionDialog.this.close();
            }
        });
        panel.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        this.contentPanel.add(this.lblServiceName);
        this.contentPanel.add(this.txtApplicationServiceName);
        GridPanel pnlTables = new GridPanel();
        GridPanel parameterPanel = new GridPanel();
        parameterPanel.add(lblInputParameters);
        parameterPanel.add(scrollPane);
        parameterPanel.add(this.btnDeleteParameter);
        parameterPanel.add(this.chkForceFileStagingToWorkDir);
        SwingUtil.layoutToGrid((Container)this.contentPanel.getSwingComponent(), (int)1, (int)2, (int)-1, (int)1);
        SwingUtil.layoutToGrid((Container)parameterPanel.getSwingComponent(), (int)4, (int)1, (int)1, (int)0);
        pnlTables.add(parameterPanel);
        pnlTables.add(this.createHostDeploymentTable());
        pnlTables.layout(2, 1, -2, 0);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(this.contentPanel);
        infoPanel.add(pnlTables);
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        infoPanel.layout(2, 1, 1, 0);
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!this.isNewDescription()) {
            this.loadData();
        }
    }

    private GridPanel createHostDeploymentTable() {
        this.tblHosts = new JTable();
        this.tblHosts.setTableHeader(null);
        this.tblHosts.setFillsViewportHeight(true);
        this.tblModelHosts = new DefaultTableModel(new Object[0][], new String[]{"Host"}){
            private static final long serialVersionUID = -5973463590447809117L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tblHosts.setModel(this.tblModelHosts);
        ListSelectionModel selectionModel = this.tblHosts.getSelectionModel();
        selectionModel.setSelectionMode(2);
        JButton btnNewDeployment = new JButton("New deployment");
        btnNewDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDeploymentDialog hostDeploymentDialog = new HostDeploymentDialog(DeploymentDescriptionDialog.this.getRegistry(), true, null, null, Arrays.asList(DeploymentDescriptionDialog.this.getDeployments().keySet().toArray(new String[0])));
                try {
                    HostDeploymentDialog.HostDeployment deployDesc = hostDeploymentDialog.execute();
                    if (deployDesc != null) {
                        ApplicationDeploymentDescriptionType appType = deployDesc.getApplicationDescription().getType();
                        if (appType.getApplicationName() == null) {
                            appType.addNewApplicationName();
                        }
                        HostDescriptionType hostType = deployDesc.getHostDescription().getType();
                        appType.getApplicationName().setStringValue(hostType.getHostName() + "_application");
                        DeploymentDescriptionDialog.this.getDeployments().put(hostType.getHostName(), deployDesc);
                        DeploymentDescriptionDialog.this.updateDeploymentTable();
                    }
                }
                catch (AiravataAPIInvocationException e1) {
                    DeploymentDescriptionDialog.this.setError(e1.getLocalizedMessage());
                    e1.printStackTrace();
                }
            }
        });
        final JButton btnEditDeployment = new JButton("Edit deployment");
        btnEditDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentDescriptionDialog.this.editSelectedDeployment();
            }
        });
        final JButton btnDeleteDeployment = new JButton("Delete deployment");
        btnDeleteDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String hostName = DeploymentDescriptionDialog.this.tblModelHosts.getValueAt(DeploymentDescriptionDialog.this.tblHosts.getSelectedRow(), 0).toString();
                int result = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove the host deployment '" + hostName + "'?", "Remove Host Deployment", 0);
                if (result == 0) {
                    DeploymentDescriptionDialog.this.tblModelHosts.removeRow(DeploymentDescriptionDialog.this.tblHosts.getSelectedRow());
                    DeploymentDescriptionDialog.this.getDeployments().remove(hostName);
                }
            }
        });
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                btnEditDeployment.setEnabled(DeploymentDescriptionDialog.this.tblHosts.getSelectedRows().length > 0);
                btnDeleteDeployment.setEnabled(DeploymentDescriptionDialog.this.tblHosts.getSelectedRows().length > 0);
            }
        });
        this.tblHosts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && DeploymentDescriptionDialog.this.tblHosts.getSelectedRows().length > 0) {
                    DeploymentDescriptionDialog.this.editSelectedDeployment();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.tblHosts);
        GridPanel pnlTableButtons = new GridPanel();
        pnlTableButtons.add(btnNewDeployment);
        pnlTableButtons.add(btnEditDeployment);
        pnlTableButtons.add(btnDeleteDeployment);
        pnlTableButtons.layout(1, 3, -1, -2);
        GridPanel pnlMainPanel = new GridPanel();
        pnlMainPanel.add(scrollPane);
        pnlMainPanel.add(pnlTableButtons);
        pnlMainPanel.layout(2, 1, 0, 0);
        btnEditDeployment.setEnabled(false);
        btnDeleteDeployment.setEnabled(false);
        return pnlMainPanel;
    }

    private void updateDeploymentTable() {
        ArrayList<String> hosts = new ArrayList<String>();
        for (int i = 0; i < this.tblModelHosts.getRowCount(); ++i) {
            hosts.add((String)this.tblModelHosts.getValueAt(i, 0));
        }
        for (String hostName : this.getDeployments().keySet()) {
            if (hosts.contains(hostName)) continue;
            this.tblModelHosts.addRow(new Object[]{hostName});
        }
    }

    private JTable createParameterTableControls() {
        final JTable tblParameters = new JTable();
        tblParameters.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        tblParameters.setFillsViewportHeight(true);
        this.defaultTableModel = new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{"I/O", "Parameter Name", "Type", "Description"});
        tblParameters.setModel(this.defaultTableModel);
        this.defaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (!DeploymentDescriptionDialog.this.ignoreTableChanges) {
                    int selectedRow = tblParameters.getSelectedRow();
                    if (selectedRow != -1 && DeploymentDescriptionDialog.this.defaultTableModel.getRowCount() > 0) {
                        Object parameterIOType = DeploymentDescriptionDialog.this.defaultTableModel.getValueAt(selectedRow, 0);
                        Object parameterDataType = DeploymentDescriptionDialog.this.defaultTableModel.getValueAt(selectedRow, 2);
                        if (parameterIOType == null || parameterIOType.equals("")) {
                            DeploymentDescriptionDialog.this.defaultTableModel.setValueAt(DeploymentDescriptionDialog.this.getIOStringList()[0], selectedRow, 0);
                        }
                        if (parameterDataType == null || parameterDataType.equals("")) {
                            DeploymentDescriptionDialog.this.defaultTableModel.setValueAt(DeploymentDescriptionDialog.this.getDataTypes()[0], selectedRow, 2);
                        }
                    }
                    DeploymentDescriptionDialog.this.addNewRowIfLastIsNotEmpty();
                }
            }
        });
        TableColumn ioColumn = tblParameters.getColumnModel().getColumn(0);
        Object[] ioStringList = this.getIOStringList();
        ioColumn.setCellEditor(new StringArrayComboBoxEditor(ioStringList));
        TableColumn datatypeColumn = tblParameters.getColumnModel().getColumn(2);
        Object[] dataTypeStringList = this.getDataTypes();
        datatypeColumn.setCellEditor(new StringArrayComboBoxEditor(dataTypeStringList));
        TableColumn parameterNameCol = tblParameters.getColumnModel().getColumn(1);
        parameterNameCol.setPreferredWidth(190);
        ListSelectionModel selectionModel = tblParameters.getSelectionModel();
        selectionModel.setSelectionMode(2);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeploymentDescriptionDialog.this.btnDeleteParameter.setEnabled(tblParameters.getSelectedRows().length > 0);
            }
        });
        this.btnDeleteParameter = new JButton("Delete parameter");
        this.btnDeleteParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DeploymentDescriptionDialog.this.deleteSelectedRows();
            }
        });
        this.btnDeleteParameter.setEnabled(false);
        return tblParameters;
    }

    private void loadData() {
        ServiceDescriptionType descType = this.getOrginalServiceDescription().getType();
        this.txtApplicationServiceName.setText(descType.getName());
        this.setServiceName(this.txtApplicationServiceName.getText());
        this.txtApplicationServiceName.setEditable(this.isNewDescription());
        this.ignoreTableChanges = true;
        this.updateIODataTable(descType);
        this.getDeployments().clear();
        try {
            Map descs = this.getRegistry().getApplicationManager().getApplicationDescriptors(descType.getName());
            for (String hostDescName : descs.keySet()) {
                this.getDeployments().put(hostDescName, new HostDeploymentDialog.HostDeployment(this.getRegistry().getApplicationManager().getHostDescription(hostDescName), (ApplicationDescription)descs.get(hostDescName)));
            }
            this.updateDeploymentTable();
            Boolean selected = false;
            if (descType.getPortType() != null && descType.getPortType().getMethod() != null) {
                XmlCursor cursor = descType.getPortType().getMethod().newCursor();
                String value = cursor.getAttributeText(new QName("forceFileStagingToWorkDir"));
                cursor.dispose();
                selected = false;
                if (value != null) {
                    selected = Boolean.parseBoolean(value);
                }
            }
            this.chkForceFileStagingToWorkDir.setSelected(selected);
            this.setForceFileStagingToWorkDir(selected);
            this.ignoreTableChanges = false;
        }
        catch (AiravataAPIInvocationException e) {
            e.printStackTrace();
        }
    }

    private void updateIODataTable(ServiceDescriptionType descType) {
        OutputParameterType[] oparameters;
        InputParameterType[] iparameters;
        while (this.defaultTableModel.getRowCount() > 0) {
            this.defaultTableModel.removeRow(0);
        }
        for (InputParameterType parameter : iparameters = descType.getInputParametersArray()) {
            this.defaultTableModel.addRow(new Object[]{this.getIOStringList()[0], parameter.getParameterName(), parameter.getParameterType().getName(), parameter.getParameterDescription()});
        }
        for (OutputParameterType parameter : oparameters = descType.getOutputParametersArray()) {
            this.defaultTableModel.addRow(new Object[]{this.getIOStringList()[1], parameter.getParameterName(), parameter.getParameterType().getName(), parameter.getParameterDescription()});
        }
        this.addNewRowIfLastIsNotEmpty();
    }

    private String[] getIOStringList() {
        String[] ioStringList = new String[]{"Input", "Output"};
        return ioStringList;
    }

    private String[] getDataTypes() {
        String[] type = new String[DataType.Enum.table.lastInt()];
        for (int i = 1; i <= DataType.Enum.table.lastInt(); ++i) {
            type[i - 1] = DataType.Enum.forInt((int)i).toString();
        }
        return type;
    }

    public boolean isServiceCreated() {
        return this.serviceCreated;
    }

    public void setServiceCreated(boolean serviceCreated) {
        this.serviceCreated = serviceCreated;
    }

    public ServiceDescription getServiceDescription() {
        if (this.serviceDescription == null) {
            this.serviceDescription = new ServiceDescription();
        }
        return this.serviceDescription;
    }

    public ServiceDescriptionType getServiceDescriptionType() {
        return this.getServiceDescription().getType();
    }

    public String getServiceName() {
        return this.getServiceDescription().getType().getName();
    }

    public void setServiceName(String serviceName) {
        this.getServiceDescription().getType().setName(serviceName);
        this.updateDialogStatus();
    }

    private void setupMethod() {
        if (this.getServiceDescriptionType().getPortType() == null) {
            this.getServiceDescriptionType().setPortType(this.getServiceDescriptionType().addNewPortType());
        }
        if (this.getServiceDescriptionType().getPortType().getMethod() == null) {
            this.getServiceDescriptionType().getPortType().setMethod(this.getServiceDescriptionType().getPortType().addNewMethod());
        }
    }

    public void setForceFileStagingToWorkDir(Boolean force) {
        this.setupMethod();
        XmlCursor cursor = this.getServiceDescriptionType().getPortType().getMethod().newCursor();
        cursor.toNextToken();
        if (!cursor.setAttributeText(new QName("http://airavata.apache.org/schemas/gfac/2012/12", "forceFileStagingToWorkDir"), force.toString())) {
            cursor.insertAttributeWithValue("forceFileStagingToWorkDir", force.toString());
        }
        cursor.dispose();
    }

    public Boolean getForceFileStagingToWorkDir() {
        this.setupMethod();
        XmlCursor cursor = this.getServiceDescriptionType().getPortType().getMethod().newCursor();
        cursor.toNextToken();
        String value = cursor.getAttributeText(new QName("forceFileStagingToWorkDir"));
        cursor.dispose();
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private void updateDialogStatus() {
        String message = null;
        try {
            this.validateDialog();
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        this.okButton.setEnabled(message == null);
        this.setError(message);
    }

    private void validateDialog() throws Exception {
        if (this.getServiceName() == null || this.getServiceName().trim().equals("")) {
            throw new Exception("Name of the application cannot be empty!!!");
        }
        ServiceDescription serviceDescription2 = null;
        serviceDescription2 = this.getRegistry().getApplicationManager().getServiceDescription(this.getServiceName());
        if (this.isNewDescription() && serviceDescription2 != null) {
            throw new Exception("Service descriptor with the given name already exists!!!");
        }
    }

    public void saveServiceDescription(boolean update) throws AiravataAPIInvocationException {
        ArrayList<InputParameterType> inputParameters = new ArrayList<InputParameterType>();
        ArrayList<InputParameterType> outputParameters = new ArrayList<InputParameterType>();
        for (int i = 0; i < this.defaultTableModel.getRowCount(); ++i) {
            ParameterType parameterType;
            InputParameterType parameter;
            String parameterName = (String)this.defaultTableModel.getValueAt(i, 1);
            String paramType = (String)this.defaultTableModel.getValueAt(i, 2);
            String parameterDescription = (String)this.defaultTableModel.getValueAt(i, 3);
            if (parameterName == null || parameterName.trim().equals("")) continue;
            if (this.getIOStringList()[0].equals(this.defaultTableModel.getValueAt(i, 0))) {
                parameter = InputParameterType.Factory.newInstance();
                parameter.setParameterName(parameterName);
                parameter.setParameterDescription(parameterDescription);
                parameterType = parameter.addNewParameterType();
                parameterType.setType(DataType.Enum.forString((String)paramType));
                parameterType.setName(paramType);
                inputParameters.add(parameter);
                continue;
            }
            parameter = OutputParameterType.Factory.newInstance();
            parameter.setParameterName(parameterName);
            parameter.setParameterDescription(parameterDescription);
            parameterType = parameter.addNewParameterType();
            parameterType.setType(DataType.Enum.forString((String)paramType));
            parameterType.setName(paramType);
            outputParameters.add(parameter);
        }
        this.getServiceDescriptionType().setInputParametersArray(inputParameters.toArray(new InputParameterType[0]));
        this.getServiceDescriptionType().setOutputParametersArray(outputParameters.toArray(new OutputParameterType[0]));
        if (update) {
            this.getRegistry().getApplicationManager().updateServiceDescriptor(this.getServiceDescription());
        } else {
            this.getRegistry().getApplicationManager().saveServiceDescription(this.getServiceDescription());
        }
        if (!this.isNewDescription()) {
            Map descs = this.getRegistry().getApplicationManager().getApplicationDescriptors(this.getServiceName());
            for (String hostDescName : descs.keySet()) {
                this.getRegistry().getApplicationManager().deleteApplicationDescription(this.getServiceName(), hostDescName, ((ApplicationDescription)descs.get(hostDescName)).getType().getApplicationName().getStringValue());
            }
        }
        for (String hostName : this.getDeployments().keySet()) {
            this.getRegistry().getApplicationManager().saveApplicationDescription(this.getServiceName(), hostName, this.getDeployments().get(hostName).getApplicationDescription());
        }
        this.setServiceCreated(true);
        JOptionPane.showMessageDialog(this, "Application '" + this.getServiceName() + "' is registered Successfully !");
    }

    public void saveServiceDescription() throws AiravataAPIInvocationException {
        ArrayList<InputParameterType> inputParameters = new ArrayList<InputParameterType>();
        ArrayList<InputParameterType> outputParameters = new ArrayList<InputParameterType>();
        for (int i = 0; i < this.defaultTableModel.getRowCount(); ++i) {
            ParameterType parameterType;
            InputParameterType parameter;
            String parameterName = (String)this.defaultTableModel.getValueAt(i, 1);
            String paramType = (String)this.defaultTableModel.getValueAt(i, 2);
            String parameterDescription = (String)this.defaultTableModel.getValueAt(i, 3);
            if (parameterName == null || parameterName.trim().equals("")) continue;
            if (this.getIOStringList()[0].equals(this.defaultTableModel.getValueAt(i, 0))) {
                parameter = InputParameterType.Factory.newInstance();
                parameter.setParameterName(parameterName);
                parameter.setParameterDescription(parameterDescription);
                parameterType = parameter.addNewParameterType();
                parameterType.setType(DataType.Enum.forString((String)paramType));
                parameterType.setName(paramType);
                inputParameters.add(parameter);
                continue;
            }
            parameter = OutputParameterType.Factory.newInstance();
            parameter.setParameterName(parameterName);
            parameter.setParameterDescription(parameterDescription);
            parameterType = parameter.addNewParameterType();
            parameterType.setType(DataType.Enum.forString((String)paramType));
            parameterType.setName(paramType);
            outputParameters.add(parameter);
        }
        this.getServiceDescriptionType().setInputParametersArray(inputParameters.toArray(new InputParameterType[0]));
        this.getServiceDescriptionType().setOutputParametersArray(outputParameters.toArray(new OutputParameterType[0]));
        this.getRegistry().getApplicationManager().saveServiceDescription(this.getServiceDescription());
        if (!this.isNewDescription()) {
            Map descs = this.getRegistry().getApplicationManager().getApplicationDescriptors(this.getServiceName());
            for (String hostDescName : descs.keySet()) {
                this.getRegistry().getApplicationManager().deleteApplicationDescription(this.getServiceName(), hostDescName, ((ApplicationDescription)descs.get(hostDescName)).getType().getApplicationName().getStringValue());
            }
        }
        for (String hostName : this.getDeployments().keySet()) {
            this.getRegistry().getApplicationManager().saveApplicationDescription(this.getServiceName(), hostName, this.getDeployments().get(hostName).getApplicationDescription());
        }
        this.setServiceCreated(true);
        JOptionPane.showMessageDialog(this, "Application '" + this.getServiceName() + "' is registered Successfully !");
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    private void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().equals("")) {
            this.lblError.setText("");
        } else {
            this.lblError.setText(errorMessage.trim());
        }
    }

    private void deleteSelectedRows() {
        int selectedRow = this.tblParameters.getSelectedRow();
        while (selectedRow >= 0 && this.tblParameters.getRowCount() > 0) {
            this.defaultTableModel.removeRow(selectedRow);
            selectedRow = this.tblParameters.getSelectedRow();
        }
        this.addNewRowIfLastIsNotEmpty();
    }

    private void addNewRowIfLastIsNotEmpty() {
        if (this.defaultTableModel.getRowCount() > 0) {
            Object parameterName = this.defaultTableModel.getValueAt(this.defaultTableModel.getRowCount() - 1, 1);
            if (parameterName != null && !parameterName.equals("")) {
                this.defaultTableModel.addRow(new Object[]{null, null, null, null});
            }
        } else if (this.tblParameters.getSelectedRow() == -1) {
            this.defaultTableModel.addRow(new Object[]{null, null, null, null});
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public boolean isNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(boolean newDescription) {
        this.newDescription = newDescription;
    }

    public ServiceDescription getOrginalServiceDescription() {
        return this.orginalServiceDescription;
    }

    public void setOrginalServiceDescription(ServiceDescription orginalServiceDescription) {
        this.orginalServiceDescription = orginalServiceDescription;
    }

    public String getSuggestedNamePrefix() {
        return this.suggestedNamePrefix;
    }

    public void setSuggestedNamePrefix(String suggestedNamePrefix) {
        this.suggestedNamePrefix = suggestedNamePrefix;
    }

    public String getTitlePrefix() {
        return this.titlePrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.titlePrefix = titlePrefix;
    }

    public Map<String, HostDeploymentDialog.HostDeployment> getDeployments() {
        if (this.deployments == null) {
            this.deployments = new HashMap<String, HostDeploymentDialog.HostDeployment>();
        }
        return this.deployments;
    }

    private void editSelectedDeployment() {
        String hostName = this.tblModelHosts.getValueAt(this.tblHosts.getSelectedRow(), 0).toString();
        HostDeploymentDialog hostDeploymentDialog = new HostDeploymentDialog(this.getRegistry(), false, this.getDeployments().get(hostName).getApplicationDescription(), hostName, Arrays.asList(this.getDeployments().keySet().toArray(new String[0])));
        try {
            HostDeploymentDialog.HostDeployment deployDesc = hostDeploymentDialog.execute();
            if (deployDesc != null) {
                this.getDeployments().put(deployDesc.getHostDescription().getType().getHostName(), deployDesc);
                this.updateDeploymentTable();
            }
        }
        catch (AiravataAPIInvocationException e1) {
            this.setError(e1.getLocalizedMessage());
            e1.printStackTrace();
        }
    }

    private class StringArrayComboBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -304464739219209395L;

        public StringArrayComboBoxEditor(Object[] items) {
            super(new JComboBox<Object>(items));
        }
    }
}

