/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.schemas.gfac.JobTypeType;
import org.apache.airavata.schemas.gfac.ProjectAccountType;
import org.apache.airavata.schemas.gfac.QueueType;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComboBox;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class ApplicationDescriptionHostAdvancedOptionDialog
extends JDialog {
    private static final long serialVersionUID = 3920479739097405014L;
    private XBayaComboBox cmbJobType;
    private XBayaTextField txtProjectAccountNumber;
    private XBayaTextField txtProjectAccountDescription;
    private XBayaTextField txtQueueType;
    private XBayaTextField txtMaxWallTime = new XBayaTextField();
    private XBayaTextField txtMinMemory = new XBayaTextField();
    private XBayaTextField txtMaxMemory = new XBayaTextField();
    private XBayaTextField txtCpuCount = new XBayaTextField();
    private XBayaTextField txtNodeCount = new XBayaTextField();
    private XBayaTextField txtProcessorsPerNode = new XBayaTextField();
    private JButton okButton;
    private AiravataAPI registry;
    private ApplicationDescription descriptor;
    private XBayaLabel lblCpuCount;
    private XBayaLabel lblProcessorPerNode;
    private XBayaLabel lbNodeCount;
    private static List<JobTypeType.Enum> jobTypes;

    public ApplicationDescriptionHostAdvancedOptionDialog(AiravataAPI registry, ApplicationDescription descriptor) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                ApplicationDescriptionHostAdvancedOptionDialog.this.loadApplicationDescriptionAdvancedOptions();
            }
        });
        this.setRegistry(registry);
        this.setShellApplicationDescription(descriptor);
        this.initGUI();
    }

    public void open() {
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected ApplicationDescriptionHostAdvancedOptionDialog getDialog() {
        return this;
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    private void initGUI() {
        this.setTitle("HPC Configuration Options");
        this.setModal(true);
        this.setBounds(100, 100, 500, 500);
        this.setLocationRelativeTo(null);
        GridPanel buttonPane = new GridPanel();
        this.okButton = new JButton("Update");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ApplicationDescriptionHostAdvancedOptionDialog.this.saveApplicationDescriptionAdvancedOptions()) {
                    ApplicationDescriptionHostAdvancedOptionDialog.this.close();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionHostAdvancedOptionDialog.this.close();
            }
        });
        GridPanel panel = new GridPanel();
        this.txtProjectAccountNumber = new XBayaTextField();
        this.txtProjectAccountDescription = new XBayaTextField();
        this.txtQueueType = new XBayaTextField();
        this.txtMaxWallTime = new XBayaTextField();
        this.txtMinMemory = new XBayaTextField();
        this.txtMaxMemory = new XBayaTextField();
        this.txtCpuCount = new XBayaTextField();
        this.txtProcessorsPerNode = new XBayaTextField();
        this.txtNodeCount = new XBayaTextField();
        DefaultComboBoxModel<String> cmbModelJobType = new DefaultComboBoxModel<String>(this.getJobTypesAsStrings());
        this.cmbJobType = new XBayaComboBox(cmbModelJobType);
        this.cmbJobType.setEditable(false);
        XBayaLabel lbljobType = new XBayaLabel("Job Type", this.cmbJobType);
        XBayaLabel lblProjectAccountNumber = new XBayaLabel("Project Account Number *", this.txtProjectAccountNumber);
        XBayaLabel lblProjectAccountDescription = new XBayaLabel("Project Account Description", this.txtProjectAccountDescription);
        XBayaLabel lblQueueType = new XBayaLabel("Queue Type *", this.txtQueueType);
        XBayaLabel lblMaxWallTime = new XBayaLabel("Max Wall Time", this.txtMaxWallTime);
        this.lblCpuCount = new XBayaLabel("CPU Count", this.txtCpuCount);
        this.lblProcessorPerNode = new XBayaLabel("Processor Per Node", this.txtProcessorsPerNode);
        XBayaLabel lblMinMemory = new XBayaLabel("Min Memory", this.txtMinMemory);
        XBayaLabel lblMaxMemory = new XBayaLabel("Max Memory", this.txtMaxMemory);
        this.lbNodeCount = new XBayaLabel("Node Count", this.txtNodeCount);
        panel.add(lbljobType);
        panel.add(this.cmbJobType);
        panel.add(lblProjectAccountNumber);
        panel.add(this.txtProjectAccountNumber);
        panel.add(lblProjectAccountDescription);
        panel.add(this.txtProjectAccountDescription);
        panel.add(lblQueueType);
        panel.add(this.txtQueueType);
        panel.add(lblMaxWallTime);
        panel.add(this.txtMaxWallTime);
        panel.add(this.lblCpuCount);
        panel.add(this.txtCpuCount);
        panel.add(this.lbNodeCount);
        panel.add(this.txtNodeCount);
        panel.add(this.lblProcessorPerNode);
        panel.add(this.txtProcessorsPerNode);
        panel.add(lblMinMemory);
        panel.add(this.txtMinMemory);
        panel.add(lblMaxMemory);
        panel.add(this.txtMaxMemory);
        panel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)panel.getSwingComponent(), (int)10, (int)2, (int)-1, (int)1);
        buttonPane.add(this.okButton);
        buttonPane.add(cancelButton);
        this.getContentPane().add(panel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private List<JobTypeType.Enum> getJobTypes() {
        if (jobTypes == null) {
            jobTypes = new ArrayList<JobTypeType.Enum>();
            jobTypes.add(JobTypeType.OPEN_MP);
            jobTypes.add(JobTypeType.MPI);
            jobTypes.add(JobTypeType.SERIAL);
        }
        return jobTypes;
    }

    private String[] getJobTypesAsStrings() {
        ArrayList<String> typeList = new ArrayList<String>();
        for (JobTypeType.Enum jtype : this.getJobTypes()) {
            typeList.add(jtype.toString());
        }
        return typeList.toArray(new String[0]);
    }

    private JobTypeType.Enum getJobTypeEnum(String jobTypeString) {
        for (JobTypeType.Enum jtype : this.getJobTypes()) {
            if (!jtype.toString().equalsIgnoreCase(jobTypeString)) continue;
            return jtype;
        }
        return null;
    }

    public ApplicationDescription getApplicationDescription() {
        return this.descriptor;
    }

    public HpcApplicationDeploymentType getHPCApplicationDescriptionType() {
        return (HpcApplicationDeploymentType)this.descriptor.getType();
    }

    public void setShellApplicationDescription(ApplicationDescription shellApplicationDescription) {
        this.descriptor = shellApplicationDescription;
    }

    private boolean isValueNotEmpty(String s) {
        return !s.trim().isEmpty();
    }

    private void showError(String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    private boolean saveApplicationDescriptionAdvancedOptions() {
        if (this.isValueNotEmpty(this.cmbJobType.getText())) {
            this.getHPCApplicationDescriptionType().setJobType(this.getJobTypeEnum(this.cmbJobType.getText()));
        }
        try {
            if (this.isValueNotEmpty(this.txtMaxWallTime.getText())) {
                this.getHPCApplicationDescriptionType().setMaxWallTime(Integer.parseInt(this.txtMaxWallTime.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("Max wall time must be a number", "Invalid value");
            return false;
        }
        try {
            if (this.isValueNotEmpty(this.txtCpuCount.getText())) {
                this.getHPCApplicationDescriptionType().setCpuCount(Integer.parseInt(this.txtCpuCount.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("CPU count must be a number", "Invalid value");
            return false;
        }
        try {
            if (this.isValueNotEmpty(this.txtProcessorsPerNode.getText())) {
                this.getHPCApplicationDescriptionType().setProcessorsPerNode(Integer.parseInt(this.txtProcessorsPerNode.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("Processors per node must be a number", "Invalid value");
            return false;
        }
        try {
            if (this.isValueNotEmpty(this.txtNodeCount.getText())) {
                this.getHPCApplicationDescriptionType().setNodeCount(Integer.parseInt(this.txtNodeCount.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("Node count must be a number", "Invalid value");
            return false;
        }
        try {
            if (this.isValueNotEmpty(this.txtMinMemory.getText())) {
                this.getHPCApplicationDescriptionType().setMinMemory(Integer.parseInt(this.txtMinMemory.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("Minimum memory must be a number", "Invalid value");
            return false;
        }
        try {
            if (this.isValueNotEmpty(this.txtMaxMemory.getText())) {
                this.getHPCApplicationDescriptionType().setMaxMemory(Integer.parseInt(this.txtMaxMemory.getText()));
            }
        }
        catch (NumberFormatException e) {
            this.showError("Maximum memory must be a number", "Invalid value");
            return false;
        }
        ProjectAccountType projectAccount = this.getProjectAccountType();
        if (this.isValueNotEmpty(this.txtProjectAccountNumber.getText())) {
            projectAccount.setProjectAccountNumber(this.txtProjectAccountNumber.getText());
        }
        if (this.isValueNotEmpty(this.txtProjectAccountDescription.getText())) {
            projectAccount.setProjectAccountDescription(this.txtProjectAccountDescription.getText());
        }
        if (this.isValueNotEmpty(this.txtQueueType.getText())) {
            QueueType queueName = this.getQueueName();
            queueName.setQueueName(this.txtQueueType.getText());
        }
        return true;
    }

    private QueueType getQueueName() {
        if (this.getHPCApplicationDescriptionType().getQueue() == null) {
            this.getHPCApplicationDescriptionType().addNewQueue();
        }
        return this.getHPCApplicationDescriptionType().getQueue();
    }

    private ProjectAccountType getProjectAccountType() {
        if (this.getHPCApplicationDescriptionType().getProjectAccount() == null) {
            this.getHPCApplicationDescriptionType().addNewProjectAccount();
        }
        return this.getHPCApplicationDescriptionType().getProjectAccount();
    }

    private String getPropValue(int num) {
        if (num == 0) {
            return "";
        }
        return String.valueOf(num);
    }

    private void loadApplicationDescriptionAdvancedOptions() {
        HpcApplicationDeploymentType hpcAppType = this.getHPCApplicationDescriptionType();
        if (hpcAppType.getJobType() != null) {
            this.cmbJobType.setSelectedItem(hpcAppType.getJobType().toString());
        }
        this.txtMaxWallTime.setText(this.getPropValue(hpcAppType.getMaxWallTime()));
        this.txtCpuCount.setText(this.getPropValue(hpcAppType.getCpuCount()));
        this.txtNodeCount.setText(this.getPropValue(hpcAppType.getNodeCount()));
        this.txtProcessorsPerNode.setText(this.getPropValue(hpcAppType.getProcessorsPerNode()));
        this.txtMinMemory.setText(this.getPropValue(hpcAppType.getMinMemory()));
        this.txtMaxMemory.setText(this.getPropValue(hpcAppType.getMaxMemory()));
        this.txtNodeCount.setText(this.getPropValue(hpcAppType.getNodeCount()));
        ProjectAccountType projectAccount = this.getProjectAccountType();
        this.txtProjectAccountNumber.setText(projectAccount.getProjectAccountNumber() == null ? "" : projectAccount.getProjectAccountNumber());
        this.txtProjectAccountDescription.setText(projectAccount.getProjectAccountDescription() == null ? "" : projectAccount.getProjectAccountDescription());
        QueueType queueName = this.getQueueName();
        this.txtQueueType.setText(queueName.getQueueName() == null ? "" : queueName.getQueueName());
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }
}

