/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionAdvancedOptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ApplicationDescriptionHostAdvancedOptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.HostDescriptionDialog;
import org.apache.airavata.xbaya.ui.dialogs.descriptors.ServiceDescriptionDialog;
import org.apache.airavata.xbaya.ui.menues.MenuIcons;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLinkButton;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.xmlbeans.XmlException;

public class ApplicationDescriptionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -2745085755585610025L;
    private XBayaTextField txtExecPath;
    private XBayaTextField txtAppName;
    private XBayaTextField txtTempDir;
    private AiravataAPI registry;
    private ApplicationDescription shellApplicationDescription;
    private JLabel lblError;
    private boolean applcationDescCreated = false;
    private JButton okButton;
    private String serviceName;
    private String hostName;
    private JComboBox cmbHostName;
    private XBayaEngine engine;
    private JButton btnHostAdvanceOptions;
    private boolean newDescritor;
    private ApplicationDescription originalDescription;
    private String originalHost;
    private String originalService;
    private ServiceDescription serviceDescription = null;
    private JButton btnTmpDirBrowse;
    private JButton btnExecBrowse;

    public static void main(String[] args) {
        try {
            ApplicationDescriptionDialog dialog = new ApplicationDescriptionDialog(null);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApplicationDescriptionDialog(XBayaEngine engine) {
        this(engine, true, null, null, null);
    }

    public ApplicationDescriptionDialog(XBayaEngine engine, boolean newDescritor, ApplicationDescription originalDescription, String originalHost, String originalService) {
        this.setNewDescritor(newDescritor);
        this.setOriginalDescription(originalDescription);
        this.setOriginalHost(originalHost);
        this.setOriginalService(originalService);
        this.setRegistry(engine.getConfiguration().getAiravataAPI());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                if (ApplicationDescriptionDialog.this.isNewDescritor()) {
                    String baseName = "Application";
                    int i = 1;
                    String defaultName = baseName + i;
                    try {
                        ApplicationDescription applicationDescription = ApplicationDescriptionDialog.this.getRegistry().getApplicationManager().getApplicationDescription(ApplicationDescriptionDialog.this.getServiceName(), ApplicationDescriptionDialog.this.getHostName());
                        while (true) {
                            boolean notFound = true;
                            if (applicationDescription.getType().getApplicationName().getStringValue().equals(defaultName)) {
                                notFound = false;
                            } else if (!notFound) {
                                defaultName = baseName + ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ApplicationDescriptionDialog.this.txtAppName.setText(defaultName);
                    ApplicationDescriptionDialog.this.setApplicationName(ApplicationDescriptionDialog.this.txtAppName.getText());
                }
            }
        });
        this.engine = engine;
        this.iniGUI();
        if (originalService != null) {
            try {
                ServiceDescription disc = this.getRegistry().getApplicationManager().getServiceDescription(originalService);
                if (disc != null) {
                    this.setServiceDescription(disc);
                }
                throw new AiravataAPIInvocationException((Throwable)new Exception("Service Description not found in registry."));
            }
            catch (AiravataAPIInvocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void open() {
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected ApplicationDescriptionDialog getDialog() {
        return this;
    }

    private void iniGUI() {
        if (this.isNewDescritor()) {
            this.setTitle("Application Description");
        } else {
            this.setTitle("Update Application Description: " + this.getOriginalDescription().getType().getApplicationName().getStringValue());
        }
        this.setBounds(100, 100, 600, 620);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        GridPanel buttonPane = new GridPanel();
        this.lblError = new JLabel("");
        this.lblError.setForeground(Color.RED);
        buttonPane.add(this.lblError);
        if (!this.isNewDescritor()) {
            JButton resetButton = new JButton("Reset");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationDescriptionDialog.this.loadData();
                }
            });
            buttonPane.add(resetButton);
        }
        this.okButton = new JButton("Save");
        if (!this.isNewDescritor()) {
            this.okButton.setText("Update");
        }
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionDialog.this.saveApplicationDescription();
                ApplicationDescriptionDialog.this.close();
            }
        });
        this.okButton.setEnabled(false);
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionDialog.this.setApplicationDescCreated(false);
                ApplicationDescriptionDialog.this.close();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JPanel execPath = new JPanel();
        this.txtExecPath = new XBayaTextField();
        this.txtExecPath.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ApplicationDescriptionDialog.this.setExecutablePath(ApplicationDescriptionDialog.this.txtExecPath.getText());
            }
        });
        this.txtExecPath.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                ApplicationDescriptionDialog.this.updateTempDirWithExecPath(ApplicationDescriptionDialog.this.txtExecPath.getText());
            }
        });
        this.txtExecPath.setColumns(10);
        this.btnExecBrowse = new JButton(MenuIcons.OPEN_ICON);
        this.btnExecBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser c = new JFileChooser();
                int rVal = c.showOpenDialog(null);
                if (rVal == 0) {
                    ApplicationDescriptionDialog.this.txtExecPath.setText(c.getSelectedFile().toString());
                    ApplicationDescriptionDialog.this.setExecutablePath(ApplicationDescriptionDialog.this.txtExecPath.getText());
                }
            }
        });
        execPath.add(this.txtExecPath.getSwingComponent());
        execPath.add(this.btnExecBrowse);
        JButton btnIOParameters = new JButton("IO Parameters...");
        btnIOParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ServiceDescriptionDialog serviceDescriptionDialog = new ServiceDescriptionDialog(ApplicationDescriptionDialog.this.getRegistry(), ApplicationDescriptionDialog.this.getServiceDescription() == null, ApplicationDescriptionDialog.this.getServiceDescription(), false, ApplicationDescriptionDialog.this.getApplicationName());
                    serviceDescriptionDialog.setLocationRelativeTo(ApplicationDescriptionDialog.this.getContentPane());
                    serviceDescriptionDialog.open();
                    if (serviceDescriptionDialog.isServiceCreated()) {
                        ApplicationDescriptionDialog.this.setServiceDescription(serviceDescriptionDialog.getServiceDescription());
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        execPath.add(new JLabel("   "));
        execPath.add(btnIOParameters);
        this.setupLayoutForBrowse(execPath, this.txtExecPath.getSwingComponent());
        this.txtAppName = new XBayaTextField();
        this.txtAppName.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                ApplicationDescriptionDialog.this.setApplicationName(ApplicationDescriptionDialog.this.txtAppName.getText());
            }
        });
        this.txtAppName.setColumns(10);
        XBayaLabel lblApplicationName = new XBayaLabel("Application name", this.txtAppName);
        JLabel lblExecutablePath = new JLabel("Executable path");
        JPanel tmpDirPath = new JPanel();
        this.txtTempDir = new XBayaTextField();
        this.txtTempDir.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ApplicationDescriptionDialog.this.setTempDir(ApplicationDescriptionDialog.this.txtTempDir.getText());
            }
        });
        this.txtTempDir.setColumns(10);
        this.btnTmpDirBrowse = new JButton(MenuIcons.OPEN_DIR_ICON);
        this.btnTmpDirBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser c = new JFileChooser();
                c.setFileSelectionMode(1);
                int rVal = c.showOpenDialog(null);
                if (rVal == 0) {
                    ApplicationDescriptionDialog.this.txtTempDir.setText(c.getSelectedFile().toString());
                    ApplicationDescriptionDialog.this.setTempDir(ApplicationDescriptionDialog.this.txtTempDir.getText());
                }
            }
        });
        JTextField component = this.txtTempDir.getSwingComponent();
        tmpDirPath.add(component);
        tmpDirPath.add(this.btnTmpDirBrowse);
        this.setupLayoutForBrowse(tmpDirPath, component);
        JLabel lblTemporaryDirectory = new JLabel("Scratch working directory");
        JButton btnAdvance = new JButton("Advanced application configurations...");
        btnAdvance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ApplicationDescriptionAdvancedOptionDialog serviceDescriptionDialog = new ApplicationDescriptionAdvancedOptionDialog(ApplicationDescriptionDialog.this.getRegistry(), ApplicationDescriptionDialog.this.getShellApplicationDescription());
                    serviceDescriptionDialog.open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        this.cmbHostName = new JComboBox();
        this.cmbHostName.addActionListener(this);
        XBayaLabel lblHostName = new XBayaLabel("Application host", this.cmbHostName);
        XBayaLinkButton lnkNewHost = new XBayaLinkButton("New button");
        lnkNewHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HostDescriptionDialog hostDescriptionDialog = new HostDescriptionDialog(ApplicationDescriptionDialog.this.engine.getConfiguration().getAiravataAPI(), null);
                    hostDescriptionDialog.setLocationRelativeTo(ApplicationDescriptionDialog.this.getContentPane());
                    hostDescriptionDialog.open();
                    if (hostDescriptionDialog.isHostCreated()) {
                        ProgressMonitor progressMonitor = new ProgressMonitor(ApplicationDescriptionDialog.this.getContentPane(), "Host Descriptions", "Refreshing host list..", 0, 200);
                        int progress = 1;
                        progressMonitor.setProgress(progress++);
                        while (ApplicationDescriptionDialog.this.cmbHostName.getSelectedIndex() == -1 || !ApplicationDescriptionDialog.this.cmbHostName.getSelectedItem().toString().equals(hostDescriptionDialog.getHostLocation())) {
                            ApplicationDescriptionDialog.this.loadHostDescriptions();
                            ApplicationDescriptionDialog.this.cmbHostName.setSelectedItem(hostDescriptionDialog.getHostLocation());
                            progressMonitor.setProgress(progress++);
                            Thread.sleep(50L);
                        }
                        progressMonitor.setProgress(200);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        lnkNewHost.setText("Create new host...");
        lnkNewHost.setHorizontalAlignment(11);
        this.btnHostAdvanceOptions = new JButton("HPC Configuration...");
        this.btnHostAdvanceOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ApplicationDescriptionHostAdvancedOptionDialog hostAdvancedOptionsDialog = new ApplicationDescriptionHostAdvancedOptionDialog(ApplicationDescriptionDialog.this.getRegistry(), ApplicationDescriptionDialog.this.getShellApplicationDescription());
                    hostAdvancedOptionsDialog.open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getLocalizedMessage());
                }
            }
        });
        this.btnHostAdvanceOptions.setVisible(false);
        GridPanel hostPanel = new GridPanel();
        hostPanel.add(this.cmbHostName);
        hostPanel.add(this.btnHostAdvanceOptions);
        SwingUtil.layoutToGrid((Container)hostPanel.getSwingComponent(), (int)1, (int)2, (int)0, (int)0);
        GridPanel infoPanel0 = new GridPanel();
        infoPanel0.add(lblApplicationName);
        infoPanel0.add(this.txtAppName);
        GridPanel infoPanel1 = new GridPanel();
        infoPanel1.add(lblExecutablePath);
        infoPanel1.add(execPath);
        infoPanel1.add(lblTemporaryDirectory);
        infoPanel1.add(tmpDirPath);
        GridPanel infoPanel3 = new GridPanel();
        infoPanel3.add(lblHostName);
        infoPanel3.add(hostPanel);
        infoPanel3.add(new JLabel());
        infoPanel3.add(lnkNewHost);
        GridPanel infoPanel4 = new GridPanel();
        infoPanel4.add(new JLabel());
        infoPanel4.add(btnAdvance);
        infoPanel4.layout(1, 2, 0, 0);
        SwingUtil.layoutToGrid((Container)infoPanel0.getSwingComponent(), (int)1, (int)2, (int)-1, (int)1);
        SwingUtil.layoutToGrid((Container)infoPanel1.getSwingComponent(), (int)4, (int)1, (int)-1, (int)0);
        SwingUtil.layoutToGrid((Container)infoPanel3.getSwingComponent(), (int)2, (int)2, (int)-1, (int)1);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(infoPanel0);
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel1);
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel3);
        infoPanel.add(new JSeparator());
        infoPanel.add(infoPanel4);
        SwingUtil.layoutToGrid((Container)infoPanel.getSwingComponent(), (int)7, (int)1, (int)-1, (int)0);
        SwingUtil.layoutToGrid((Container)buttonPane.getSwingComponent(), (int)1, (int)buttonPane.getContentPanel().getComponentCount(), (int)-1, (int)0);
        this.getContentPane().add(infoPanel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        infoPanel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)-1, (int)0);
        this.loadHostDescriptions();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!this.isNewDescritor()) {
            this.loadData();
        }
        this.pack();
        if (this.getSize().getWidth() < 500.0) {
            this.setSize(500, this.getSize().height);
        }
    }

    private void setupLayoutForBrowse(JPanel tmpDirPath, JTextField component) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        layout.setConstraints(component, constraints);
        tmpDirPath.setLayout(layout);
    }

    private void loadData() {
        this.txtAppName.setText(this.getOriginalDescription().getType().getApplicationName().getStringValue());
        this.setApplicationName(this.txtAppName.getText());
        this.txtExecPath.setText(this.getOriginalDescription().getType().getExecutableLocation());
        this.setExecutablePath(this.txtExecPath.getText());
        this.txtTempDir.setText(this.getOriginalDescription().getType().getScratchWorkingDirectory());
        this.setTempDir(this.txtTempDir.getText());
        this.cmbHostName.setSelectedItem(this.getOriginalHost());
        this.setHostName(this.cmbHostName.getSelectedItem().toString());
        this.setServiceName(null);
        this.txtAppName.setEditable(this.isNewDescritor());
    }

    private void loadHostDescriptions() {
        this.cmbHostName.removeAllItems();
        this.setHostName(null);
        try {
            List hostDescriptions = this.getRegistry().getApplicationManager().getAllHostDescriptions();
            for (HostDescription hostDescription : hostDescriptions) {
                if (hostDescription.getType().getHostName() == null) {
                    this.cmbHostName.addItem(hostDescription.getType().getHostName());
                    continue;
                }
                this.cmbHostName.addItem(hostDescription.getType().getHostName());
            }
        }
        catch (Exception e) {
            this.setError(e.getLocalizedMessage());
        }
        this.updateHostName();
    }

    public ApplicationDescription getShellApplicationDescription() {
        if (this.shellApplicationDescription == null) {
            if (this.isNewDescritor()) {
                this.shellApplicationDescription = new ApplicationDescription();
            } else {
                try {
                    this.shellApplicationDescription = ApplicationDescription.fromXML((String)this.getOriginalDescription().toXML());
                }
                catch (XmlException xmlException) {
                    // empty catch block
                }
            }
        }
        return this.shellApplicationDescription;
    }

    public ApplicationDeploymentDescriptionType getApplicationDescriptionType() {
        return this.getShellApplicationDescription().getType();
    }

    public String getApplicationName() {
        return this.getApplicationDescriptionType().getApplicationName().getStringValue();
    }

    public void setApplicationName(String applicationName) {
        if (this.getApplicationDescriptionType().getApplicationName() == null) {
            this.getApplicationDescriptionType().addNewApplicationName();
        }
        this.getApplicationDescriptionType().getApplicationName().setStringValue(applicationName);
        this.updateDialogStatus();
    }

    public String getExecutablePath() {
        return this.getApplicationDescriptionType().getExecutableLocation();
    }

    public void setExecutablePath(String executablePath) {
        this.getApplicationDescriptionType().setExecutableLocation(executablePath);
        this.updateTempDirWithExecPath(executablePath);
        this.updateDialogStatus();
    }

    private void updateTempDirWithExecPath(String executablePath) {
        if (!(executablePath.trim().equals("") || this.txtExecPath.getSwingComponent().isFocusOwner() || this.getApplicationDescriptionType().getScratchWorkingDirectory() != null && !this.getApplicationDescriptionType().getScratchWorkingDirectory().trim().equalsIgnoreCase(""))) {
            String temp_location = "workflow_runs";
            String tempDir = new File(new File(executablePath).getParentFile(), temp_location).toString();
            this.txtTempDir.setText(tempDir);
            this.txtTempDir.getSwingComponent().setSelectionStart(tempDir.length() - temp_location.length());
            this.txtTempDir.getSwingComponent().setSelectionEnd(tempDir.length());
            this.setTempDir(this.txtTempDir.getText());
            this.txtTempDir.getSwingComponent().requestFocus();
        }
    }

    public String getTempDir() {
        return this.getApplicationDescriptionType().getScratchWorkingDirectory();
    }

    public void setTempDir(String tempDir) {
        this.getApplicationDescriptionType().setScratchWorkingDirectory(tempDir);
        this.updateDialogStatus();
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    public void saveApplicationDescription() {
        try {
            try {
                this.getRegistry().getApplicationManager().saveApplicationDescription(this.getServiceName(), this.getHostName(), this.getShellApplicationDescription());
            }
            catch (AiravataAPIInvocationException e) {
                this.getRegistry().getApplicationManager().updateApplicationDescriptor(this.getServiceName(), this.getHostName(), this.getShellApplicationDescription());
            }
            if (!(this.isNewDescritor() || this.getServiceName().equals(this.getOriginalService()) && this.getHostName().equals(this.getOriginalHost()))) {
                try {
                    this.getRegistry().getApplicationManager().deleteApplicationDescription(this.getOriginalService(), this.getOriginalHost(), this.getOriginalDescription().getType().getApplicationName().getStringValue());
                }
                catch (AiravataAPIInvocationException e) {
                    this.engine.getGUI().getErrorWindow().error(e);
                }
            }
            this.setApplicationDescCreated(true);
        }
        catch (AiravataAPIInvocationException e) {
            this.engine.getGUI().getErrorWindow().error(e);
        }
    }

    public boolean isApplicationDescCreated() {
        return this.applcationDescCreated;
    }

    public void setApplicationDescCreated(boolean applicationDescCreated) {
        this.applcationDescCreated = applicationDescCreated;
    }

    private void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().equals("")) {
            this.lblError.setText("");
        } else {
            this.lblError.setText(errorMessage.trim());
        }
    }

    private void updateDialogStatus() {
        String message = null;
        try {
            this.validateDialog();
        }
        catch (Exception e) {
            message = e.getLocalizedMessage();
        }
        this.okButton.setEnabled(message == null);
        this.setError(message);
    }

    private void validateDialog() throws Exception {
        if (this.getApplicationName() == null || this.getApplicationName().trim().equals("")) {
            throw new Exception("Name of the application cannot be empty!!!");
        }
        ApplicationDescription descriptions = null;
        descriptions = this.getRegistry().getApplicationManager().getApplicationDescriptor(this.getServiceName(), this.getHostName(), this.getApplicationName());
        if (!(descriptions == null || !this.isNewDescritor() && this.getServiceName().equals(this.getOriginalService()) && this.getHostName().equals(this.getOriginalHost()))) {
            throw new Exception("Application name already exists for the selected service & host!!!");
        }
        if (this.getExecutablePath() == null || this.getExecutablePath().trim().equals("")) {
            throw new Exception("Executable path cannot be empty!!!");
        }
        if (this.getTempDir() == null || this.getTempDir().trim().equals("")) {
            throw new Exception("Temporary directory location cannot be empty!!!");
        }
        if (this.getServiceName() == null || this.getServiceName().trim().equals("")) {
            throw new Exception("Click on IO Parameters...  to define parameters for the application");
        }
        if (this.getHostName() == null || this.getHostName().trim().equals("")) {
            throw new Exception("Please select/create host to bind to this deployment description");
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.updateDialogStatus();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        if (hostName != null) {
            try {
                HostDescription hostDescription = this.registry.getApplicationManager().getHostDescription(hostName);
                if (hostDescription.getType() instanceof GlobusHostType) {
                    this.getShellApplicationDescription().getType().changeType(HpcApplicationDeploymentType.type);
                } else {
                    this.getShellApplicationDescription().getType().changeType(ApplicationDeploymentDescriptionType.type);
                }
                this.btnHostAdvanceOptions.setVisible(hostDescription.getType() instanceof GlobusHostType);
                String hostAddress = hostDescription.getType().getHostAddress();
                boolean isLocal = this.isLocalAddress(hostAddress);
                this.btnExecBrowse.setVisible(isLocal);
                this.btnTmpDirBrowse.setVisible(isLocal);
            }
            catch (AiravataAPIInvocationException airavataAPIInvocationException) {
                // empty catch block
            }
        }
        this.updateDialogStatus();
    }

    private boolean isLocalAddress(String hostAddress) {
        return hostAddress.equalsIgnoreCase("localhost") || hostAddress.equalsIgnoreCase("127.0.0.1");
    }

    private void updateServiceName() {
        if (this.getServiceDescription() == null) {
            this.setServiceName(null);
        } else {
            this.setServiceName(this.getServiceDescription().getType().getName());
        }
    }

    private void updateHostName() {
        if (this.cmbHostName.getSelectedItem() != null) {
            this.setHostName(this.cmbHostName.getSelectedItem().toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbHostName) {
            this.updateHostName();
        }
        if (e.getSource() == this.txtAppName) {
            this.setApplicationName(this.txtAppName.getText());
        }
        if (e.getSource() == this.txtExecPath) {
            this.setExecutablePath(this.txtExecPath.getText());
        }
        if (e.getSource() == this.txtTempDir) {
            this.setTempDir(this.txtTempDir.getText());
        }
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }

    public boolean isNewDescritor() {
        return this.newDescritor;
    }

    public void setNewDescritor(boolean newDescritor) {
        this.newDescritor = newDescritor;
    }

    public ApplicationDescription getOriginalDescription() {
        return this.originalDescription;
    }

    public void setOriginalDescription(ApplicationDescription originalDescription) {
        this.originalDescription = originalDescription;
    }

    public String getOriginalService() {
        return this.originalService;
    }

    public void setOriginalService(String originalService) {
        this.originalService = originalService;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public void setOriginalHost(String originalHost) {
        this.originalHost = originalHost;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    private void setServiceDescription(ServiceDescription serviceDescription) {
        this.serviceDescription = serviceDescription;
        this.updateServiceName();
    }
}

