/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.descriptors;

import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.common.utils.SwingUtil;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.NameValuePairType;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class ApplicationDescriptionAdvancedOptionDialog
extends JDialog {
    private static final long serialVersionUID = 3920479739097405014L;
    private XBayaTextField txtInputDir;
    private XBayaTextField txtOutputDir;
    private XBayaTextField txtSTDIN;
    private XBayaTextField txtSTDOUT;
    private XBayaTextField txtSTDERR;
    private JTable tblEnv;
    private ApplicationDescription shellApplicationDescription;
    private DefaultTableModel defaultTableModel;
    private boolean tableModelChanging = false;
    private JButton btnDeleteVariable;
    private JButton okButton;
    private AiravataAPI registry;
    private XBayaTextField txtWorkingDir;

    public static void main(String[] args) {
        try {
            ApplicationDescriptionAdvancedOptionDialog dialog = new ApplicationDescriptionAdvancedOptionDialog(null, null);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApplicationDescriptionAdvancedOptionDialog(AiravataAPI registry, ApplicationDescription descriptor) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                ApplicationDescriptionAdvancedOptionDialog.this.loadApplicationDescriptionAdvancedOptions();
            }
        });
        this.setRegistry(registry);
        this.setShellApplicationDescription(descriptor);
        this.initGUI();
    }

    public void open() {
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected ApplicationDescriptionAdvancedOptionDialog getDialog() {
        return this;
    }

    public void close() {
        this.getDialog().setVisible(false);
    }

    private void initGUI() {
        this.setTitle("Application Description Advance Options");
        this.setModal(true);
        this.setBounds(100, 100, 600, 400);
        this.setLocationRelativeTo(null);
        GridPanel buttonPane = new GridPanel();
        this.okButton = new JButton("Update");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionAdvancedOptionDialog.this.saveApplicationDescriptionAdvancedOptions();
                ApplicationDescriptionAdvancedOptionDialog.this.close();
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionAdvancedOptionDialog.this.close();
            }
        });
        GridPanel panel = new GridPanel();
        this.txtInputDir = new XBayaTextField();
        XBayaLabel lblInputDirectory = new XBayaLabel("Input directory", this.txtInputDir);
        JLabel lblLocations = new JLabel("Locations");
        lblLocations.setFont(new Font("Tahoma", 1, 11));
        this.txtOutputDir = new XBayaTextField();
        XBayaLabel lblOutputDirectory = new XBayaLabel("Output directory", this.txtOutputDir);
        this.txtWorkingDir = new XBayaTextField();
        XBayaLabel lblWorkingDir = new XBayaLabel("Static Working directory", this.txtWorkingDir);
        JLabel lblProgramData = new JLabel("Program data");
        lblProgramData.setFont(new Font("Tahoma", 1, 11));
        this.txtSTDIN = new XBayaTextField();
        XBayaLabel lblStdin = new XBayaLabel("STDIN", this.txtSTDIN);
        this.txtSTDOUT = new XBayaTextField();
        XBayaLabel lblStdout = new XBayaLabel("STDOUT", this.txtSTDOUT);
        this.txtSTDERR = new XBayaTextField();
        XBayaLabel lblStderr = new XBayaLabel("STDERR", this.txtSTDERR);
        JLabel other = new JLabel("Other");
        other.setFont(new Font("Tahoma", 1, 11));
        JSeparator separator_1 = new JSeparator();
        separator_1.setOrientation(1);
        JLabel lblEnvironmentalVariables = new JLabel("Environmental Variables");
        lblEnvironmentalVariables.setFont(new Font("Tahoma", 1, 11));
        JScrollPane scrollPane = new JScrollPane();
        this.btnDeleteVariable = new JButton("Delete variable");
        this.btnDeleteVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDescriptionAdvancedOptionDialog.this.deleteSelectedRows();
            }
        });
        this.btnDeleteVariable.setEnabled(false);
        this.tblEnv = new JTable();
        this.tblEnv.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.tblEnv);
        this.tblEnv.setSelectionMode(0);
        this.defaultTableModel = new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Value"}){
            Class[] columnTypes;
            {
                this.columnTypes = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }
        };
        this.tblEnv.setModel(this.defaultTableModel);
        this.defaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (!ApplicationDescriptionAdvancedOptionDialog.this.tableModelChanging) {
                    ApplicationDescriptionAdvancedOptionDialog.this.addNewRowIfLastIsNotEmpty();
                }
            }
        });
        this.tblEnv.getColumnModel().getColumn(0).setPreferredWidth(67);
        this.tblEnv.getColumnModel().getColumn(1).setPreferredWidth(158);
        ListSelectionModel selectionModel = this.tblEnv.getSelectionModel();
        selectionModel.setSelectionMode(2);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ApplicationDescriptionAdvancedOptionDialog.this.btnDeleteVariable.setEnabled(ApplicationDescriptionAdvancedOptionDialog.this.tblEnv.getSelectedRows().length > 0);
            }
        });
        GridPanel leftPanel = new GridPanel();
        leftPanel.add(lblLocations);
        leftPanel.add(new JLabel());
        leftPanel.add(lblInputDirectory);
        leftPanel.add(this.txtInputDir);
        leftPanel.add(lblOutputDirectory);
        leftPanel.add(this.txtOutputDir);
        leftPanel.add(lblWorkingDir);
        leftPanel.add(this.txtWorkingDir);
        leftPanel.add(lblProgramData);
        leftPanel.add(new JLabel());
        leftPanel.add(lblStdin);
        leftPanel.add(this.txtSTDIN);
        leftPanel.add(lblStdout);
        leftPanel.add(this.txtSTDOUT);
        leftPanel.add(lblStderr);
        leftPanel.add(this.txtSTDERR);
        SwingUtil.layoutToGrid((Container)leftPanel.getSwingComponent(), (int)8, (int)2, (int)-1, (int)1);
        GridPanel rightPanel = new GridPanel();
        rightPanel.add(lblEnvironmentalVariables);
        rightPanel.add(scrollPane);
        rightPanel.add(this.btnDeleteVariable);
        rightPanel.getSwingComponent().setSize(150, -1);
        leftPanel.getSwingComponent().setSize(150, -1);
        SwingUtil.layoutToGrid((Container)rightPanel.getSwingComponent(), (int)3, (int)1, (int)1, (int)0);
        GridPanel p = new GridPanel();
        p.add(leftPanel);
        p.add(new JSeparator(1));
        p.layout(1, 2, 0, 0);
        panel.add(p);
        panel.add(rightPanel);
        panel.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        SwingUtil.layoutToGrid((Container)panel.getSwingComponent(), (int)1, (int)2, (int)-1, (int)-2);
        buttonPane.add(this.okButton);
        buttonPane.add(cancelButton);
        buttonPane.getSwingComponent().setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(panel.getSwingComponent());
        this.getContentPane().add(buttonPane.getSwingComponent());
        SwingUtil.layoutToGrid((Container)this.getContentPane(), (int)2, (int)1, (int)0, (int)0);
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void deleteSelectedRows() {
        int selectedRow = this.tblEnv.getSelectedRow();
        while (selectedRow >= 0) {
            this.defaultTableModel.removeRow(selectedRow);
            selectedRow = this.tblEnv.getSelectedRow();
        }
        this.addNewRowIfLastIsNotEmpty();
    }

    public ApplicationDescription getApplicationDescription() {
        return this.shellApplicationDescription;
    }

    public ApplicationDeploymentDescriptionType getShellApplicationDescriptionType() {
        return this.shellApplicationDescription.getType();
    }

    public void setShellApplicationDescription(ApplicationDescription shellApplicationDescription) {
        this.shellApplicationDescription = shellApplicationDescription;
    }

    private void addNewRowIfLastIsNotEmpty() {
        Object varName = null;
        if (this.defaultTableModel.getRowCount() > 0) {
            varName = this.defaultTableModel.getValueAt(this.defaultTableModel.getRowCount() - 1, 0);
        }
        if (this.defaultTableModel.getRowCount() == 0 || varName != null && !varName.equals("")) {
            this.defaultTableModel.addRow(new Object[]{null, null});
        }
    }

    private void saveApplicationDescriptionAdvancedOptions() {
        this.getShellApplicationDescriptionType().setInputDataDirectory(this.txtInputDir.getText());
        this.getShellApplicationDescriptionType().setOutputDataDirectory(this.txtOutputDir.getText());
        this.getShellApplicationDescriptionType().setStaticWorkingDirectory(this.txtWorkingDir.getText());
        this.getShellApplicationDescriptionType().setStandardInput(this.txtSTDIN.getText());
        this.getShellApplicationDescriptionType().setStandardOutput(this.txtSTDOUT.getText());
        this.getShellApplicationDescriptionType().setStandardError(this.txtSTDERR.getText());
        while (this.getShellApplicationDescriptionType().getApplicationEnvironmentArray().length > 0) {
            this.getShellApplicationDescriptionType().removeApplicationEnvironment(0);
        }
        for (int i = 0; i < this.defaultTableModel.getRowCount(); ++i) {
            String parameterName = (String)this.defaultTableModel.getValueAt(i, 0);
            String paramValue = (String)this.defaultTableModel.getValueAt(i, 1);
            if (parameterName == null || parameterName.trim().equals("")) continue;
            NameValuePairType envType = this.getShellApplicationDescriptionType().addNewApplicationEnvironment();
            envType.setName(parameterName);
            envType.setValue(paramValue);
        }
    }

    private void loadApplicationDescriptionAdvancedOptions() {
        NameValuePairType[] envParams;
        this.txtInputDir.setText(this.getShellApplicationDescriptionType().getInputDataDirectory());
        this.txtOutputDir.setText(this.getShellApplicationDescriptionType().getOutputDataDirectory());
        this.txtWorkingDir.setText(this.getShellApplicationDescriptionType().getStaticWorkingDirectory());
        this.txtSTDIN.setText(this.getShellApplicationDescriptionType().getStandardInput());
        this.txtSTDOUT.setText(this.getShellApplicationDescriptionType().getStandardOutput());
        this.txtSTDERR.setText(this.getShellApplicationDescriptionType().getStandardError());
        this.tableModelChanging = true;
        while (this.defaultTableModel.getRowCount() > 0) {
            this.defaultTableModel.removeRow(0);
        }
        for (NameValuePairType envParam : envParams = this.getShellApplicationDescriptionType().getApplicationEnvironmentArray()) {
            this.defaultTableModel.addRow(new Object[]{envParam.getName(), envParam.getValue()});
        }
        this.addNewRowIfLastIsNotEmpty();
        this.tableModelChanging = false;
    }

    public AiravataAPI getRegistry() {
        return this.registry;
    }

    public void setRegistry(AiravataAPI registry) {
        this.registry = registry;
    }
}

