/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.component;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.web.WebComponentRegistry;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentRegistryLoader;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class WebResigtryWindow {
    private XBayaEngine engine;
    private ComponentRegistryLoader loader;
    private XBayaDialog dialog;
    private XBayaTextField urlTextField;

    public WebResigtryWindow(XBayaEngine engine) {
        this.engine = engine;
        this.loader = ComponentRegistryLoader.getLoader(this.engine, "registry.type.web");
        this.initGUI();
    }

    public void show() {
        if (this.urlTextField.getText().length() == 0) {
            this.urlTextField.setText(XBayaConstants.DEFAULT_WEB_REGISTRY.toString());
        }
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void ok() {
        URL url;
        String urlString = this.urlTextField.getText();
        if (urlString.length() == 0) {
            this.engine.getGUI().getErrorWindow().error("URL cannot be empty.");
            return;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            this.engine.getGUI().getErrorWindow().error("URL is in wrong format.", e);
            return;
        }
        WebComponentRegistry registry = new WebComponentRegistry(url);
        this.hide();
        this.loader.load((ComponentRegistry)registry);
    }

    private void initGUI() {
        this.urlTextField = new XBayaTextField();
        XBayaLabel urlLabel = new XBayaLabel("URL", this.urlTextField);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(urlLabel);
        infoPanel.add(this.urlTextField);
        infoPanel.layout(1, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebResigtryWindow.this.ok();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebResigtryWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Web Registry", (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

