/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.component;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.url.URLComponentRegistry;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentRegistryLoader;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class URLRegistryWindow {
    private XBayaEngine engine;
    private ComponentRegistryLoader loader;
    private XBayaDialog dialog;
    private XBayaTextField urlTextField;

    public URLRegistryWindow(XBayaEngine engine) {
        this.engine = engine;
        this.loader = ComponentRegistryLoader.getLoader(this.engine, "registry.type.url");
        this.initGUI();
    }

    public void show() {
        this.dialog.show();
    }

    private void hide() {
        this.dialog.hide();
    }

    private void ok() {
        URI url;
        String urlString = this.urlTextField.getText();
        if (urlString.length() == 0) {
            this.engine.getGUI().getErrorWindow().error("URL cannot be empty.");
            return;
        }
        try {
            url = new URI(urlString);
        }
        catch (URISyntaxException e) {
            this.engine.getGUI().getErrorWindow().error("URL is in wrong format.", e);
            return;
        }
        URLComponentRegistry registry = new URLComponentRegistry(url);
        this.hide();
        this.loader.load((ComponentRegistry)registry);
    }

    private void initGUI() {
        this.urlTextField = new XBayaTextField();
        XBayaLabel urlLabel = new XBayaLabel("URL", this.urlTextField);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(urlLabel);
        infoPanel.add(this.urlTextField);
        infoPanel.layout(1, 2, -1, 1);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLRegistryWindow.this.ok();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLRegistryWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Web Registry", (XBayaComponent)infoPanel, (JComponent)buttonPanel);
        this.dialog.setDefaultButton(okButton);
    }
}

