/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.apache.airavata.xbaya.ui.widgets.amazon.S3Tree;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Object;

public class S3Uploader
implements Cancelable {
    private XBayaEngine engine;
    private JDialog parent;
    private boolean canceled;
    private WaitDialog loadingDialog;

    public S3Uploader(XBayaEngine engine, JDialog parent) {
        this.engine = engine;
        this.parent = parent;
        this.loadingDialog = new WaitDialog(this, "Uploading file to S3.", "Uploading file to S3.\nPlease wait for a moment.", this.engine.getGUI());
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public void upload(final S3Service s3, final S3Tree s3tree, final String bucket, final String filePath) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int index = filePath.lastIndexOf(47);
                if (index == -1) {
                    index = filePath.lastIndexOf(92);
                }
                String fileName = filePath.substring(index + 1, filePath.length());
                try {
                    S3Object s3Object = new S3Object(new File(filePath));
                    s3.putObject(bucket, s3Object);
                    if (S3Uploader.this.canceled) {
                        s3.deleteObject(bucket, s3Object.getKey());
                    } else {
                        S3Uploader.this.engine.getGUI().getErrorWindow().info(S3Uploader.this.parent, "", "Uploaded successfully!");
                        int startIndex = bucket.lastIndexOf(47);
                        int n = startIndex = startIndex >= 0 ? startIndex : 0;
                        if (startIndex != 0) {
                            fileName = bucket.substring(startIndex) + '/' + fileName;
                        }
                        if (fileName.startsWith("/")) {
                            fileName = fileName.substring(1, fileName.length());
                        }
                        s3tree.addObject(bucket, (Object)fileName);
                    }
                }
                catch (Exception ex) {
                    S3Uploader.this.engine.getGUI().getErrorWindow().error((Component)S3Uploader.this.parent, "Upload failed! Please ensure every fields are filled correctly", ex);
                }
                finally {
                    S3Uploader.this.loadingDialog.hide();
                }
            }
        }).start();
        this.loadingDialog.show();
    }
}

