/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JDialog;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Object;

public class S3Downloader
implements Cancelable {
    private XBayaEngine engine;
    private JDialog parent;
    private boolean canceled;
    private WaitDialog loadingDialog;

    public S3Downloader(XBayaEngine engine, JDialog parent) {
        this.engine = engine;
        this.parent = parent;
        this.loadingDialog = new WaitDialog(this, "Downloading file from S3.", "Downloading file from S3.\nPlease wait for a moment.", this.engine.getGUI());
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public void download(final S3Service s3, final String bucket, final String key, final String directory) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedWriter out = null;
                BufferedReader in = null;
                try {
                    S3Object s3Object = s3.getObject(bucket, key);
                    File fileOut = new File(directory + File.separator + s3Object.getKey());
                    if (!fileOut.getParentFile().exists()) {
                        fileOut.getParentFile().mkdirs();
                    }
                    if (!fileOut.exists()) {
                        fileOut.createNewFile();
                    }
                    out = new BufferedWriter(new FileWriter(fileOut));
                    in = new BufferedReader(new InputStreamReader(s3Object.getDataInputStream()));
                    String data = null;
                    while ((data = in.readLine()) != null) {
                        if (S3Downloader.this.canceled) {
                            out.close();
                            fileOut.delete();
                            return;
                        }
                        out.write(data);
                        out.newLine();
                    }
                    S3Downloader.this.engine.getGUI().getErrorWindow().info(S3Downloader.this.parent, "", "Downloaded successfully!");
                }
                catch (Exception ex) {
                    S3Downloader.this.engine.getGUI().getErrorWindow().error((Component)S3Downloader.this.parent, "Download failed! Please ensure every fields are filled correctly", ex);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException io) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    S3Downloader.this.loadingDialog.hide();
                }
            }
        }).start();
        this.loadingDialog.show();
    }
}

