/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.model.Instance;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.amazon.EC2InstanceResult;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.apache.airavata.xbaya.ui.widgets.XbayaEnhancedList;
import org.apache.airavata.xbaya.util.AmazonUtil;

public class InstancesLoader
implements Cancelable {
    private XBayaEngine engine;
    private JDialog parent;
    private boolean canceled;
    private WaitDialog loadingDialog;

    public InstancesLoader(XBayaEngine engine, JDialog parent) {
        this.engine = engine;
        this.parent = parent;
        this.loadingDialog = new WaitDialog(this, "Loading EC2 Instances.", "Loading EC2 Instances.\nPlease wait for a moment.", this.engine.getGUI());
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public void load(final XbayaEnhancedList<EC2InstanceResult> list) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ArrayList<EC2InstanceResult> tmpList = new ArrayList<EC2InstanceResult>();
                    List<Instance> instances = AmazonUtil.loadInstances();
                    for (Instance instance : instances) {
                        tmpList.add(new EC2InstanceResult(instance));
                    }
                    if (!InstancesLoader.this.canceled) {
                        list.setListData(tmpList);
                    }
                }
                catch (AmazonServiceException ex) {
                    InstancesLoader.this.engine.getGUI().getErrorWindow().error((Component)InstancesLoader.this.parent, "Cannot load EC2 instances", ex);
                }
                catch (AmazonClientException ex) {
                    InstancesLoader.this.engine.getGUI().getErrorWindow().error((Component)InstancesLoader.this.parent, "Cannot load EC2 instances", ex);
                }
                finally {
                    InstancesLoader.this.loadingDialog.hide();
                }
            }
        }).start();
        this.loadingDialog.show();
    }
}

