/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComboBox;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;
import org.apache.airavata.xbaya.util.AmazonUtil;

public class EC2LaunchWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XBayaTextField amiTextField;
    private JSpinner numberOfInstanceSpinner;
    private XBayaComboBox instanceTypeComboBox;
    private XBayaComboBox keyComboBox;
    private JRadioButton existKeyButton;
    private ComboBoxModel keyComboBoxModel;

    public EC2LaunchWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGUI();
    }

    private void initGUI() {
        this.amiTextField = new XBayaTextField();
        XBayaLabel amiLabel = new XBayaLabel("AMI ID", this.amiTextField);
        this.numberOfInstanceSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        XBayaLabel nInstanceLabel = new XBayaLabel("Number Of Instances", this.numberOfInstanceSpinner);
        this.instanceTypeComboBox = new XBayaComboBox(new DefaultComboBoxModel<String>(AmazonUtil.INSTANCE_TYPE));
        this.instanceTypeComboBox.setSelectedItem(AmazonUtil.INSTANCE_TYPE[1]);
        XBayaLabel instanceTypeLabel = new XBayaLabel("Instance Type", this.instanceTypeComboBox);
        JRadioButton noKeyButton = new JRadioButton("No Key Pair");
        noKeyButton.setSelected(true);
        noKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                EC2LaunchWindow.this.keyComboBox.getJComboBox().setEnabled(false);
            }
        });
        this.existKeyButton = new JRadioButton("Exist Key Pairs");
        this.existKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                if (EC2LaunchWindow.this.keyComboBoxModel == null) {
                    EC2LaunchWindow.this.keyComboBoxModel = new DefaultComboBoxModel<Object>(AmazonUtil.loadKeypairs().toArray());
                    EC2LaunchWindow.this.keyComboBox.setModel(EC2LaunchWindow.this.keyComboBoxModel);
                }
                EC2LaunchWindow.this.keyComboBox.getJComboBox().setEnabled(true);
            }
        });
        ButtonGroup serviceTypeButtonGroup = new ButtonGroup();
        serviceTypeButtonGroup.add(noKeyButton);
        serviceTypeButtonGroup.add(this.existKeyButton);
        this.keyComboBox = new XBayaComboBox(new DefaultComboBoxModel());
        this.keyComboBox.getJComboBox().setEnabled(false);
        GridPanel radioPanel = new GridPanel();
        radioPanel.add(noKeyButton);
        radioPanel.add(new JPanel());
        radioPanel.add(this.existKeyButton);
        radioPanel.add(this.keyComboBox);
        radioPanel.layout(2, 2, 0, 1);
        XBayaLabel keyLabel = new XBayaLabel("Key Pair", radioPanel);
        GridPanel mainPanel = new GridPanel(true);
        mainPanel.add(amiLabel);
        mainPanel.add(this.amiTextField);
        mainPanel.add(nInstanceLabel);
        mainPanel.add(this.numberOfInstanceSpinner);
        mainPanel.add(instanceTypeLabel);
        mainPanel.add(this.instanceTypeComboBox);
        mainPanel.add(keyLabel);
        mainPanel.add(radioPanel);
        mainPanel.layout(4, 2, 0, -2);
        JButton lunchButton = new JButton("Launch");
        lunchButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EC2LaunchWindow.this.amiTextField.getText() == null || EC2LaunchWindow.this.amiTextField.getText().isEmpty() || (Integer)EC2LaunchWindow.this.numberOfInstanceSpinner.getValue() <= 0) {
                    EC2LaunchWindow.this.engine.getGUI().getErrorWindow().info(EC2LaunchWindow.this.dialog.getDialog(), "Warning", "Please input all fields");
                    return;
                }
                try {
                    String ami = EC2LaunchWindow.this.amiTextField.getText();
                    String instanceType = EC2LaunchWindow.this.instanceTypeComboBox.getText();
                    Integer n = (Integer)EC2LaunchWindow.this.numberOfInstanceSpinner.getValue();
                    if (EC2LaunchWindow.this.existKeyButton.isSelected()) {
                        String keyname = EC2LaunchWindow.this.keyComboBox.getText();
                        AmazonUtil.launchInstance(ami, instanceType, n, keyname);
                    } else {
                        AmazonUtil.launchInstance(ami, instanceType, n);
                    }
                    EC2LaunchWindow.this.hide();
                }
                catch (NumberFormatException nfe) {
                    EC2LaunchWindow.this.engine.getGUI().getErrorWindow().info(EC2LaunchWindow.this.dialog.getDialog(), "Warning", "Number of Instances is not numeric");
                }
                catch (Exception ex) {
                    EC2LaunchWindow.this.engine.getGUI().getErrorWindow().error((Component)EC2LaunchWindow.this.dialog.getDialog(), "Cannot start EC2 instances: " + ex.getMessage(), ex);
                }
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EC2LaunchWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(lunchButton);
        buttonPanel.add(closeButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Amazon EC2 Launcher", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
    }

    public void hide() {
        this.dialog.hide();
    }

    public void show() {
        this.dialog.show();
    }
}

