/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.amazon.AmazonCredential;
import org.apache.airavata.xbaya.core.amazon.EC2InstanceResult;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.dialogs.amazon.ChangeCredentialWindow;
import org.apache.airavata.xbaya.ui.dialogs.amazon.EC2LaunchWindow;
import org.apache.airavata.xbaya.ui.dialogs.amazon.InstancesLoader;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XbayaEnhancedList;
import org.apache.airavata.xbaya.util.AmazonUtil;

public class EC2InstancesManagementWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XbayaEnhancedList<EC2InstanceResult> list;
    private ChangeCredentialWindow credentialWindow;

    public EC2InstancesManagementWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGUI();
    }

    public void show() {
        this.dialog.show();
    }

    public void hide() {
        this.dialog.hide();
    }

    private void initGUI() {
        this.list = new XbayaEnhancedList();
        GridPanel mainPanel = new GridPanel();
        TitledBorder border = new TitledBorder(new EtchedBorder(), "My Instances");
        mainPanel.getSwingComponent().setBorder(border);
        mainPanel.add(this.list);
        mainPanel.layout(1, 1, 0, 0);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EC2InstancesManagementWindow.this.credentialSet()) {
                    InstancesLoader instancesLoader = new InstancesLoader(EC2InstancesManagementWindow.this.engine, EC2InstancesManagementWindow.this.dialog.getDialog());
                    instancesLoader.load(EC2InstancesManagementWindow.this.list);
                }
            }
        });
        JButton launchButton = new JButton("Launch");
        launchButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EC2InstancesManagementWindow.this.credentialSet()) {
                    EC2LaunchWindow ec2LaunchWindow = new EC2LaunchWindow(EC2InstancesManagementWindow.this.engine);
                    ec2LaunchWindow.show();
                }
            }
        });
        JButton terminateButton = new JButton("Terminate");
        terminateButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selected = EC2InstancesManagementWindow.this.list.getSelectedValues();
                if (selected.size() == 0) {
                    EC2InstancesManagementWindow.this.engine.getGUI().getErrorWindow().info(EC2InstancesManagementWindow.this.dialog.getDialog(), "Warning", "No instances selected");
                    return;
                }
                String text = "";
                ArrayList<String> requestIds = new ArrayList<String>();
                for (EC2InstanceResult ec2InstancesResult : selected) {
                    requestIds.add(ec2InstancesResult.getInstance().getInstanceId());
                    text = text + ec2InstancesResult.getInstance().getInstanceId() + ",";
                }
                int n = JOptionPane.showConfirmDialog(EC2InstancesManagementWindow.this.dialog.getDialog(), "Are you want to terminate instances:\n" + text, "Terminate Instances", 0, 2);
                if (n == 0) {
                    AmazonUtil.terminateInstances(requestIds);
                    InstancesLoader instancesLoader = new InstancesLoader(EC2InstancesManagementWindow.this.engine, EC2InstancesManagementWindow.this.dialog.getDialog());
                    instancesLoader.load(EC2InstancesManagementWindow.this.list);
                }
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EC2InstancesManagementWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(refreshButton);
        buttonPanel.add(launchButton);
        buttonPanel.add(terminateButton);
        buttonPanel.add(closeButton);
        this.dialog = new XBayaDialog(this.engine.getGUI(), "Amazon EC2 Management Console", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
        int width = 800;
        int height = 500;
        this.dialog.getDialog().setPreferredSize(new Dimension(width, height));
        this.dialog.setDefaultButton(closeButton);
    }

    private boolean credentialSet() {
        if (AmazonCredential.getInstance().getAwsAccessKeyId().isEmpty() || AmazonCredential.getInstance().getAwsSecretAccessKey().isEmpty()) {
            this.engine.getGUI().getErrorWindow().warning(this.dialog.getDialog(), "Error", "Aws Access Key not set!");
            if (this.credentialWindow == null) {
                this.credentialWindow = new ChangeCredentialWindow(this.dialog.getDialog());
            }
            try {
                this.credentialWindow.show();
                return false;
            }
            catch (Exception e1) {
                this.engine.getGUI().getErrorWindow().error(e1);
            }
        }
        return true;
    }
}

