/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.ui.dialogs.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.airavata.gfac.provider.utils.EC2ProviderUtil;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.core.amazon.AmazonCredential;
import org.apache.airavata.xbaya.ui.dialogs.XBayaDialog;
import org.apache.airavata.xbaya.ui.widgets.GridPanel;
import org.apache.airavata.xbaya.ui.widgets.XBayaComponent;
import org.apache.airavata.xbaya.ui.widgets.XBayaLabel;
import org.apache.airavata.xbaya.ui.widgets.XBayaTextField;

public class ChangeCredentialWindow {
    private XBayaEngine engine;
    private XBayaDialog dialog;
    private XBayaTextField accessKeyIDTextField;
    private XBayaTextField secretAccessKeyTextField;
    private JDialog owner;

    public ChangeCredentialWindow(XBayaEngine engine) {
        this.engine = engine;
        this.initGUI();
    }

    public ChangeCredentialWindow(JDialog owner) {
        this.owner = owner;
        this.initGUI();
    }

    protected void initGUI() {
        this.accessKeyIDTextField = new XBayaTextField();
        XBayaLabel accessKeyIDLabel = new XBayaLabel("Access Key", this.accessKeyIDTextField);
        this.secretAccessKeyTextField = new XBayaTextField();
        XBayaLabel secretAccessKeyLabel = new XBayaLabel("Secret Key", this.secretAccessKeyTextField);
        GridPanel infoPanel = new GridPanel();
        infoPanel.add(accessKeyIDLabel);
        infoPanel.add(this.accessKeyIDTextField);
        infoPanel.add(secretAccessKeyLabel);
        infoPanel.add(this.secretAccessKeyTextField);
        infoPanel.layout(2, 2, -1, 1);
        GridPanel mainPanel = new GridPanel();
        mainPanel.add(infoPanel);
        mainPanel.layout(1, 1, -2, -2);
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String secretID;
                String accessID = ChangeCredentialWindow.this.accessKeyIDTextField.getText();
                if (!"".equals(accessID) && !"".equals(secretID = ChangeCredentialWindow.this.secretAccessKeyTextField.getText())) {
                    AmazonCredential.getInstance().setAwsAccessKeyId(accessID);
                    AmazonCredential.getInstance().setAwsSecretAccessKey(secretID);
                    ChangeCredentialWindow.this.hide();
                    return;
                }
                JOptionPane.showMessageDialog(ChangeCredentialWindow.this.dialog.getDialog(), "SecretKey and AccessKey can not be empty!");
            }
        });
        JButton generateButton = new JButton("Generate Key Pair");
        generateButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String secretID;
                String accessID = ChangeCredentialWindow.this.accessKeyIDTextField.getText();
                if (!"".equals(accessID) && !"".equals(secretID = ChangeCredentialWindow.this.secretAccessKeyTextField.getText())) {
                    AmazonCredential.getInstance().setAwsAccessKeyId(accessID);
                    AmazonCredential.getInstance().setAwsSecretAccessKey(secretID);
                    File file = new File(System.getProperty("user.home") + "/.ssh/" + "ec2_rsa");
                    if (file.exists()) {
                        ChangeCredentialWindow.this.engine.getGUI().getErrorWindow().info(ChangeCredentialWindow.this.dialog.getDialog(), "Warning", "The file " + file.getAbsolutePath() + " exists.");
                    } else {
                        BasicAWSCredentials credential = new BasicAWSCredentials(accessID, secretID);
                        AmazonEC2Client ec2client = new AmazonEC2Client((AWSCredentials)credential);
                        try {
                            EC2ProviderUtil.buildKeyPair((AmazonEC2Client)ec2client, (String)"ec2_rsa");
                        }
                        catch (NoSuchAlgorithmException e1) {
                            ChangeCredentialWindow.this.engine.getGUI().getErrorWindow().info(ChangeCredentialWindow.this.dialog.getDialog(), "Warning", e1.getMessage());
                        }
                        catch (InvalidKeySpecException e1) {
                            ChangeCredentialWindow.this.engine.getGUI().getErrorWindow().info(ChangeCredentialWindow.this.dialog.getDialog(), "Warning", e1.getMessage());
                        }
                        catch (IOException e1) {
                            ChangeCredentialWindow.this.engine.getGUI().getErrorWindow().info(ChangeCredentialWindow.this.dialog.getDialog(), "Warning", e1.getMessage());
                        }
                        JOptionPane.showMessageDialog(ChangeCredentialWindow.this.dialog.getDialog(), "The key " + file.getAbsolutePath() + " generated.");
                    }
                    ChangeCredentialWindow.this.hide();
                    return;
                }
                JOptionPane.showMessageDialog(ChangeCredentialWindow.this.dialog.getDialog(), "SecretKey and AccessKey can not be empty!");
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeCredentialWindow.this.hide();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(generateButton);
        buttonPanel.add(cancelButton);
        this.dialog = this.owner == null ? new XBayaDialog(this.engine.getGUI(), "Security Credentials", (XBayaComponent)mainPanel, (JComponent)buttonPanel) : new XBayaDialog((Window)this.owner, "Security Credentials", (XBayaComponent)mainPanel, (JComponent)buttonPanel);
    }

    public void hide() {
        this.dialog.hide();
    }

    public void show() {
        if (!"".equals(AmazonCredential.getInstance().getAwsAccessKeyId())) {
            this.accessKeyIDTextField.setText(AmazonCredential.getInstance().getAwsAccessKeyId());
        }
        if (!"".equals(AmazonCredential.getInstance().getAwsSecretAccessKey())) {
            this.secretAccessKeyTextField.setText(AmazonCredential.getInstance().getAwsSecretAccessKey());
        }
        this.dialog.show();
    }
}

